/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.facelets.ajax;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.render.ajax.AjaxRenderKitImpl;

public class AjaxUpdaterHandler
extends ComponentHandler {
    public AjaxUpdaterHandler(ComponentConfig config) {
        super(config);
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        FacesContext context;
        String subviewId;
        AjaxUpdater updater = (AjaxUpdater)c;
        if (Boolean.TRUE.equals(updater.getFrame())) {
            return;
        }
        boolean isAjaxResponse = AjaxRenderKitImpl.isAjaxResponse((FacesContext)ctx.getFacesContext());
        if (!isAjaxResponse) {
            c.getChildren().clear();
        }
        if (c.getAttributes().get("layout") == null) {
            c.getAttributes().put("layout", "block");
        }
        if ((subviewId = this.getSubViewIdFromRequest(context = ctx.getFacesContext(), c, parent)) != null) {
            this.restoreSubview(context, (AjaxUpdater)c, subviewId);
        }
    }

    private String getSubViewIdFromRequest(FacesContext context, UIComponent c, UIComponent parent) {
        String clientId = null;
        if (c.getParent() == null) {
            UIComponent namingContainer;
            clientId = c.getId();
            for (namingContainer = parent; namingContainer != null && !(namingContainer instanceof NamingContainer); namingContainer = namingContainer.getParent()) {
            }
            String parentId = null;
            if (namingContainer != null) {
                parentId = namingContainer.getContainerClientId(context);
            }
            if (parentId != null) {
                clientId = parentId + ':' + clientId;
            }
        } else {
            clientId = c.getClientId(context);
        }
        String subviewId = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (subviewId == null || subviewId.length() == 0) {
            return null;
        }
        return subviewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSubview(FacesContext ctx, AjaxUpdater updater, String subviewId) {
        UIViewRoot ourView = ctx.getViewRoot();
        UIViewRootWrapper targetView = new UIViewRootWrapper(updater.getId());
        targetView.setViewId(ourView.getViewId());
        targetView.setLocale(ourView.getLocale());
        targetView.setRenderKitId(ourView.getRenderKitId());
        ctx.setViewRoot((UIViewRoot)targetView);
        try {
            ViewBuilder builder = (ViewBuilder)ctx.getApplication().getViewHandler();
            builder.buildSubview(ctx, subviewId, (UIComponent)targetView);
        }
        finally {
            ctx.setViewRoot(ourView);
        }
        updater.getChildren().clear();
        updater.getChildren().addAll(targetView.getChildren());
        updater.setSubviewId(subviewId);
        updater.setNewView(false);
        updater.viewRestored(true);
    }

    protected void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        String url;
        AjaxUpdater updater = (AjaxUpdater)c;
        if (Boolean.TRUE.equals(updater.getFrame())) {
            return;
        }
        FacesContext context = ctx.getFacesContext();
        boolean isAjaxResponse = AjaxRenderKitImpl.isAjaxResponse((FacesContext)context);
        if (updater.getSubviewId() == null && (url = updater.getUrl()) != null && url.length() != 0) {
            if (isAjaxResponse) {
                String requestRenderId = AjaxUpdater.getRequestRenderId(context);
                String renderId = updater.getRenderId();
                if (requestRenderId != null && requestRenderId.equals(renderId)) {
                    updater.setSubviewId(url);
                    updater.setNewView(true);
                }
            } else if (updater.getUpdate().booleanValue()) {
                updater.setSubviewId(url);
                updater.setNewView(true);
            }
        }
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        AjaxUpdater updater = (AjaxUpdater)c;
        if (Boolean.TRUE.equals(updater.getFrame())) {
            return;
        }
        boolean isAjaxResponse = AjaxRenderKitImpl.isAjaxResponse((FacesContext)ctx.getFacesContext());
        if (!isAjaxResponse) {
            if (this.getSubViewIdFromRequest(ctx.getFacesContext(), c, null) != null) {
                return;
            }
            c.getChildren().clear();
        }
        if (((AjaxUpdater)c).getSubviewId() != null) {
            for (UIComponent cc : c.getChildren()) {
                cc.getAttributes().remove("com.sun.facelets.MARK_DELETED");
            }
            if (!ctx.getFacesContext().getRenderResponse()) {
                Fallback fallback = new Fallback();
                fallback.setTransient(true);
                super.applyNextHandler(ctx, (UIComponent)fallback);
                c.getFacets().put("fallback", fallback);
            }
        } else {
            super.applyNextHandler(ctx, c);
        }
    }

    private static final class UIViewRootWrapper
    extends UIViewRoot {
        private String base;
        private int lastId = 0;

        public UIViewRootWrapper(String base) {
            if (!base.startsWith("j_id")) {
                base = "j_id" + base;
            }
            this.base = base;
        }

        public String createUniqueId() {
            return this.base + "_" + this.lastId++;
        }
    }

    private static final class Fallback
    extends UIComponentBase {
        private Fallback() {
        }

        public String getFamily() {
            return "org.operamasks.faces.Fallback";
        }
    }
}

