/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.facelets.misc;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.TextHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.operamasks.el.eval.ELProgram;
import org.operamasks.el.parser.Parser;
import org.operamasks.el.parser.ResourceResolver;

public class ELiteHandler
extends TagHandler
implements ResourceResolver {
    private TagAttribute src;
    private String path;
    private int line;
    private boolean reparse;
    private SoftReference<ELProgram> progRef;

    public ELiteHandler(TagConfig config) {
        super(config);
        this.src = config.getTag().getAttributes().get("src");
        this.path = config.getTag().getLocation().getPath();
        this.line = config.getTag().getLocation().getLine();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        ELProgram prog;
        ELProgram eLProgram = prog = this.progRef == null ? null : this.progRef.get();
        if (prog == null || this.reparse) {
            Parser parser = new Parser(this.getText(ctx));
            parser.setFileName(this.path);
            parser.setLineNumber(this.line);
            parser.setResourceResolver((ResourceResolver)this);
            prog = parser.parse();
            this.progRef = new SoftReference<ELProgram>(prog);
        }
        prog.execute((ELContext)ctx, this.path, this.line);
    }

    private String getText(FaceletContext ctx) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (this.src != null) {
            this.read(this.src.getValue(ctx), buf);
        }
        Iterator iter = this.findNextByType(TextHandler.class);
        while (iter.hasNext()) {
            TextHandler th = (TextHandler)iter.next();
            String text = th.getText().trim();
            if (text.startsWith("<![CDATA[") && text.endsWith("]]>")) {
                text = text.substring(9, text.length() - 3);
            }
            buf.append(text);
        }
        return buf.toString();
    }

    public Reader open(String path) throws IOException {
        this.reparse = true;
        ExternalContext ext = FacesContext.getCurrentInstance().getExternalContext();
        InputStream in = ext.getResourceAsStream(path);
        if (in == null) {
            throw new FileNotFoundException(path + ": file not found.");
        }
        return new InputStreamReader(in);
    }

    private void read(String src, StringBuilder buf) throws IOException {
        int len;
        if (!src.startsWith("/")) {
            src = this.path.substring(0, this.path.lastIndexOf(47) + 1) + src;
        }
        Reader reader = this.open(src);
        char[] cbuf = new char[8192];
        while ((len = reader.read(cbuf)) != -1) {
            buf.append(cbuf, 0, len);
        }
        reader.close();
    }
}

