/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.facelets.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

public class AttributeSettingManager {
    private static final String ATTRIBUTE_SETTING_CONFIG_FILE = "org.operamasks.ATTRIBUTE_SETTING_CONFIG_FILE";
    private Properties attributeSettingMap = new Properties();
    private static AttributeSettingManager instance;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeSettingManager(FacesContext facesContext) {
        ServletContext servletContext;
        String attributeSettingConfigFile;
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext && (attributeSettingConfigFile = (servletContext = (ServletContext)context).getInitParameter(ATTRIBUTE_SETTING_CONFIG_FILE)) != null && attributeSettingConfigFile.trim().length() > 0) {
            InputStream in = servletContext.getResourceAsStream(attributeSettingConfigFile);
            try {
                if (in != null) {
                    this.attributeSettingMap.load(in);
                } else {
                    this.logger.log(Level.WARNING, "Could not find attribute setting file:" + attributeSettingConfigFile);
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not load attribute setting file:" + attributeSettingConfigFile, e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "close setting file " + attributeSettingConfigFile + "error.", e);
                    }
                }
            }
        }
    }

    public static AttributeSettingManager getInstance(FacesContext facesContext) {
        if (instance == null) {
            instance = new AttributeSettingManager(facesContext);
        }
        return instance;
    }

    public UIComponent process(UIComponent c, String componentType) {
        String attributeSetting = (String)this.attributeSettingMap.get(componentType);
        if (attributeSetting != null && attributeSetting.trim().length() > 0) {
            for (String setting : attributeSetting.split(",")) {
                String[] parts;
                if (setting == null || setting.trim().length() <= 0 || (parts = setting.split("/")) == null || parts.length != 2) continue;
                String key = parts[0];
                String value = parts[1];
                try {
                    if ("true".equals(value) || "false".equals(value)) {
                        c.getAttributes().put(key, Boolean.parseBoolean(value));
                        continue;
                    }
                    if ("TRUE".equals(value) || "FALSE".equals(value)) {
                        c.getAttributes().put(key, Boolean.valueOf(value));
                        continue;
                    }
                    if (this.isInteger(value)) {
                        c.getAttributes().put(key, Integer.parseInt(value));
                        continue;
                    }
                    c.getAttributes().put(key, value);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "attribute" + key + "'s value is invalid.", e);
                }
            }
        }
        return c;
    }

    private boolean isInteger(String str) {
        boolean result = true;
        for (int k = 0; k < str.length(); ++k) {
            if ('0' <= str.charAt(k) && str.charAt(k) <= '9') continue;
            result = false;
        }
        return result;
    }
}

