/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.ajax.AjaxKeyBinding;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.html.HtmlRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;

public class AjaxKeyBindingRenderer
extends AjaxRendererBase {
    private static Map<String, String> numKeyMap = new HashMap<String, String>();

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            ActionEvent event = new ActionEvent(component);
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            component.queueEvent((FacesEvent)event);
        }
    }

    public String getEventHandler(FacesContext context, UIComponent comp) {
        MethodBinding keybindingAction;
        UIForm form = HtmlRenderer.getParentForm((UIComponent)comp);
        AjaxKeyBinding keyBinding = (AjaxKeyBinding)comp;
        StringBuilder clientScript = new StringBuilder();
        Aliases alias = Aliases.getInstance((FacesContext)context);
        if (keyBinding.getClientScript() != null && keyBinding.getClientScript().trim().length() > 0) {
            clientScript.append("if (function(){");
            clientScript.append(keyBinding.getClientScript());
            if (clientScript.charAt(clientScript.length() - 1) != ';') {
                clientScript.append(';');
            }
            clientScript.append("}.apply(this)==false)return;");
        }
        if (!Boolean.FALSE.equals(keyBinding.getSkipBrowserAction())) {
            clientScript.insert(0, alias.alias("OM.SC.canelIEDefault") + "(e);");
        }
        if ((keybindingAction = keyBinding.getAction()) != null && keybindingAction.toString().trim().length() > 0) {
            String handler = String.format("%s %s(%s,%s,'%s',%b,%b,'%s');return true;", clientScript.toString(), alias.alias("OM.ajax.action"), form == null ? "null" : "'" + form.getClientId(context) + "'", form == null ? alias.alias("OM.SC.actionId") + "() || " + AjaxKeyBindingRenderer.getActionURLVar() : "null", comp.getClientId(context), false, false, comp.getParent().getClientId(context));
            return handler;
        }
        return clientScript.toString();
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource r = ComponentResource.getResourceInstance((ResourceManager)rm);
        r.addInitScript(AjaxKeyBindingRenderer.getActionURLVarDefinition((FacesContext)context));
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        UIComponent parent = component.getParent();
        AjaxKeyBinding keyBinding = (AjaxKeyBinding)component;
        Formatter fmt = new Formatter(new StringBuilder());
        Formatter addition = new Formatter(new StringBuilder());
        String el = "document";
        if (keyBinding.getKey() == null || keyBinding.getKey().trim().equals("")) {
            return;
        }
        String[] keyArray = keyBinding.getKey().split(",");
        String keyString = "";
        if (keyBinding.getTarget() == null || keyBinding.getTarget().equals("")) {
            fmt.format("var el=Ext.get('%s');", parent.getClientId(context));
            el = "el";
        } else {
            el = keyBinding.getTarget();
            if ("document".equals(el) || "window".equals(el)) {
                fmt.format("var el=Ext.isIE?window:document;", new Object[0]);
                el = "el";
            }
        }
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("keybinding");
        for (String key : keyArray) {
            if (key == null || key.trim().equals("")) continue;
            if ((key = key.trim().toUpperCase()).length() == 1 && (key.charAt(0) >= '0' && key.charAt(0) <= '9' || key.charAt(0) >= 'A' && key.charAt(0) <= 'Z')) {
                keyString = keyString + key;
                continue;
            }
            if (numKeyMap.containsKey(key)) {
                key = numKeyMap.get(key);
            }
            addition.format("keyMap.addBinding(%s{%s: %s.%s,", c.start(), c.prop("key"), alias.alias("Ext.EventObject"), key);
            if (Boolean.TRUE.equals(keyBinding.getCtrl())) {
                addition.format("%s:true,", c.prop("ctrl"));
            }
            if (Boolean.TRUE.equals(keyBinding.getAlt())) {
                addition.format("%s:true,", c.prop("alt"));
            }
            if (Boolean.TRUE.equals(keyBinding.getShift())) {
                addition.format("%s:true,", c.prop("shift"));
            }
            addition.format("%s:%s,", c.prop("fn"), alias.var("keyHandle"));
            addition.format("%s:%s", c.prop("scope"), el);
            addition.format("}%s);", c.end());
        }
        fmt.format("var %s=function(key,e){%s};", alias.var("keyHandle"), this.getEventHandler(context, component));
        fmt.format("var keyMap=new %s(%s.getEl?%s.getEl():%s,%s{", alias.alias("Ext.KeyMap"), el, el, el, c.start());
        fmt.format("%s:true,", c.prop("stopEvent"));
        if (Boolean.TRUE.equals(keyBinding.getCtrl())) {
            fmt.format("%s:true,", c.prop("ctrl"));
        }
        if (Boolean.TRUE.equals(keyBinding.getAlt())) {
            fmt.format("%s:true,", c.prop("alt"));
        }
        if (Boolean.TRUE.equals(keyBinding.getShift())) {
            fmt.format("%s:true,", c.prop("shift"));
        }
        fmt.format("%s:'%s',", c.prop("key"), keyString);
        fmt.format("%s:%s,", c.prop("fn"), alias.var("keyHandle"));
        fmt.format("%s:%s", c.prop("scope"), el);
        fmt.format("}%s);", c.end());
        fmt.format(addition.toString(), new Object[0]);
        resource.addInitScript(fmt.toString());
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)uc.getAttributeCandidates(component), (Map)this.getLiteAttributes());
    }

    static {
        numKeyMap.put("N0", "NUM_ZERO");
        numKeyMap.put("N1", "NUM_ONE");
        numKeyMap.put("N2", "NUM_TWO");
        numKeyMap.put("N3", "NUM_THREE");
        numKeyMap.put("N4", "NUM_FOUR");
        numKeyMap.put("N5", "NUM_FIVE");
        numKeyMap.put("N6", "NUM_SIX");
        numKeyMap.put("N7", "NUM_SEVEN");
        numKeyMap.put("N8", "NUM_EIGHT");
        numKeyMap.put("N9", "NUM_NINE");
    }
}

