/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.ajax.AjaxScripter;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;

public class AjaxScripterRenderer
extends AjaxRendererBase {
    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxScripter scripter = (AjaxScripter)component;
        String script = scripter.getScript();
        this.clearScript(context, scripter);
        if (script != null && script.length() != 0) {
            AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
            out.writeActionScript(script);
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxScripter scripter = (AjaxScripter)component;
        String script = scripter.getScript();
        this.clearScript(context, scripter);
        if (script == null) {
            script = FacesUtils.encodeComponentChildren((FacesContext)context, (UIComponent)component).trim();
        }
        if (script != null && script.length() != 0) {
            ResponseWriter out = context.getResponseWriter();
            out.write("\n<script type=\"text/javascript\">");
            out.write(script);
            out.write("</script>\n");
        }
    }

    private void clearScript(FacesContext context, AjaxScripter scripter) {
        scripter.clearScript();
        ValueExpression ve = scripter.getValueExpression("script");
        if (ve != null) {
            ve.setValue(context.getELContext(), null);
        }
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)uc.getAttributeCandidates(component), (Map)this.getLiteAttributes());
    }
}

