/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.ajax.AjaxTimer;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.FormRenderer;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxTimerRenderer
extends AjaxRendererBase {
    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void decode(FacesContext context, UIComponent component) {
        assert (context != null && component != null);
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxTimer timer = (AjaxTimer)component;
        long delay = timer.getDelay().intValue();
        long period = timer.getPeriod().intValue();
        boolean start = timer.getStart();
        String ontimeout = timer.getOntimeout();
        boolean sendForm = timer.getSendForm();
        if (delay <= 0L) {
            delay = period;
        }
        if (delay <= 0L || period <= 0L) {
            throw new FacesException("delay or period must > 0");
        }
        String clientId = component.getClientId(context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        String renderId = this.getRenderId((UIComponent)timer);
        ResponseWriter out = context.getResponseWriter();
        StringBuilder buf = new StringBuilder();
        buf.append("var ").append(jsvar).append("=new OM.ajax.Timer('").append(clientId).append("','").append(RendererUtils.getActionURL((FacesContext)context)).append("',").append(delay * 1000L).append(",").append(period * 1000L).append(");\n");
        if (form != null) {
            if (sendForm) {
                buf.append(jsvar).append(".form=document.forms['").append(form.getClientId(context)).append("'];\n");
            } else {
                buf.append(jsvar).append(".addParameter('").append(FormRenderer.getPostbackFieldName((FacesContext)context, (UIComponent)form)).append("','');\n");
            }
        }
        if (!(form != null && sendForm || renderId == null || renderId.length() == 0)) {
            buf.append(jsvar).append(".addParameter('").append("org.operamasks.faces.RenderId").append("','").append(renderId).append("');\n");
        }
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)kid;
            String name = param.getName();
            Object value = param.getValue();
            if (name == null || value == null) continue;
            buf.append(jsvar);
            buf.append(".addParameter(");
            buf.append(HtmlEncoder.enquote((String)name, (Character)Character.valueOf('\'')));
            buf.append(",");
            buf.append(HtmlEncoder.enquote((String)value.toString(), (Character)Character.valueOf('\'')));
            buf.append(");\n");
        }
        if (ontimeout != null && (ontimeout = ontimeout.trim()).length() != 0) {
            buf.append(jsvar);
            buf.append(".ontimeout=function(){");
            buf.append(ontimeout);
            if (!ontimeout.endsWith(";")) {
                buf.append(";");
            }
            buf.append("};\n");
        }
        if (start) {
            buf.append(jsvar).append(".schedule();\n");
        }
        out.startElement("script", component);
        out.writeAttribute("type", (Object)"text/javascript", null);
        out.writeAttribute("language", (Object)"Javascript", null);
        out.write("<!--\n");
        out.write(buf.toString());
        out.write("//-->\n");
        out.endElement("script");
        if (form == null) {
            context.getApplication().getViewHandler().writeState(context);
        }
    }

    private String getRenderId(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AjaxUpdater)) continue;
            return ((AjaxUpdater)parent).getRenderId();
        }
        return null;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)uc.getAttributeCandidates(component), (Map)this.getLiteAttributes());
    }
}

