/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.binding.ModelBindingFactory;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.HtmlPageStub;
import org.operamasks.faces.internal.stub.component.UpdaterRendererStub;
import org.operamasks.faces.internal.stub.component.UpdaterStub;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.faces.util.Repainter;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxUpdaterRenderer
extends AjaxRendererBase
implements UpdaterRendererStub {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String SERVLET_PATH_ATTR = "javax.servlet.include.servlet_path";
    private static final String JAVAX_FACES_PAGECONTEXT_COUNTER = "javax.faces.webapp.PAGECONTEXT_COUNTER";
    private static final Random prngPcId = new Random();
    private Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");
    protected static Set<String> UNUPDATEABLE_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("url");
        }
    });

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        AjaxUpdater updater = (AjaxUpdater)component;
        if (Boolean.TRUE.equals(updater.getFrame())) {
            out.startElement("iframe", (UIComponent)updater);
            out.writeAttribute("frameborder", (Object)"no", null);
            out.writeAttribute("id", (Object)updater.getClientId(context), null);
            out.writeAttribute("name", (Object)updater.getClientId(context), null);
            out.writeAttribute("src", (Object)updater.getSubviewId(), null);
            RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"frame");
            return;
        }
        String layout = (String)component.getAttributes().get("layout");
        if (layout != null && layout.equals("block")) {
            out.startElement("div", component);
        } else {
            out.startElement("span", component);
        }
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        String style = updater.getStyle();
        if (style == null) {
            style = "";
        }
        style = "position:relative;" + style;
        out.writeAttribute("style", (Object)style, null);
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"style");
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeAjaxChildren(FacesContext context, UIComponent component) throws IOException {
        AjaxUpdater updater = (AjaxUpdater)component;
        if (Boolean.TRUE.equals(updater.getFrame())) {
            return;
        }
        Repainter.flagRepainting((FacesContext)context);
        try {
            if (this.encodeSubview(context, updater)) {
                return;
            }
            if (updater.isNewView()) {
                updater.setNewView(false);
                this.encodeNewView(context, component);
            } else {
                this.__invokeChildrenAjaxRendering(context, component);
            }
        }
        finally {
            Repainter.unflagRepainting((FacesContext)context);
        }
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        AjaxUpdater updater = (AjaxUpdater)component;
        if (Boolean.TRUE.equals(updater.getFrame())) {
            return;
        }
        if (this.encodeSubview(context, updater)) {
            return;
        }
        this.__invokeChildrenHtmlRendering(context, component);
    }

    private boolean encodeSubview(FacesContext context, AjaxUpdater updater) throws IOException {
        if (updater.getSubviewId() != null) {
            ViewHandler vh = context.getApplication().getViewHandler();
            if (vh instanceof ViewBuilder) {
                this.buildSubview(context, (ViewBuilder)vh, updater);
            } else {
                this.renderSubview(context, updater);
            }
            return true;
        }
        return false;
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        AjaxUpdater updater = (AjaxUpdater)component;
        ResponseWriter out = context.getResponseWriter();
        assert (out instanceof AjaxResponseWriter);
        if (Boolean.TRUE.equals(updater.getFrame()) && updater.isNewView()) {
            String script = String.format("document.getElementById('%s').src='%s';\n", updater.getClientId(context), updater.getSubviewId());
            ((AjaxResponseWriter)out).writeScriptBlock(script);
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, (Map)this.getLiteAttributes());
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxUpdater updater = (AjaxUpdater)component;
        String clientId = updater.getClientId(context);
        String subviewId = updater.getSubviewId();
        ResponseWriter out = context.getResponseWriter();
        assert (out instanceof AjaxHtmlResponseWriter);
        if (Boolean.TRUE.equals(updater.getFrame())) {
            out.endElement("iframe");
            return;
        }
        String layout = (String)component.getAttributes().get("layout");
        if (layout != null && layout.equals("block")) {
            out.endElement("div");
        } else {
            out.endElement("span");
        }
        String jsvar = updater.getJsvar();
        String renderId = updater.getRenderId();
        if (!AjaxUpdaterRenderer.isEmpty(jsvar) && !AjaxUpdaterRenderer.isEmpty(renderId)) {
            String script = "<script type=\"text/javascript\" language=\"Javascript\">var " + jsvar + " = new OM.ajax.Updater('" + RendererUtils.getActionURL((FacesContext)context) + "','" + renderId + "'," + updater.getUpdate() + ");" + "</script>";
            out.write(script);
            ((AjaxHtmlResponseWriter)out).setViewStateChanged(false);
        }
        if (FacesUtils.isTransientStateSupported((FacesContext)context)) {
            ((AjaxHtmlResponseWriter)out).addRequestParameter(clientId, subviewId);
        }
    }

    protected void renderSubview(FacesContext context, AjaxUpdater component) throws IOException {
        String resourceURL;
        ExternalContext ectx = context.getExternalContext();
        if (!(ectx.getRequest() instanceof HttpServletRequest) || !(ectx.getResponse() instanceof HttpServletResponse)) {
            return;
        }
        String url = component.getSubviewId();
        boolean isNewView = component.isNewView();
        component.setNewView(false);
        ServletContext c = (ServletContext)ectx.getContext();
        String contextPath = component.getContext();
        if (contextPath != null && (c = c.getContext(contextPath)) == null) {
            throw new FacesException("Context not found: " + contextPath);
        }
        RequestDispatcher rd = c.getRequestDispatcher(url);
        if (url == null || rd == null) {
            throw new FacesException("Resource invalid: " + url);
        }
        String string = resourceURL = url.lastIndexOf(63) >= 0 ? url.substring(0, url.lastIndexOf(63)) : url;
        if (c.getResource(resourceURL) == null) {
            throw new FacesException("Resource not found: " + url);
        }
        UIViewRoot ourView = context.getViewRoot();
        UIViewRootWrapper targetView = new UIViewRootWrapper(ourView, null);
        targetView.setViewId(ourView.getViewId());
        targetView.setLocale(ourView.getLocale());
        targetView.setRenderKitId(ourView.getRenderKitId());
        if (!isNewView) {
            targetView.getChildren().addAll(component.getChildren());
        }
        context.setViewRoot((UIViewRoot)targetView);
        ResponseWrapper response = new ResponseWrapper((HttpServletResponse)ectx.getResponse());
        this.restorePageCounter(context, (UIComponent)component, url);
        try {
            try {
                FacesUtils.beginView((FacesContext)context);
                rd.include((ServletRequest)((HttpServletRequest)ectx.getRequest()), (ServletResponse)response);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        finally {
            context.setViewRoot(ourView);
            FacesUtils.endView((FacesContext)context);
        }
        if (response.getStatus() < 200 || response.getStatus() > 299) {
            throw new FacesException(String.valueOf(response.getStatus()) + " " + url);
        }
        if (targetView.getChildCount() == 0) {
            component.getChildren().clear();
            String charEncoding = component.getCharEncoding();
            String content = response.getString(charEncoding);
            ResponseWriter out = context.getResponseWriter();
            if (FacesUtils.isAjaxResponse((FacesContext)context)) {
                String clientId = component.getClientId(context);
                ((AjaxResponseWriter)out).writeInnerHtmlScript(clientId, content);
            } else {
                out.write(content);
            }
            return;
        }
        ModelBindingFactory.applyModelBindings((FacesContext)context, (PhaseId)PhaseId.RENDER_RESPONSE, (String)url, (UIComponent)targetView);
        component.getChildren().clear();
        if (!FacesUtils.isAjaxResponse((FacesContext)context)) {
            ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
            this.consumeResource(context, rm, (UIComponent)targetView);
        }
        component.getChildren().addAll(targetView.getChildren());
        Map requestMap = ectx.getRequestMap();
        Object savedPath = requestMap.get(SERVLET_PATH_ATTR);
        requestMap.put(SERVLET_PATH_ATTR, url);
        try {
            if (isNewView && FacesUtils.isAjaxResponse((FacesContext)context)) {
                this.encodeNewView(context, (UIComponent)component);
            } else {
                this.encodeViewBody(context, (UIComponent)component);
            }
        }
        finally {
            requestMap.put(SERVLET_PATH_ATTR, savedPath);
        }
    }

    public void buildSubviewTree(FacesContext context, ViewBuilder builder, UpdaterStub stub) throws IOException {
        AjaxUpdater updater;
        if (stub instanceof AjaxUpdater && ((updater = (AjaxUpdater)stub).isNewView() || !updater.viewRestored())) {
            String subviewId;
            UIViewRoot ourView = context.getViewRoot();
            UIViewRootWrapper targetView = new UIViewRootWrapper(ourView, updater.getId());
            targetView.setViewId(ourView.getViewId());
            targetView.setLocale(ourView.getLocale());
            targetView.setRenderKitId(ourView.getRenderKitId());
            targetView.setParent((UIComponent)updater);
            try {
                context.setViewRoot((UIViewRoot)targetView);
                builder.buildSubview(context, updater.getSubviewId(), (UIComponent)targetView);
                Map requestMap = context.getExternalContext().getRequestMap();
                requestMap.remove("BindingUtils.labelFor.key");
                ModelBindingFactory.applyModelBindings((FacesContext)context, (PhaseId)PhaseId.RENDER_RESPONSE, (String)updater.getSubviewId(), (UIComponent)targetView);
            }
            finally {
                context.setViewRoot(ourView);
            }
            if (!FacesUtils.isAjaxResponse((FacesContext)context) && ((subviewId = updater.getSubviewId()) == null || "".equals(subviewId) || Boolean.TRUE.equals(updater.getFrame()))) {
                ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
                this.consumeResource(context, rm, (UIComponent)targetView);
            }
            updater.getChildren().clear();
            updater.getChildren().addAll(targetView.getChildren());
        }
    }

    protected void buildSubview(FacesContext context, ViewBuilder builder, AjaxUpdater updater) throws IOException {
        String subviewId = updater.getSubviewId();
        if (subviewId == null || "".equals(subviewId) || Boolean.TRUE.equals(updater.getFrame())) {
            this.buildSubviewTree(context, builder, updater);
        }
        if (updater.isNewView() && FacesUtils.isAjaxResponse((FacesContext)context)) {
            this.encodeNewView(context, (UIComponent)updater);
        } else {
            this.encodeViewBody(context, (UIComponent)updater);
        }
        updater.setNewView(false);
        updater.viewRestored(false);
    }

    protected void encodeNewView(FacesContext context, UIComponent component) throws IOException {
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        StringWriter strWriter = new StringWriter();
        AjaxHtmlResponseWriter inner = out.cloneWithHtmlWriter((Writer)strWriter);
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        context.setResponseWriter((ResponseWriter)inner);
        this.consumeResource(context, rm, component);
        ComponentResource.encodeLocaleResource((FacesContext)context, (ResourceManager)rm);
        this.encodeViewBody(context, component);
        context.setResponseWriter((ResponseWriter)out);
        String clientId = component.getClientId(context);
        String content = HtmlEncoder.enquote((String)strWriter.toString(), (Character)Character.valueOf('\''));
        rm.encodeBegin(context);
        out.writeScriptBlock("OM.H('" + clientId + "'," + content + ");\n");
        rm.encodeEnd(context);
        rm.reset();
        out.setViewStateChanged(false);
    }

    private void consumeResource(FacesContext context, ResourceManager rm, UIComponent root) {
        rm.consumeResourceRegister(context, root);
        rm.consumeInitScriptBegin(context, root);
        rm.consumeContainerResources(context, root);
        rm.consumeResources(context, root);
        rm.consumeInitScriptEnd(context, root);
    }

    protected void encodeViewBody(FacesContext context, UIComponent component) throws IOException {
        UIComponent root = (UIComponent)FacesUtils.findComponent((UIComponent)component, HtmlPageStub.class);
        if (root == null) {
            root = component;
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(Resources._T((String)"UI_IGNORING_NESTED_PAGE_TAG", (Object[])new Object[]{component.getId()}));
        }
        for (UIComponent child : root.getChildren()) {
            child.encodeAll(context);
        }
    }

    private void restorePageCounter(FacesContext context, UIComponent component, String url) {
        Map requestMap;
        AtomicInteger pcc;
        String idKey = JAVAX_FACES_PAGECONTEXT_COUNTER + url;
        Integer pcId = (Integer)component.getAttributes().get(idKey);
        if (pcId == null) {
            int newId;
            while ((newId = prngPcId.nextInt()) <= 1000) {
            }
            pcId = newId;
            component.getAttributes().put(idKey, pcId);
        }
        if ((pcc = (AtomicInteger)(requestMap = context.getExternalContext().getRequestMap()).get(JAVAX_FACES_PAGECONTEXT_COUNTER)) == null) {
            pcc = new AtomicInteger();
            requestMap.put(JAVAX_FACES_PAGECONTEXT_COUNTER, pcc);
        }
        pcc.set(pcId);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public Set<String> getUnupdatableAttributes() {
        return UNUPDATEABLE_ATTRIBUTES;
    }

    private static final class ResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter strWriter = new StringWriter();
        private ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        private ServletOutputStream sos = new ServletOutputStream(){

            public void write(int b) throws IOException {
                ResponseWrapper.this.byteStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ResponseWrapper.this.byteStream.write(b, off, len);
            }
        };
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status = 200;

        public ResponseWrapper(HttpServletResponse wrapped) {
            super(wrapped);
        }

        public PrintWriter getWriter() throws IOException {
            if (this.isStreamUsed) {
                throw new IllegalStateException("A writer is already in used.");
            }
            this.isWriterUsed = true;
            return new PrintWriter(this.strWriter);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException("A output stream is already in used.");
            }
            this.isStreamUsed = true;
            return this.sos;
        }

        public void setContentType(String x) {
        }

        public void setLocale(Locale x) {
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public String getString(String charEncoding) throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.strWriter.toString();
            }
            if (this.isStreamUsed) {
                if (AjaxUpdaterRenderer.isEmpty(charEncoding)) {
                    charEncoding = this.getCharacterEncoding();
                }
                if (AjaxUpdaterRenderer.isEmpty(charEncoding)) {
                    charEncoding = AjaxUpdaterRenderer.DEFAULT_ENCODING;
                }
                return this.byteStream.toString(charEncoding);
            }
            return "";
        }
    }

    private static final class UIViewRootWrapper
    extends UIViewRoot {
        private UIViewRoot wrapped;
        private String base;
        private int lastId = 0;

        public UIViewRootWrapper(UIViewRoot wrapped, String base) {
            this.wrapped = wrapped;
            if (base != null) {
                if (!base.startsWith("j_id")) {
                    base = "j_id" + base;
                }
                this.base = base;
            }
        }

        public String createUniqueId() {
            if (this.base == null) {
                return this.wrapped.createUniqueId();
            }
            return String.valueOf(this.base) + "_" + this.lastId++;
        }
    }
}

