/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.delegate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.component.widget.UIFileUpload;
import org.operamasks.faces.component.widget.fileupload.FileUploadItem;
import org.operamasks.faces.component.widget.fileupload.UploadingException;
import org.operamasks.faces.component.widget.fileupload.UploadingMediator;
import org.operamasks.faces.component.widget.fileupload.WrapperedFileItemStream;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxUpdaterRenderer;
import org.operamasks.faces.render.delegate.ViewDelegate;
import org.operamasks.faces.render.widget.ajax.AjaxFileUploadRenderer;
import org.operamasks.org.apache.commons.fileupload.FileItem;
import org.operamasks.org.apache.commons.fileupload.FileUploadException;
import org.operamasks.org.apache.commons.fileupload.ProgressListener;
import org.operamasks.org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.operamasks.org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadDelegate
implements ViewDelegate {
    private static final int UPLOADING_BUFFER_SIZE = 4096;

    public void delegate(FacesContext context) throws IOException {
        ExternalContext ectx = context.getExternalContext();
        Map paramMap = ectx.getRequestParameterMap();
        String fileuploadId = (String)paramMap.get(AjaxFileUploadRenderer.REQUEST_PARAM_POST);
        if (fileuploadId == null) {
            return;
        }
        UIComponent component = FacesUtils.getForComponent((FacesContext)context, (String)fileuploadId, (UIComponent)context.getViewRoot());
        if (component == null) {
            try {
                component = this.findFromUpdater(context, fileuploadId);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (component == null || !(component instanceof UIFileUpload)) {
            this.getUploadingMediator().stopUploading(context, (Exception)((Object)new UploadingException("Error occurs when uploading file")));
            context.responseComplete();
            return;
        }
        UIForm parentForm = FacesUtils.getParentForm((UIComponent)component);
        if (this.isFirstFileUploadComponent(context, parentForm, component) && ServletFileUpload.isMultipartContent((HttpServletRequest)context.getExternalContext().getRequest())) {
            UploadingMediator uploadingMediator = this.getUploadingMediator();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(4096);
            ServletFileUpload upload = new ServletFileUpload(factory);
            upload.setProgressListener(new FileUploadProgressListener(context));
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            List fileItem = null;
            try {
                this.getUploadingMediator().cleanUploadingKey(context);
                if (!uploadingMediator.canStartUploading(context)) {
                    return;
                }
                uploadingMediator.startUploading(context);
                fileItem = upload.parseRequest(request);
                for (FileItem item : fileItem) {
                    if (item.isFormField()) continue;
                    uploadingMediator.addFieldNames(context, item.getFieldName());
                }
            }
            catch (FileUploadException e) {
                this.getUploadingMediator().stopUploading(context, (Exception)((Object)new UploadingException("Error occurs when uploading file", e.getCause() == null ? e : e.getCause())));
                context.responseComplete();
                return;
            }
            try {
                this.processUploading(context, component, fileItem);
                this.getUploadingMediator().stopUploading(context);
            }
            catch (Throwable t) {
                this.getUploadingMediator().stopUploading(context, (Exception)((Object)new UploadingException("Error occurs when uploading file", t.getCause() == null ? t : t.getCause())));
            }
            context.responseComplete();
        }
    }

    private UploadingMediator getUploadingMediator() {
        return UploadingMediator.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUploading(FacesContext context, UIComponent component, List<FileItem> fileItem) throws IOException, FileUploadException {
        UploadingMediator uploadingMediator = this.getUploadingMediator();
        int itemIndex = 0;
        if (!uploadingMediator.getFieldNames(context).contains(component.getId())) {
            return;
        }
        UIForm parentForm = FacesUtils.getParentForm((UIComponent)component);
        if (parentForm == null) {
            return;
        }
        Iterator iterator = FacesUtils.createChildrenIterator((UIComponent)parentForm, (boolean)false);
        InputStream input = null;
        ArrayList<UIFileUpload> fileUploads = new ArrayList<UIFileUpload>();
        while (iterator.hasNext()) {
            UIComponent c = (UIComponent)iterator.next();
            if (!(c instanceof UIFileUpload)) continue;
            fileUploads.add((UIFileUpload)c);
        }
        for (FileItem item : fileItem) {
            if (item.isFormField()) continue;
            String fieldName = item.getFieldName();
            UIFileUpload target = null;
            for (UIFileUpload f : fileUploads) {
                if (!fieldName.equals(f.getId())) continue;
                target = f;
            }
            if (target == null) continue;
            if (this.isFieldRequired(target) && this.isFieldNull(item.getName())) {
                throw new FacesException(this.getRequiredFacesMessage(context, target));
            }
            WrapperedFileItemStream wrapperedFileItemStream = new WrapperedFileItemStream();
            wrapperedFileItemStream.setName(item.getName());
            wrapperedFileItemStream.setContentType(item.getContentType());
            wrapperedFileItemStream.setFieldName(item.getFieldName());
            wrapperedFileItemStream.setInputStream(item.getInputStream());
            FileUploadItem uploadItem = this.createFileUploadItem(wrapperedFileItemStream, ++itemIndex, target.getMaxSize());
            if (uploadItem == null) {
                return;
            }
            try {
                input = this.openStream(wrapperedFileItemStream, target);
                if (target.getWriteTo() != null) {
                    this.writeToFile(input, target.getWriteTo());
                    continue;
                }
                target.getUploadListener().invoke(context.getELContext(), new Object[]{uploadItem});
                this.consumeStream(input);
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
    }

    private void writeToFile(InputStream input, String writeTo) throws IOException {
        FileOutputStream output = new FileOutputStream(new File(writeTo));
        try {
            byte[] buf = new byte[4096];
            int length = -1;
            while ((length = input.read(buf)) != -1) {
                output.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private InputStream openStream(WrapperedFileItemStream wrapperedFileItemStream, UIFileUpload fileUpload) throws IOException {
        if (fileUpload != null && fileUpload.getMaxSize() != null) {
            return new LimitedSizeInputStream(wrapperedFileItemStream, fileUpload.getMaxSize());
        }
        return wrapperedFileItemStream.openStream();
    }

    private FileUploadItem createFileUploadItem(WrapperedFileItemStream wrapperedFileItemStream, int itemIndex, Long maxSize) {
        return new FileUploadItemImpl(wrapperedFileItemStream, itemIndex, maxSize);
    }

    private String getRequiredFacesMessage(FacesContext context, UIFileUpload fileUpload) {
        if (fileUpload.getRequiredMessage() != null) {
            return fileUpload.getRequiredMessage();
        }
        return Resources._T((String)"JSF_VALIDATE_REQUIRED", (Object[])new Object[]{fileUpload.getClientId(context)});
    }

    private boolean isFieldRequired(UIFileUpload fileUpload) {
        return Boolean.TRUE.equals(fileUpload.getRequired());
    }

    private boolean isFieldNull(String itemName) {
        return "".equals(itemName);
    }

    private void consumeStream(InputStream stream) throws IOException {
        try {
            byte[] buf = new byte[4096];
            while (stream.read(buf) != -1) {
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private UIFileUpload findFirstFileUploadComponent(UIComponent component) {
        List children = component.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) instanceof UIFileUpload) {
                return (UIFileUpload)((Object)children.get(i));
            }
            UIFileUpload findInChildren = this.findFirstFileUploadComponent((UIComponent)children.get(i));
            if (findInChildren == null) continue;
            return findInChildren;
        }
        return null;
    }

    private boolean isFirstFileUploadComponent(FacesContext context, UIForm form, UIComponent component) {
        UIFileUpload firstFileUpload = this.findFirstFileUploadComponent((UIComponent)form);
        return firstFileUpload != null && component.getId().equals(firstFileUpload.getId());
    }

    public UIComponent findFromUpdater(FacesContext context, String fileuploadId) throws IOException {
        Iterator kids = FacesUtils.createChildrenIterator((UIComponent)context.getViewRoot(), (boolean)false);
        ArrayList<AjaxUpdater> updaters = new ArrayList<AjaxUpdater>();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof AjaxUpdater)) continue;
            updaters.add((AjaxUpdater)kid);
        }
        for (AjaxUpdater updater : updaters) {
            UIComponent fileupload;
            if (updater.getSubviewId() == null) continue;
            AjaxUpdaterRenderer renderer = (AjaxUpdaterRenderer)FacesUtils.getRenderer((FacesContext)context, (UIComponent)updater);
            ViewHandler vh = context.getApplication().getViewHandler();
            if (vh instanceof ViewBuilder) {
                renderer.buildSubviewTree(context, (ViewBuilder)vh, updater);
            }
            if ((fileupload = FacesUtils.getForComponent((FacesContext)context, (String)fileuploadId, (UIComponent)updater)) == null || !(fileupload instanceof UIFileUpload)) continue;
            return fileupload;
        }
        return null;
    }

    private static class FileUploadItemImpl
    implements FileUploadItem {
        private WrapperedFileItemStream wrapperedFileItemStream;
        private int itemIndex;
        private Long maxSize;

        public FileUploadItemImpl(WrapperedFileItemStream wrapperedFileItemStream, int itemIndex, Long maxSize) {
            this.wrapperedFileItemStream = wrapperedFileItemStream;
            this.itemIndex = itemIndex;
            this.maxSize = maxSize;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public String getContentType() {
            return this.wrapperedFileItemStream.getContentType();
        }

        public String getFieldName() {
            return this.wrapperedFileItemStream.getFieldName();
        }

        public String getName() {
            return this.wrapperedFileItemStream.getName();
        }

        public InputStream openStream() throws IOException {
            if (this.maxSize != null) {
                return new LimitedSizeInputStream(this.wrapperedFileItemStream, this.maxSize);
            }
            return this.wrapperedFileItemStream.openStream();
        }
    }

    private static class LimitedSizeInputStream
    extends InputStream {
        private WrapperedFileItemStream wrapperedFileItemStream;
        private long maxSize;
        private long count;
        private InputStream stream;

        public LimitedSizeInputStream(WrapperedFileItemStream wrapperedFileItemStream, long maxSize) {
            this.maxSize = maxSize;
            this.count = 0L;
            this.wrapperedFileItemStream = wrapperedFileItemStream;
        }

        private InputStream getInputStream() throws IOException {
            if (this.stream == null) {
                this.stream = this.wrapperedFileItemStream.openStream();
            }
            return this.stream;
        }

        public int read() throws IOException {
            int ret = this.getInputStream().read();
            if (ret != -1) {
                ++this.count;
                this.checkLimit();
            }
            return ret;
        }

        public int read(byte[] b) throws IOException {
            int ret = this.getInputStream().read(b);
            if (ret != -1) {
                this.count += (long)ret;
                this.checkLimit();
            }
            return ret;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int ret = this.getInputStream().read(b, off, len);
            if (ret != -1) {
                this.count += (long)ret;
                this.checkLimit();
            }
            return ret;
        }

        private void checkLimit() throws IOException {
            if (this.count > this.maxSize) {
                throw new ExceedMaxSizeException(Resources._T((String)"JSF_UPLOADING_EXCEEDS_MAX_SIZE", (Object[])new Object[]{this.wrapperedFileItemStream.getFieldName(), this.maxSize}));
            }
        }

        private static class ExceedMaxSizeException
        extends IOException {
            public ExceedMaxSizeException(String s) {
                super(s);
            }
        }
    }

    private class FileUploadProgressListener
    implements ProgressListener {
        private FacesContext context;
        private long lastBytesRead;

        public FileUploadProgressListener(FacesContext context) {
            this.context = context;
        }

        public void update(long pBytesRead, long pContentLength, int pItems) {
            UploadingMediator uploadingMediator = FileUploadDelegate.this.getUploadingMediator();
            if (pBytesRead == pContentLength || pBytesRead - this.lastBytesRead > 4096L) {
                uploadingMediator.updateProgress(this.context, pBytesRead, pContentLength, pItems);
                this.lastBytesRead = pBytesRead;
            }
        }
    }
}

