/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.delegate;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.component.widget.fileupload.impl.UIFileUploadDialog;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxUpdaterRenderer;
import org.operamasks.faces.render.delegate.ViewDelegate;
import org.operamasks.org.apache.commons.fileupload.FileItemIterator;
import org.operamasks.org.apache.commons.fileupload.FileItemStream;
import org.operamasks.org.apache.commons.fileupload.FileUploadException;
import org.operamasks.org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.operamasks.org.apache.commons.fileupload.util.Streams;

public class FileUploadDialogDelegate
implements ViewDelegate {
    public void delegate(FacesContext context) throws IOException {
        ExternalContext ectx = context.getExternalContext();
        Map paramMap = ectx.getRequestParameterMap();
        String fileUploadId = (String)paramMap.get("fileUploadId");
        UIComponent component = null;
        if (fileUploadId == null) {
            return;
        }
        component = this.findFileUpload(context, fileUploadId);
        if (component != null) {
            UIFileUploadDialog fileUpload = (UIFileUploadDialog)component;
            HttpServletRequest request = (HttpServletRequest)ectx.getRequest();
            HttpServletResponse response = (HttpServletResponse)ectx.getResponse();
            response.setContentType("text/html;charset=UTF-8");
            if (fileUpload.getProcessUpload() != null) {
                fileUpload.getProcessUpload().invoke(context.getELContext(), new Object[]{request, response});
            } else {
                this.defaultProcessFileUpload(fileUpload, context, request, response);
            }
            context.responseComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultProcessFileUpload(UIFileUploadDialog fileUpload, FacesContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String savePath = fileUpload.getSavePath();
        if (savePath == null) {
            return;
        }
        if (!savePath.endsWith("\\") && !savePath.endsWith("/")) {
            savePath = savePath + "/";
        }
        ServletFileUpload upload = new ServletFileUpload();
        InputStream stream = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            if (ServletFileUpload.isMultipartContent(request)) {
                if (fileUpload.getFileSizeMax() != null) {
                    upload.setSizeMax(fileUpload.getFileSizeMax());
                }
                FileItemIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    stream = item.openStream();
                    if (item.isFormField()) continue;
                    String filename = new File(item.getName()).getName();
                    bis = new BufferedInputStream(stream);
                    bos = new BufferedOutputStream(new FileOutputStream(new File(savePath + filename)));
                    Streams.copy(bis, bos, true);
                }
                response.getWriter().write("{success:true}");
            }
        }
        catch (FileUploadException e) {
            response.getWriter().write(String.format("{success:false,message:'%s'}", e.getMessage()));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private UIComponent findFileUpload(FacesContext context, String id) throws IOException {
        Iterator kids = FacesUtils.createChildrenIterator((UIComponent)context.getViewRoot(), (boolean)false);
        ArrayList<AjaxUpdater> updaters = new ArrayList<AjaxUpdater>();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (kid instanceof AjaxUpdater) {
                updaters.add((AjaxUpdater)kid);
                continue;
            }
            if (!(kid instanceof UIFileUploadDialog) || !kid.getId().equals(id)) continue;
            return kid;
        }
        for (AjaxUpdater updater : updaters) {
            UIComponent fileUploadDialog;
            if (updater.getSubviewId() == null) continue;
            AjaxUpdaterRenderer renderer = (AjaxUpdaterRenderer)FacesUtils.getRenderer((FacesContext)context, (UIComponent)updater);
            ViewHandler vh = context.getApplication().getViewHandler();
            if (vh instanceof ViewBuilder) {
                renderer.buildSubviewTree(context, (ViewBuilder)vh, updater);
            }
            if ((fileUploadDialog = FacesUtils.getForComponent((FacesContext)context, (String)id, (UIComponent)updater)) == null || !(fileUploadDialog instanceof UIFileUploadDialog)) continue;
            return fileUploadDialog;
        }
        return null;
    }
}

