/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.awt.geom.Point2D;
import org.operamasks.org.jfree.data.xy.XYDataset;
import org.operamasks.org.jfree.data.xy.XYSeries;

public class BSpline {
    public static XYSeries createBSpline(XYDataset source, int series, Comparable key, int samples, int degree) {
        if (source == null) {
            throw new NullPointerException();
        }
        XYSeries result = new XYSeries(key);
        if (samples > degree) {
            int i;
            int count = source.getItemCount(series);
            Point2D[] points = new Point2D[count];
            for (i = 0; i < count; ++i) {
                double x = source.getXValue(series, i);
                double y = source.getYValue(series, i);
                points[i] = new Point2D.Double(x, y);
            }
            points = BSpline.bspline(points, samples, degree);
            for (i = 0; i < samples; ++i) {
                result.add(points[i].getX(), points[i].getY());
            }
        }
        return result;
    }

    public static Point2D[] bspline(Point2D[] controls, int samples, int k) {
        int n = controls.length - 1;
        int[] T = BSpline.knot(n, k);
        double[][] N = new double[n + 1][k + 1];
        double step = (double)(T[n + k] - T[0]) / (double)(samples - 1);
        double t = 0.0;
        Point2D[] output = new Point2D[samples];
        for (int i = 0; i < samples - 1; ++i) {
            output[i] = BSpline.point(n, k, T, t, N, controls);
            t += step;
        }
        output[samples - 1] = (Point2D)controls[n].clone();
        return output;
    }

    private static int[] knot(int n, int k) {
        int[] T = new int[n + k + 1];
        for (int i = 0; i <= n + k; ++i) {
            T[i] = i < k ? 0 : (i <= n ? T[i - 1] + 1 : T[n] + 1);
        }
        return T;
    }

    private static double blend(int i, int k, int[] T, double t, double[][] N) {
        double n;
        if (!Double.isNaN(N[i][k])) {
            return N[i][k];
        }
        if (k == 1) {
            n = (double)T[i] <= t && t < (double)T[i + 1] ? 1.0 : 0.0;
        } else {
            n = 0.0;
            if (T[i + k - 1] != T[i]) {
                n += BSpline.blend(i, k - 1, T, t, N) * (t - (double)T[i]) / (double)(T[i + k - 1] - T[i]);
            }
            if (T[i + k] != T[i + 1]) {
                n += BSpline.blend(i + 1, k - 1, T, t, N) * ((double)T[i + k] - t) / (double)(T[i + k] - T[i + 1]);
            }
        }
        N[i][k] = n;
        return n;
    }

    private static Point2D point(int n, int k, int[] T, double t, double[][] N, Point2D[] P) {
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= k; ++j) {
                N[i][j] = Double.NaN;
            }
        }
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i <= n; ++i) {
            double m = BSpline.blend(i, k, T, t, N);
            x += m * P[i].getX();
            y += m * P[i].getY();
        }
        return new Point2D.Double(x, y);
    }
}

