/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import org.operamasks.faces.component.graph.UIChart;
import org.operamasks.faces.render.graph.ChartRenderer;
import org.operamasks.faces.render.graph.ChartRendererHelper;
import org.operamasks.org.jfree.chart.ChartFactory;
import org.operamasks.org.jfree.chart.JFreeChart;
import org.operamasks.org.jfree.chart.plot.CategoryPlot;
import org.operamasks.org.jfree.chart.plot.Plot;
import org.operamasks.org.jfree.chart.plot.XYPlot;
import org.operamasks.org.jfree.chart.renderer.category.BarRenderer;
import org.operamasks.org.jfree.chart.renderer.category.BarRenderer3D;
import org.operamasks.org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.operamasks.org.jfree.chart.renderer.xy.XYBarRenderer;
import org.operamasks.org.jfree.chart.renderer.xy.XYItemRenderer;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.data.general.Dataset;
import org.operamasks.org.jfree.data.time.TimeSeriesCollection;
import org.operamasks.org.jfree.data.xy.IntervalXYDataset;

public class BarChartRenderer
extends ChartRenderer {
    protected JFreeChart createChart(UIChart comp) {
        Dataset dataset = ChartRendererHelper.createDataset(comp);
        JFreeChart chart = null;
        if (dataset instanceof CategoryDataset) {
            chart = comp.isStacked() ? (comp.isEffect3D() ? ChartFactory.createStackedBarChart3D(null, null, null, (CategoryDataset)dataset, this.getChartOrientation(comp), false, false, false) : ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)dataset, this.getChartOrientation(comp), false, false, false)) : (comp.isEffect3D() ? ChartFactory.createBarChart3D(null, null, null, (CategoryDataset)dataset, this.getChartOrientation(comp), false, false, false) : ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, this.getChartOrientation(comp), false, false, false));
        } else if (dataset instanceof IntervalXYDataset) {
            chart = ChartFactory.createXYBarChart(null, null, dataset instanceof TimeSeriesCollection, null, (IntervalXYDataset)dataset, this.getChartOrientation(comp), false, false, false);
        }
        return chart;
    }

    protected void setChartStyles(JFreeChart chart, UIChart comp) {
        super.setChartStyles(chart, comp);
        Plot plot = chart.getPlot();
        if (plot instanceof CategoryPlot) {
            this.setBarStyles((CategoryPlot)plot, comp);
        } else if (plot instanceof XYPlot) {
            this.setBarStyles((XYPlot)plot, comp);
        }
    }

    private void setBarStyles(CategoryPlot plot, UIChart comp) {
        CategoryItemRenderer r = plot.getRenderer();
        if (r instanceof BarRenderer) {
            BarRenderer renderer = (BarRenderer)r;
            Boolean drawOutline = comp.getDrawOutline();
            if (drawOutline != null) {
                renderer.setDrawBarOutline(drawOutline);
            } else if (renderer instanceof BarRenderer3D) {
                renderer.setDrawBarOutline(false);
            }
        }
    }

    private void setBarStyles(XYPlot plot, UIChart comp) {
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYBarRenderer) {
            XYBarRenderer renderer = (XYBarRenderer)r;
            Boolean drawOutline = comp.getDrawOutline();
            if (drawOutline != null) {
                renderer.setDrawBarOutline(drawOutline);
            }
        }
    }
}

