/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.operamasks.faces.util.LoggerUtil;

public class ChartKeeper
implements ServletContextListener {
    private static final Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");
    public static final String CHART_KEEPER_KEY = "org.operamasks.faces.ChartKeeper";
    private File tmpdir;
    private long lastCleanTime = 0L;
    private static final int MAX_KEEP_TIME = 300;

    public static ChartKeeper getInstance(FacesContext context) {
        Map appMap = context.getExternalContext().getApplicationMap();
        ChartKeeper keeper = (ChartKeeper)appMap.get(CHART_KEEPER_KEY);
        if (keeper == null) {
            keeper = new ChartKeeper();
            keeper.init((File)appMap.get("javax.servlet.context.tempdir"));
        }
        return keeper;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.setAttribute(CHART_KEEPER_KEY, (Object)this);
        this.init((File)context.getAttribute("javax.servlet.context.tempdir"));
    }

    private void init(final File defaultDir) {
        this.tmpdir = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                File dir = defaultDir;
                if (dir == null) {
                    dir = new File(System.getProperty("java.io.tmpdir"));
                }
                if (!(dir = new File(dir, "jsf-chart-images")).exists() && !dir.mkdirs()) {
                    logger.log(Level.WARNING, "create directory fails.");
                }
                return dir;
            }
        });
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.cleanAll();
        event.getServletContext().removeAttribute(CHART_KEEPER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(byte[] data, String suffix) throws IOException {
        this.doSweep();
        FileOutputStream out = null;
        File file = File.createTempFile("CHRT", suffix, this.tmpdir);
        try {
            out = new FileOutputStream(file);
            out.write(data);
            out.close();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return file.getName();
    }

    public byte[] retrieve(String filename) {
        File file = new File(this.tmpdir, filename);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            byte[] data = new byte[(int)file.length()];
            in.readFully(data);
            in.close();
            return data;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void doSweep() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCleanTime > 300000L) {
            this.lastCleanTime = currentTime;
            try {
                File[] files;
                for (File file : files = this.tmpdir.listFiles()) {
                    if (currentTime - file.lastModified() <= 300000L || !file.exists() || file.delete()) continue;
                    logger.log(Level.WARNING, "delete file fails.");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void cleanAll() {
        try {
            File[] files;
            for (File file : files = this.tmpdir.listFiles()) {
                if (!file.exists() || file.delete()) continue;
                logger.log(Level.WARNING, "delete file fails.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

