/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.util.Date;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.component.graph.TimePeriodType;
import org.operamasks.faces.component.graph.UIChart;
import org.operamasks.faces.component.graph.UIDataItem;
import org.operamasks.faces.component.graph.UIDataLabel;
import org.operamasks.faces.component.graph.UIDataSeries;
import org.operamasks.faces.component.graph.UIFunctionItem;
import org.operamasks.faces.component.graph.UIFunctionSeries;
import org.operamasks.faces.component.graph.UIHistogramDataItem;
import org.operamasks.faces.component.graph.UIHistogramDataSeries;
import org.operamasks.faces.component.graph.UITimeDataItem;
import org.operamasks.faces.component.graph.UITimeSeries;
import org.operamasks.faces.component.graph.UIXYDataItem;
import org.operamasks.faces.component.graph.UIXYDataSeries;
import org.operamasks.faces.render.graph.ChartUtils;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.data.category.DefaultCategoryDataset;
import org.operamasks.org.jfree.data.general.Dataset;
import org.operamasks.org.jfree.data.statistics.HistogramDataset;
import org.operamasks.org.jfree.data.time.Day;
import org.operamasks.org.jfree.data.time.Hour;
import org.operamasks.org.jfree.data.time.Millisecond;
import org.operamasks.org.jfree.data.time.Minute;
import org.operamasks.org.jfree.data.time.Month;
import org.operamasks.org.jfree.data.time.Quarter;
import org.operamasks.org.jfree.data.time.RegularTimePeriod;
import org.operamasks.org.jfree.data.time.Second;
import org.operamasks.org.jfree.data.time.TimeSeries;
import org.operamasks.org.jfree.data.time.TimeSeriesCollection;
import org.operamasks.org.jfree.data.time.Week;
import org.operamasks.org.jfree.data.time.Year;
import org.operamasks.org.jfree.data.xy.XYDataset;
import org.operamasks.org.jfree.data.xy.XYSeries;
import org.operamasks.org.jfree.data.xy.XYSeriesCollection;
import org.operamasks.resources.Resources;

final class ChartRendererHelper {
    private ChartRendererHelper() {
    }

    public static Dataset createDataset(UIChart component) {
        UIDataSeries data = component.getDataSeries();
        if (data == null) {
            throw new FacesException(Resources._T((String)"UI_CHART_NO_DATA_SERIES_ASSOCIATED"));
        }
        data.resetDataModel();
        if (data instanceof UIXYDataSeries) {
            return ChartRendererHelper.createXYDataset((UIXYDataSeries)data);
        }
        if (data instanceof UITimeSeries) {
            return ChartRendererHelper.createTimeSeriesDataset((UITimeSeries)data);
        }
        if (data instanceof UIHistogramDataSeries) {
            return ChartRendererHelper.createHistogramDataset((UIHistogramDataSeries)data);
        }
        if (data instanceof UIFunctionSeries) {
            return ChartRendererHelper.createFunctionSeries((UIFunctionSeries)data);
        }
        return ChartRendererHelper.createCategoryDataset(data);
    }

    public static CategoryDataset createCategoryDataset(UIDataSeries data) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        UIDataLabel label = data.getLabel();
        UIDataItem[] items = data.getItems();
        int numSeries = items.length;
        if (numSeries == 0) {
            return dataset;
        }
        Key[] seriesKeys = new Key[numSeries];
        for (int i = 0; i < numSeries; ++i) {
            seriesKeys[i] = new Key(i, items[i].getLegend());
        }
        int rowIndex = data.getFirst();
        int rows = data.getRows();
        int curRow = 0;
        while (rows == 0 || curRow < rows) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            String labelText = label == null ? "" : label.getText();
            Key rowKey = new Key(rowIndex, labelText);
            for (int i = 0; i < numSeries; ++i) {
                double value = TypeCoercion.coerceToDouble((Object)items[i].getValue());
                dataset.addValue(value, (Comparable)seriesKeys[i], (Comparable)rowKey);
            }
            ++curRow;
            ++rowIndex;
        }
        data.setRowIndex(-1);
        return dataset;
    }

    public static Key getCategoryKey(UIDataSeries data, Object dataValue) {
        UIDataLabel dataLabel = data.getLabel();
        if (dataLabel == null) {
            return null;
        }
        int rowIndex = data.getFirst();
        int rows = data.getRows();
        Key rowKey = null;
        int curRow = 0;
        while (rows == 0 || curRow < rows) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            Object labelValue = dataLabel.getValue();
            if (dataValue == null && labelValue == null || dataValue != null && dataValue.equals(labelValue)) {
                rowKey = new Key(rowIndex, dataLabel.getText());
                break;
            }
            ++curRow;
            ++rowIndex;
        }
        data.setRowIndex(-1);
        return rowKey;
    }

    public static XYDataset createXYDataset(UIXYDataSeries data) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        UIXYDataItem[] items = data.getItems();
        int numSeries = items.length;
        if (numSeries == 0) {
            return dataset;
        }
        XYSeries[] series = new XYSeries[numSeries];
        for (int i = 0; i < numSeries; ++i) {
            series[i] = new XYSeries(new Key(i, items[i].getLegend()));
            dataset.addSeries(series[i]);
        }
        int rowIndex = data.getFirst();
        int rows = data.getRows();
        int curRow = 0;
        while (rows == 0 || curRow < rows) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            for (int i = 0; i < numSeries; ++i) {
                double x = TypeCoercion.coerceToDouble((Object)items[i].getX());
                double y = TypeCoercion.coerceToDouble((Object)items[i].getY());
                series[i].add(x, y);
            }
            ++curRow;
            ++rowIndex;
        }
        data.setRowIndex(-1);
        return dataset;
    }

    public static XYDataset createTimeSeriesDataset(UITimeSeries data) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        UITimeDataItem[] items = data.getItems();
        int numSeries = items.length;
        if (numSeries == 0) {
            return dataset;
        }
        Class timePeriodClass = ChartRendererHelper.getTimePeriodClass(data.getTimePeriod());
        TimeSeries[] series = new TimeSeries[numSeries];
        for (int i = 0; i < numSeries; ++i) {
            String name = items[i].getLegend();
            if (name == null) {
                name = "";
            }
            series[i] = new TimeSeries(name, timePeriodClass);
            dataset.addSeries(series[i]);
        }
        int rowIndex = data.getFirst();
        int rows = data.getRows();
        int curRow = 0;
        while (rows == 0 || curRow < rows) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            for (int i = 0; i < numSeries; ++i) {
                Date time = items[i].getTime();
                double value = TypeCoercion.coerceToDouble((Object)items[i].getValue());
                RegularTimePeriod rtp = RegularTimePeriod.createInstance(timePeriodClass, time, RegularTimePeriod.DEFAULT_TIME_ZONE);
                series[i].add(rtp, value);
            }
            ++curRow;
            ++rowIndex;
        }
        data.setRowIndex(-1);
        return dataset;
    }

    public static Class getTimePeriodClass(TimePeriodType period) {
        switch (period) {
            case Year: {
                return Year.class;
            }
            case Quarter: {
                return Quarter.class;
            }
            case Month: {
                return Month.class;
            }
            case Week: {
                return Week.class;
            }
            case Day: {
                return Day.class;
            }
            case Hour: {
                return Hour.class;
            }
            case Minute: {
                return Minute.class;
            }
            case Second: {
                return Second.class;
            }
            case Millisecond: {
                return Millisecond.class;
            }
        }
        throw new AssertionError();
    }

    public static long getTimePeriodValue(UIDataSeries data, Object value) {
        if (!(data instanceof UITimeSeries)) {
            throw new IllegalArgumentException();
        }
        Date time = ChartUtils.convertDate(value);
        Class timePeriodClass = ChartRendererHelper.getTimePeriodClass(((UITimeSeries)data).getTimePeriod());
        RegularTimePeriod timePeriod = RegularTimePeriod.createInstance(timePeriodClass, time, RegularTimePeriod.DEFAULT_TIME_ZONE);
        return timePeriod.getFirstMillisecond();
    }

    public static XYDataset createHistogramDataset(UIHistogramDataSeries data) {
        int i;
        HistogramDataset dataset = new HistogramDataset();
        UIHistogramDataItem[] items = data.getItems();
        int numSeries = items.length;
        if (numSeries == 0) {
            return dataset;
        }
        int rowIndex = data.getFirst();
        int rows = data.getRows();
        int rowCount = data.getRowCount() - rowIndex;
        if (rowCount < 0) {
            rowCount = 10;
        }
        DoubleList[] values = new DoubleList[numSeries];
        for (i = 0; i < numSeries; ++i) {
            values[i] = new DoubleList(rowCount);
        }
        int curRow = 0;
        while (rows == 0 || curRow < rows) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            for (int i2 = 0; i2 < numSeries; ++i2) {
                values[i2].add(TypeCoercion.coerceToDouble((Object)items[i2].getValue()));
            }
            ++curRow;
            ++rowIndex;
        }
        data.setRowIndex(-1);
        for (i = 0; i < numSeries; ++i) {
            Key seriesKey = new Key(i, items[i].getLegend());
            double[] seriesValues = values[i].toArray();
            int bins = items[i].getBins();
            Double minimum = items[i].getMinimumValue();
            Double maximum = items[i].getMaximumValue();
            if (minimum != null && maximum != null) {
                dataset.addSeries(seriesKey, seriesValues, bins, minimum, maximum);
                continue;
            }
            dataset.addSeries(seriesKey, seriesValues, bins);
        }
        return dataset;
    }

    public static XYDataset createFunctionSeries(UIFunctionSeries data) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        UIFunctionItem[] items = data.getItems();
        for (int i = 0; i < items.length; ++i) {
            Key key = new Key(i, items[i].getLegend());
            dataset.addSeries(ChartRendererHelper.createFunctionSeries(key, items[i]));
        }
        return dataset;
    }

    private static XYSeries createFunctionSeries(Key key, UIFunctionItem item) {
        double start = item.getStart();
        double end = item.getEnd();
        double step = item.getStep();
        MethodExpression expr = item.getExpression();
        if (expr == null) {
            throw new FacesException("Function expression is required.");
        }
        if (start >= end) {
            throw new FacesException("Start must less than end.");
        }
        if (step <= 0.0) {
            throw new FacesException("Step must be positive value.");
        }
        XYSeries series = new XYSeries(key);
        ELContext elc = FacesContext.getCurrentInstance().getELContext();
        Object[] args = new Object[1];
        int samples = (int)((end - start) / step);
        for (int i = 0; i <= samples; ++i) {
            double x = start + step * (double)i;
            args[0] = x;
            Double y = (Double)expr.invoke(elc, args);
            if (y != null && (Double.isNaN(y) || Double.isInfinite(y))) {
                y = null;
            }
            series.add(x, (Number)y);
        }
        return series;
    }

    private static class DoubleList {
        private double[] values;
        private int size;

        public DoubleList(int initialCapacity) {
            this.values = new double[initialCapacity];
        }

        private void ensureCapacity(int minCapacity) {
            int oldCapacity = this.values.length;
            if (minCapacity > oldCapacity) {
                double[] oldValues = this.values;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.values = new double[newCapacity];
                System.arraycopy(oldValues, 0, this.values, 0, this.size);
            }
        }

        public void add(double value) {
            this.ensureCapacity(this.size + 1);
            this.values[this.size++] = value;
        }

        public double[] toArray() {
            if (this.size < this.values.length) {
                double[] oldValues = this.values;
                this.values = new double[this.size];
                System.arraycopy(oldValues, 0, this.values, 0, this.size);
            }
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key
    implements Comparable<Key> {
        private int id;
        private String label;

        public Key(int id, String label) {
            this.id = id;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                return this.id == ((Key)obj).id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }

        @Override
        public int compareTo(Key other) {
            return this.id - other.id;
        }
    }
}

