/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;

public class ChartUtils {
    private static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final DateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static Map<String, Color> colorMap;

    private ChartUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date convertDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        try {
            DateFormat dateFormat = iso8601Format;
            synchronized (dateFormat) {
                return iso8601Format.parse(value.toString());
            }
        }
        catch (ParseException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public static Date convertDate(ValueExpression ve) {
        return ChartUtils.convertDate(ve.getValue(FacesContext.getCurrentInstance().getELContext()));
    }

    public static Paint convertColor(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Paint) {
            return (Paint)value;
        }
        return ChartUtils.parseColor(value.toString());
    }

    public static Paint convertColor(ValueExpression ve) {
        return ChartUtils.convertColor(ve.getValue(FacesContext.getCurrentInstance().getELContext()));
    }

    public static Color parseColor(String cs) {
        if (cs == null || cs.length() == 0) {
            return null;
        }
        Color c = colorMap.get(cs);
        if (c != null) {
            return c;
        }
        try {
            String s = cs.trim();
            if (s.startsWith("#")) {
                if ((s = s.substring(1)).length() == 3) {
                    int r = Integer.parseInt(s.substring(0, 1), 16);
                    int g = Integer.parseInt(s.substring(1, 2), 16);
                    int b = Integer.parseInt(s.substring(2, 3), 16);
                    return new Color(r, g, b);
                }
                if (s.length() == 6) {
                    int rgb = Integer.parseInt(s, 16);
                    return new Color(rgb, false);
                }
                if (s.length() == 8) {
                    int argb = (int)Long.parseLong(s, 16);
                    return new Color(argb, true);
                }
                throw new IllegalArgumentException();
            }
            if (s.startsWith("rgb(") && s.endsWith(")")) {
                s = s.substring(4, s.length() - 1);
                String[] ss = s.split(",");
                int r = Integer.parseInt(ss[0]);
                int g = Integer.parseInt(ss[1]);
                int b = Integer.parseInt(ss[2]);
                return new Color(r, g, b);
            }
            if (s.startsWith("rgba(") && s.endsWith(")")) {
                s = s.substring(5, s.length() - 1);
                String[] ss = s.split(",");
                int r = Integer.parseInt(ss[0]);
                int g = Integer.parseInt(ss[1]);
                int b = Integer.parseInt(ss[2]);
                int a = Integer.parseInt(ss[3]);
                return new Color(r, g, b, a);
            }
        }
        catch (Exception ex) {
            throw new FacesException("Parse color fails: " + ex);
        }
        throw new IllegalArgumentException("Invalid color literal: " + cs);
    }

    public static Font convertFont(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Font) {
            return (Font)value;
        }
        return ChartUtils.parseFont(value.toString());
    }

    public static Font convertFont(ValueExpression ve) {
        return ChartUtils.convertFont(ve.getValue(FacesContext.getCurrentInstance().getELContext()));
    }

    public static Font parseFont(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            String[] ss = s.split(",");
            String name = ss[0];
            String strStyle = ss[1];
            int size = Integer.parseInt(ss[2]);
            int style = 0;
            if (strStyle.indexOf("bold") != -1) {
                style |= 1;
            }
            if (strStyle.indexOf("italic") != -1) {
                style |= 2;
            }
            return new Font(name, style, size);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid font literal: " + s);
        }
    }

    public static Object serialPaintObject(Paint paint) {
        if (paint instanceof Serializable) {
            return paint;
        }
        if (paint instanceof GradientPaint) {
            return new SerialGradientPaint((GradientPaint)paint);
        }
        return null;
    }

    static {
        iso8601Format.setTimeZone(TimeZone.getDefault());
        colorMap = new HashMap<String, Color>();
        colorMap.put("white", Color.white);
        colorMap.put("lightgray", Color.lightGray);
        colorMap.put("gray", Color.gray);
        colorMap.put("darkgray", Color.darkGray);
        colorMap.put("black", Color.black);
        colorMap.put("red", Color.red);
        colorMap.put("pink", Color.pink);
        colorMap.put("orange", Color.orange);
        colorMap.put("yellow", Color.yellow);
        colorMap.put("green", Color.green);
        colorMap.put("magenta", Color.magenta);
        colorMap.put("cyan", Color.cyan);
        colorMap.put("blue", Color.blue);
    }

    private static class SerialGradientPaint
    extends GradientPaint
    implements Serializable {
        private static final long serialVersionUID = -6111029908120132859L;

        SerialGradientPaint(GradientPaint gp) {
            super(gp.getPoint1(), gp.getColor1(), gp.getPoint2(), gp.getColor2(), gp.isCyclic());
        }
    }
}

