/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import org.operamasks.faces.component.graph.UIChart;
import org.operamasks.faces.render.graph.ChartRendererHelper;
import org.operamasks.faces.render.graph.CurveAndShapeRenderer;
import org.operamasks.faces.render.graph.CurveChartRenderer;
import org.operamasks.faces.render.graph.XYCurveAndShapeRenderer;
import org.operamasks.org.jfree.chart.JFreeChart;
import org.operamasks.org.jfree.chart.axis.CategoryAxis;
import org.operamasks.org.jfree.chart.axis.DateAxis;
import org.operamasks.org.jfree.chart.axis.NumberAxis;
import org.operamasks.org.jfree.chart.axis.ValueAxis;
import org.operamasks.org.jfree.chart.plot.CategoryPlot;
import org.operamasks.org.jfree.chart.plot.PlotOrientation;
import org.operamasks.org.jfree.chart.plot.XYPlot;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.data.general.Dataset;
import org.operamasks.org.jfree.data.time.TimeSeriesCollection;
import org.operamasks.org.jfree.data.xy.XYDataset;

public class CurveAreaChartRenderer
extends CurveChartRenderer {
    protected JFreeChart createChart(UIChart comp) {
        Dataset dataset = ChartRendererHelper.createDataset(comp);
        JFreeChart chart = null;
        if (dataset instanceof CategoryDataset) {
            chart = this.createCurveAreaChart((CategoryDataset)dataset, this.getChartOrientation(comp));
        } else if (dataset instanceof XYDataset) {
            chart = this.createXYCurveAreaChart((XYDataset)dataset, this.getChartOrientation(comp));
        }
        return chart;
    }

    private JFreeChart createCurveAreaChart(CategoryDataset dataset, PlotOrientation orientation) {
        CategoryAxis xAxis = new CategoryAxis();
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        xAxis.setCategoryMargin(0.0);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setAutoRangeIncludesZero(false);
        CurveAndShapeRenderer renderer = new CurveAndShapeRenderer(true, false);
        renderer.setDrawArea(true);
        CategoryPlot plot = new CategoryPlot(dataset, xAxis, yAxis, renderer);
        plot.setOrientation(orientation);
        if (dataset.getRowCount() > 1) {
            plot.setForegroundAlpha(0.75f);
        }
        return new JFreeChart(null, null, plot, false);
    }

    private JFreeChart createXYCurveAreaChart(XYDataset dataset, PlotOrientation orientation) {
        ValueAxis xAxis;
        if (dataset instanceof TimeSeriesCollection) {
            xAxis = new DateAxis();
        } else {
            xAxis = new NumberAxis();
            ((NumberAxis)xAxis).setAutoRangeIncludesZero(false);
        }
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setAutoRangeIncludesZero(false);
        XYCurveAndShapeRenderer renderer = new XYCurveAndShapeRenderer(true, false);
        renderer.setDrawArea(true);
        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
        plot.setOrientation(orientation);
        if (dataset.getSeriesCount() > 1) {
            plot.setForegroundAlpha(0.75f);
        }
        return new JFreeChart(null, null, plot, false);
    }
}

