/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import org.operamasks.org.jfree.data.time.RegularTimePeriod;
import org.operamasks.org.jfree.data.time.TimeSeries;
import org.operamasks.org.jfree.data.time.TimeSeriesDataItem;
import org.operamasks.org.jfree.data.xy.XYDataset;
import org.operamasks.org.jfree.data.xy.XYSeries;

public class MovingAverage {
    public static XYSeries createMovingAverage(TimeSeries source, Comparable key, int periodCount, int skip) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (periodCount < 1) {
            throw new IllegalArgumentException("period count must be greater than or equal to 1.");
        }
        XYSeries result = new XYSeries(key, false, true);
        if (source.getItemCount() > 0) {
            long firstSerial = source.getDataItem(0).getPeriod().getSerialIndex() + (long)skip;
            for (int i = source.getItemCount() - 1; i >= 0; --i) {
                TimeSeriesDataItem current = source.getDataItem(i);
                RegularTimePeriod period = current.getPeriod();
                long serial = period.getSerialIndex();
                if (serial < firstSerial) continue;
                int n = 0;
                double sum = 0.0;
                long serialLimit = period.getSerialIndex() - (long)periodCount;
                boolean finished = false;
                for (int offset = 0; offset < periodCount && !finished; ++offset) {
                    if (i - offset < 0) continue;
                    TimeSeriesDataItem item = source.getDataItem(i - offset);
                    RegularTimePeriod p = item.getPeriod();
                    Number v = item.getValue();
                    long currentIndex = p.getSerialIndex();
                    if (currentIndex > serialLimit) {
                        if (v == null) continue;
                        sum += v.doubleValue();
                        ++n;
                        continue;
                    }
                    finished = true;
                }
                if (n > 0) {
                    result.add((double)period.getFirstMillisecond(), sum / (double)n);
                    continue;
                }
                result.add((double)period.getFirstMillisecond(), (Number)null);
            }
        }
        return result;
    }

    public static XYSeries createMovingAverage(XYDataset source, int series, Comparable key, double period, double skip) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (period < Double.MIN_VALUE) {
            throw new IllegalArgumentException("period must be positive");
        }
        if (skip < 0.0) {
            throw new IllegalArgumentException("skip must be >= 0.0");
        }
        XYSeries result = new XYSeries(key);
        if (source.getItemCount(series) > 0) {
            double first = source.getXValue(series, 0) + skip;
            for (int i = source.getItemCount(series) - 1; i >= 0; --i) {
                double x = source.getXValue(series, i);
                if (x >= first) {
                    int n = 0;
                    double sum = 0.0;
                    double limit = x - period;
                    int offset = 0;
                    boolean finished = false;
                    while (!finished) {
                        if (i - offset >= 0) {
                            double xx = source.getXValue(series, i - offset);
                            Number yy = source.getY(series, i - offset);
                            if (xx > limit) {
                                if (yy != null) {
                                    sum += yy.doubleValue();
                                    ++n;
                                }
                            } else {
                                finished = true;
                            }
                        } else {
                            finished = true;
                        }
                        ++offset;
                    }
                    if (n <= 0) continue;
                    result.add(x, sum / (double)n);
                    continue;
                }
                result.add(x, (Number)null);
            }
        }
        return result;
    }
}

