/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;
import org.operamasks.faces.render.graph.CubicSplineFunction2D;
import org.operamasks.org.jfree.chart.axis.ValueAxis;
import org.operamasks.org.jfree.chart.plot.PlotOrientation;
import org.operamasks.org.jfree.chart.plot.XYPlot;
import org.operamasks.org.jfree.chart.renderer.xy.XYItemRendererState;
import org.operamasks.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.operamasks.org.jfree.data.xy.XYDataset;
import org.operamasks.org.jfree.ui.RectangleEdge;

public class XYCurveAndShapeRenderer
extends XYLineAndShapeRenderer {
    private boolean drawArea;

    public XYCurveAndShapeRenderer() {
        this(true, true);
    }

    public XYCurveAndShapeRenderer(boolean lines, boolean shapes) {
        super(lines, shapes);
        this.setDrawSeriesLineAsPath(true);
    }

    public boolean getDrawArea() {
        return this.drawArea;
    }

    public void setDrawArea(boolean drawArea) {
        this.drawArea = drawArea;
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
        double x;
        if (item != 0) {
            return;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        PlotOrientation orientation = plot.getOrientation();
        int itemCount = dataset.getItemCount(series);
        double[][] points = new double[itemCount][2];
        int count = 0;
        for (int i = 0; i < itemCount; ++i) {
            double x2 = dataset.getXValue(series, i);
            double y = dataset.getYValue(series, i);
            double transX = domainAxis.valueToJava2D(x2, dataArea, xAxisLocation);
            double transY = rangeAxis.valueToJava2D(y, dataArea, yAxisLocation);
            if (Double.isNaN(transX) || Double.isNaN(transY)) continue;
            points[count][0] = transX;
            points[count][1] = transY;
            ++count;
        }
        if (count < 2) {
            return;
        }
        Arrays.sort(points, new Comparator<double[]>(){

            @Override
            public int compare(double[] a, double[] b) {
                return a[0] > b[0] ? 1 : (a[0] < b[0] ? -1 : 0);
            }
        });
        CubicSplineFunction2D f = new CubicSplineFunction2D(points, count);
        GeneralPath path = new GeneralPath();
        double startX = points[0][0];
        double startY = points[0][1];
        double endX = points[count - 1][0];
        double endY = points[count - 1][1];
        double yz = rangeAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
        if (orientation == PlotOrientation.HORIZONTAL) {
            if (this.drawArea) {
                path.moveTo((float)yz, (float)startX);
                path.lineTo((float)startY, (float)startX);
                for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                    path.lineTo((float)f.getValue(x), (float)x);
                }
                path.lineTo((float)endY, (float)endX);
                path.lineTo((float)yz, (float)endX);
                path.closePath();
            } else {
                path.moveTo((float)startY, (float)startX);
                for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                    path.lineTo((float)f.getValue(x), (float)x);
                }
                path.lineTo((float)endY, (float)endX);
            }
        } else if (this.drawArea) {
            path.moveTo((float)startX, (float)yz);
            path.lineTo((float)startX, (float)startY);
            for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                path.lineTo((float)x, (float)f.getValue(x));
            }
            path.lineTo((float)endX, (float)endY);
            path.lineTo((float)endX, (float)yz);
            path.closePath();
        } else {
            path.moveTo((float)startX, (float)startY);
            for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                path.lineTo((float)x, (float)f.getValue(x));
            }
            path.lineTo((float)endX, (float)endY);
        }
        Paint paint = this.getItemPaint(series, item);
        Stroke stroke = this.getItemStroke(series, item);
        if (this.drawArea) {
            g2.setPaint(paint);
            g2.fill(path);
            if (paint instanceof Color) {
                paint = ((Color)paint).darker();
            } else if (paint instanceof GradientPaint) {
                paint = ((GradientPaint)paint).getColor1().darker();
            }
        }
        g2.setPaint(paint);
        g2.setStroke(stroke);
        g2.draw(path);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.drawArea ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYCurveAndShapeRenderer other = (XYCurveAndShapeRenderer)obj;
        return this.drawArea == other.drawArea;
    }
}

