/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.CheckboxListRenderer;
import org.operamasks.faces.render.widget.ajax.AjaxUISelectRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxCheckboxListRenderer
extends AjaxUISelectRenderer {
    private static final String SELECT_ITEM_COUNT = "org.operamasks.faces.SELECT_ITEM_COUNT";
    protected CheckboxListRenderer delegate = new CheckboxListRenderer();

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        List items = this.getDelegate().getSelectItems(context, component);
        this.renderAjaxResponse(context, component, items);
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        List items = this.getDelegate().getSelectItems(context, component);
        this.renderAjaxHtmlResponse(context, component, items);
    }

    private void renderAjaxHtmlResponse(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("div", null);
        out.writeAttribute("id", (Object)this.getOuterClientId(context, component), null);
        out.writeText((Object)"", null);
        this.getDelegate().renderCheckboxList(context, component, items);
        out.endElement("div");
        int itemCount = this.getDelegate().getSelectItemCount(context, component);
        component.getAttributes().put(SELECT_ITEM_COUNT, itemCount);
    }

    private void renderInnerHtmlResponse(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String clientId = this.getOuterClientId(context, component);
        StringWriter buf = new StringWriter();
        AjaxHtmlResponseWriter inner = out.cloneWithHtmlWriter((Writer)buf);
        context.setResponseWriter((ResponseWriter)inner);
        this.getDelegate().renderCheckboxList(context, component, items);
        context.setResponseWriter((ResponseWriter)out);
        out.writeInnerHtmlScript(clientId, buf.toString());
    }

    private void renderAjaxResponse(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        Integer oldItemCount = (Integer)component.getAttributes().get(SELECT_ITEM_COUNT);
        int newItemCount = this.getDelegate().getSelectItemCount(context, component);
        if (oldItemCount == null || oldItemCount != newItemCount) {
            component.repaint();
            component.getAttributes().put(SELECT_ITEM_COUNT, newItemCount);
            return;
        }
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String itemIdPrefix = component.getClientId(context) + ':';
        boolean isUpdateValue = uc.isUpdateValue(component);
        boolean isUpdateDisabled = uc.getAttributeCandidates(component).contains("disabled");
        String selectedOption = this.getDelegate().getSelectedOption();
        int idx = 0;
        for (SelectItem item : items) {
            if (item instanceof SelectItemGroup) {
                for (SelectItem groupItem : ((SelectItemGroup)item).getSelectItems()) {
                    String itemId = itemIdPrefix + idx++;
                    if (isUpdateValue) {
                        out.writeAttributeScript(itemId, selectedOption, (Object)this.getDelegate().isSelected(context, component, groupItem));
                    }
                    if (!isUpdateDisabled) continue;
                    out.writeAttributeScript(itemId, "disabled", (Object)(RendererUtils.isDisabled((UIComponent)component) || groupItem.isDisabled() ? 1 : 0));
                }
                continue;
            }
            String itemId = itemIdPrefix + idx++;
            if (isUpdateValue) {
                out.writeAttributeScript(itemId, selectedOption, (Object)this.getDelegate().isSelected(context, component, item));
            }
            if (!isUpdateDisabled) continue;
            out.writeAttributeScript(itemId, "disabled", (Object)(RendererUtils.isDisabled((UIComponent)component) || item.isDisabled() ? 1 : 0));
        }
        Set attrs = uc.getAttributeCandidates(component);
        if (isUpdateValue) {
            attrs.remove("value");
        }
        if (isUpdateDisabled) {
            attrs.remove("disabled");
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    private String getOuterClientId(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        return clientId + ':' + "_outer";
    }

    protected CheckboxListRenderer getDelegate() {
        if (this.delegate == null) {
            this.delegate = new CheckboxListRenderer();
        }
        return this.delegate;
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return RendererUtils.HTML_LITE_ATTRIBUTES;
    }
}

