/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.html.MenuRenderer;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.ajax.AjaxUISelectRenderer;
import org.operamasks.faces.util.Repainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxMenuRenderer
extends AjaxUISelectRenderer {
    private static final String SELECT_ITEMS_CHECKSUM = "org.operamasks.faces.SELECT_ITEMS_CHECKSUM";
    protected InnerMenuRenderer delegate = new InnerMenuRenderer();

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        List items = this.delegate.getSelectItems(context, component);
        this.renderAjaxHtmlResponse(context, component, items);
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        List items = this.delegate.getSelectItems(context, component);
        this.renderAjaxResponse(context, component, items);
    }

    private void renderAjaxHtmlResponse(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("span", null);
        out.writeAttribute("id", (Object)this.getOuterClientId(context, component), null);
        out.write("");
        this.delegate.renderMenu(context, component, items);
        out.endElement("span");
        byte[] checksum = this.computeSelectItemsChecksum(context, component, items);
        component.getAttributes().put(SELECT_ITEMS_CHECKSUM, checksum);
    }

    private void renderAjaxResponse(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        byte[] oldChecksum = (byte[])component.getAttributes().get(SELECT_ITEMS_CHECKSUM);
        byte[] newChecksum = this.computeSelectItemsChecksum(context, component, items);
        if (oldChecksum == null || !Arrays.equals(oldChecksum, newChecksum)) {
            out.writeScriptBlock(Repainter.repaintComponent((FacesContext)context, (ResourceManager)ResourceManager.getInstance((FacesContext)context), (AjaxResponseWriter)out, (UIComponent)component));
            component.getAttributes().put(SELECT_ITEMS_CHECKSUM, newChecksum);
            return;
        }
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        if (uc.isUpdateValue(component)) {
            String clientId = component.getClientId(context);
            if (component instanceof UISelectOne) {
                String value = this.delegate.getCurrentValue(context, component);
                out.writeAttributeScript(clientId, "value", (Object)value);
            } else {
                StringBuilder buf = new StringBuilder();
                int idx = 0;
                buf.append("OM.SEL('");
                buf.append(this.getOuterClientId(context, component));
                buf.append("',[");
                for (SelectItem item : items) {
                    if (item instanceof SelectItemGroup) {
                        for (SelectItem groupItem : ((SelectItemGroup)item).getSelectItems()) {
                            if (this.delegate.isSelected(context, component, groupItem)) {
                                buf.append(idx).append(',');
                            }
                            ++idx;
                        }
                        continue;
                    }
                    if (this.delegate.isSelected(context, component, item)) {
                        buf.append(idx).append(',');
                    }
                    ++idx;
                }
                if (buf.charAt(buf.length() - 1) == ',') {
                    buf.setLength(buf.length() - 1);
                }
                buf.append("]);\n");
                out.writeScriptBlock(buf.toString());
            }
            attrs.remove("value");
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, (Map)this.getLiteAttributes());
    }

    private String getOuterClientId(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        return clientId + ':' + "_outer";
    }

    private byte[] computeSelectItemsChecksum(FacesContext context, UIComponent component, List<SelectItem> items) {
        try {
            String itemsString = this.getSelectItemsString(context, component, items);
            MessageDigest md5 = FacesUtils.getMD5();
            byte[] result = md5.digest(itemsString.getBytes("UTF-8"));
            FacesUtils.returnMD5((MessageDigest)md5);
            return result;
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private String getSelectItemsString(FacesContext context, UIComponent component, List<SelectItem> items) {
        StringBuilder buf = new StringBuilder();
        for (SelectItem item : items) {
            if (item instanceof SelectItemGroup) {
                buf.append("OPTGROUP\n");
                for (SelectItem groupItem : ((SelectItemGroup)item).getSelectItems()) {
                    this.addItemString(buf, context, component, groupItem);
                }
                continue;
            }
            this.addItemString(buf, context, component, item);
        }
        return buf.toString();
    }

    private void addItemString(StringBuilder buf, FacesContext context, UIComponent component, SelectItem item) {
        buf.append("OPTION\n");
        buf.append(item.getLabel());
        buf.append('\n');
        buf.append(this.delegate.getFormattedValue(context, component, item.getValue()));
        buf.append('\n');
        if (item.isDisabled()) {
            buf.append("disabled\n");
        }
    }

    protected static class InnerMenuRenderer
    extends MenuRenderer {
        protected InnerMenuRenderer() {
        }

        public String getCurrentValue(FacesContext context, UIComponent component) {
            return super.getCurrentValue(context, component);
        }

        public boolean isSelected(FacesContext context, UIComponent component, Object itemValue, String itemStr) {
            return super.isSelected(context, component, itemValue, itemStr);
        }

        public String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
            return super.getFormattedValue(context, component, currentValue);
        }
    }
}

