/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.MessageRenderer;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxMessageRenderer
extends AjaxRendererBase {
    protected MessageRenderer delegate = new MessageRenderer();
    private static Map<String, LiteAttributeEncoder> LITE_ATTRIBUTES = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(RendererUtils.HTML_LITE_ATTRIBUTES){
        {
            this.put("title", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    out.writeAttributeScript(component.getClientId(context), "title", (Object)AjaxMessageRenderer.initTitle(context, component));
                }
            });
            this.remove("style");
            this.remove("styleClass");
        }
    });

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        String style = this.initStyle(context, component);
        String styleClass = this.initStyleClass(context, component);
        String title = AjaxMessageRenderer.initTitle(context, component);
        this.writeHtmlMessage(context, component, style, styleClass, title);
    }

    private void writeHtmlMessage(FacesContext context, UIComponent component, String style, String styleClass, String title) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String clientId = component.getClientId(context);
        out.startElement("span", component);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("title", (Object)title, "title");
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"style,styleClass,title");
        out.writeAttribute("style", (Object)style, "style");
        out.writeAttribute("class", (Object)styleClass, "styleClass");
        out.writeText((Object)this.initMessageText(context, component), null);
        out.endElement("span");
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        String style = this.initStyle(context, component);
        String styleClass = this.initStyleClass(context, component);
        this.writeAjaxMessage(context, component, style, styleClass);
    }

    private void writeAjaxMessage(FacesContext context, UIComponent component, String style, String styleClass) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String clientId = component.getClientId(context);
        AjaxResponseWriter ajax = (AjaxResponseWriter)out;
        ajax.writeScriptBlock("OM.S('" + clientId + "'," + HtmlEncoder.enquote((String)style) + ");");
        ajax.writeScriptBlock("OM.F('" + clientId + "','className','" + styleClass + "');");
        ajax.writeInnerHtmlScript(clientId, this.initMessageText(context, component));
    }

    private String initMessageText(FacesContext context, UIComponent component) {
        FacesMessage message = MessageRenderer.getFacesMessage((FacesContext)context, (UIComponent)component);
        boolean showSummary = false;
        boolean showDetail = false;
        String summary = null;
        String detail = null;
        if (message != null) {
            showSummary = ((UIMessage)component).isShowSummary();
            showDetail = ((UIMessage)component).isShowDetail();
            summary = message.getSummary();
            detail = message.getDetail();
            if (summary == null) {
                summary = "";
            }
            if (detail == null) {
                detail = "";
            }
        }
        String messageText = showSummary && showDetail ? summary + " " + detail : (showSummary ? summary : (showDetail ? detail : ""));
        return messageText;
    }

    private String initStyle(FacesContext context, UIComponent component) {
        FacesMessage message = MessageRenderer.getFacesMessage((FacesContext)context, (UIComponent)component);
        String messageText = this.initMessageText(context, component);
        String style = null;
        if (message != null) {
            if (message.getSeverity() == FacesMessage.SEVERITY_INFO) {
                style = (String)component.getAttributes().get("infoStyle");
            } else if (message.getSeverity() == FacesMessage.SEVERITY_WARN) {
                style = (String)component.getAttributes().get("warnStyle");
            } else if (message.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                style = (String)component.getAttributes().get("errorStyle");
            } else if (message.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                style = (String)component.getAttributes().get("fatalStyle");
            }
        }
        if (style == null) {
            style = (String)component.getAttributes().get("style");
        }
        String display = messageText.length() > 0 ? "display:inherit" : "display:none";
        style = style == null ? display : style + ";" + display;
        return style;
    }

    private String initStyleClass(FacesContext context, UIComponent component) {
        FacesMessage message = MessageRenderer.getFacesMessage((FacesContext)context, (UIComponent)component);
        String styleClass = null;
        String messageClass = "x-error-message";
        if (message != null) {
            if (message.getSeverity() == FacesMessage.SEVERITY_INFO) {
                styleClass = (String)component.getAttributes().get("infoClass");
                messageClass = "x-info-message";
            } else if (message.getSeverity() == FacesMessage.SEVERITY_WARN) {
                styleClass = (String)component.getAttributes().get("warnClass");
                messageClass = "x-warn-message";
            } else if (message.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                styleClass = (String)component.getAttributes().get("errorClass");
                messageClass = "x-error-message";
            } else if (message.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                styleClass = (String)component.getAttributes().get("fatalClass");
                messageClass = "x-fatal-message";
            }
        }
        if (styleClass == null) {
            styleClass = (String)component.getAttributes().get("styleClass");
        }
        if (styleClass == null) {
            styleClass = messageClass;
        }
        return styleClass;
    }

    private static String initTitle(FacesContext context, UIComponent component) {
        String title;
        FacesMessage message = MessageRenderer.getFacesMessage((FacesContext)context, (UIComponent)component);
        String summary = null;
        if (message != null && (summary = message.getSummary()) == null) {
            summary = "";
        }
        Object tooltipVal = component.getAttributes().get("tooltip");
        boolean tooltip = false;
        if (tooltipVal instanceof Boolean) {
            tooltip = (Boolean)tooltipVal;
        }
        if ((title = (String)component.getAttributes().get("title")) == null && tooltip) {
            title = summary;
        }
        if (title == null) {
            title = "";
        }
        return title;
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return LITE_ATTRIBUTES;
    }
}

