/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.render.ajax.AjaxInputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.html.TextRenderer;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxTextRenderer
extends AjaxInputRenderer
implements ToolBarItemRenderer {
    protected TextRenderer delegate = new TextRenderer();
    protected static Map<String, LiteAttributeEncoder> LITE_ATTRIBUTE = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(RendererUtils.HTML_LITE_ATTRIBUTES){
        {
            this.put("autocomplete", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    if ("off".equals(component.getAttributes().get("autocomplete"))) {
                        out.writeAttributeScript(component.getClientId(context), "autocomplete", (Object)"off");
                    }
                }
            });
        }
    });

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.delegate.decode(context, component);
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        this.delegate.encodeHtmlBegin(context, component);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        this.delegate.encodeHtmlChildren(context, component);
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        this.delegate.encodeHtmlEnd(context, component);
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        Set attrs = uc.getAttributeCandidates(component);
        if (uc.isUpdateValue(component)) {
            if (component instanceof UIInput) {
                out.writeAttributeScript(component.getClientId(context), "value", (Object)this.getCurrentValue(context, component));
            } else {
                Object value = this.getValue(component);
                String text = value == null ? RendererUtils.encodeComponentChildren((FacesContext)context, (UIComponent)component) : this.getFormattedValue(context, component, value);
                if (text == null) {
                    text = "";
                } else if (RendererUtils.needsEscape((UIComponent)component)) {
                    text = HtmlEncoder.encode((String)text);
                }
                out.writeInnerHtmlScript(component.getClientId(context), text);
            }
            attrs.remove("value");
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    protected void encodeInputText(FacesContext context, UIComponent component) throws IOException {
    }

    public String getToolBarItemAddScript(FacesContext context, UIComponent item, String jsvar) {
        return this.delegate.getToolBarItemAddScript(context, item, jsvar);
    }

    public String getToolBarItemAddElement(FacesContext context, UIComponent item) {
        return this.delegate.getToolBarItemAddElement(context, item);
    }

    public String getToolBarItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        return this.delegate.getToolBarItemInitScript(context, component, parent);
    }

    public boolean ignoreChildren() {
        return true;
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return LITE_ATTRIBUTE;
    }
}

