/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.layout.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.AjaxActionEventHandler;
import org.operamasks.faces.component.layout.impl.UIAccordionLayout;
import org.operamasks.faces.component.layout.impl.UICardLayout;
import org.operamasks.faces.component.layout.impl.UIPanel;
import org.operamasks.faces.component.layout.impl.UITabLayout;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ExtRenderer;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.ToolBarHelper;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.user.ajax.PartialUpdateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayoutRenderer
extends ExtRenderer {
    protected static final String FULL_WIDTH_HEIGHT = "width:100%;height:100%;";
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AbstractLayoutRenderer() {
        liteAttrCore.put("title", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String title = (String)component.getAttributes().get("title");
                if (title != null) {
                    out.writeScriptBlock(String.format("%s.setTitle('%s');", jsvar, title));
                }
            }
        });
        liteAttrCore.put("width", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String width = (String)component.getAttributes().get("width");
                if (width != null) {
                    if (AbstractLayoutRenderer.this.isPercentStr(width)) {
                        StringBuilder buf = new StringBuilder();
                        Formatter fmt = new Formatter(buf);
                        fmt.format("var parentNode = Ext.get('%s').findParentNode('',1,true);", jsvar);
                        buf.append("if(parentNode == null){parentNode =Ext.getBody();}");
                        fmt.format("%s.setWidth(Math.round(parentNode.getWidth()*%f));", jsvar, AbstractLayoutRenderer.this.percentToDouble(width));
                        out.writeScriptBlock(buf.toString());
                    } else {
                        out.writeScriptBlock(String.format("%s.setWidth(%s);", jsvar, width));
                    }
                }
            }
        });
        liteAttrCore.put("height", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String height = (String)component.getAttributes().get("height");
                if (height != null) {
                    if (AbstractLayoutRenderer.this.isPercentStr(height)) {
                        StringBuilder buf = new StringBuilder();
                        Formatter fmt = new Formatter(buf);
                        fmt.format("var parentNode = Ext.get('%s').findParentNode('',1,true);", jsvar);
                        buf.append("if(parentNode == null){parentNode =Ext.getBody();}");
                        fmt.format("%s.setHeight(Math.round(parentNode.getHeight()*%f));", jsvar, AbstractLayoutRenderer.this.percentToDouble(height));
                        out.writeScriptBlock(buf.toString());
                    } else {
                        out.writeScriptBlock(String.format("%s.setHeight(%s);", jsvar, height));
                    }
                }
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)component.getClientId(context), null);
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        String defaultStyle = "";
        boolean isFit = Boolean.TRUE.equals(component.getAttributes().get("fit"));
        if (isFit) {
            defaultStyle = FULL_WIDTH_HEIGHT;
        }
        if ((style = style != null && style.length() > 0 ? String.valueOf(defaultStyle) + style : defaultStyle).trim().length() > 0 && !style.trim().endsWith(";")) {
            style = String.valueOf(style) + ";";
        }
        Boolean parentIsContainer = RendererUtils.isContainer((UIComponent)component.getParent());
        String width = ((UIPanel)component).getWidth();
        if (width != null) {
            if (this.isPercentStr(width)) {
                style = String.valueOf(style) + "width:" + width.trim() + ";";
            } else if (!parentIsContainer.booleanValue()) {
                style = String.valueOf(style) + "width:" + width.trim() + "px;";
            }
        } else if (!isFit) {
            boolean widthSet;
            boolean bl = widthSet = style.startsWith("width:") || style.matches(";width:") || style.matches(";\\swidth:");
            if (!widthSet) {
                parentIsContainer.booleanValue();
            }
        }
        String height = ((UIPanel)component).getHeight();
        if (height == null && !isFit) {
            boolean heightSet;
            boolean bl = heightSet = style.startsWith("height:") || style.matches(".*;height:.*") || style.matches(".*;\\sheight:.*");
            if (!heightSet) {
                parentIsContainer.booleanValue();
            }
        }
        out.writeAttribute("style", (Object)style, "style");
        if (styleClass != null && styleClass.length() > 0) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        out.write("\n");
        if (out instanceof AjaxHtmlResponseWriter) {
            ((AjaxHtmlResponseWriter)out).setViewStateChanged();
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.endElement("div");
        out.write("\n");
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.Layout"};
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        String script = ToolBarHelper.encodeItemInitScript(context, component, ToolBar.class, true);
        if (script.length() > 0) {
            ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
            resource.addInitScript(script);
        }
    }

    protected boolean encodeAsItem(UIComponent component) {
        return !RendererUtils.isContainer((UIComponent)component.getParent());
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String jsvar = resource.allocVariable(component);
        StringBuffer buf = new StringBuffer();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("panel");
        fmt.format("%s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias(this.getExtClass(component)), c.start());
        ExtConfig config = new ExtConfig(component);
        String clientId = component.getClientId(context);
        UIPanel panel = (UIPanel)component;
        String width = panel.getWidth();
        String height = panel.getHeight();
        if (this.encodeAsItem(component)) {
            config.set("applyTo", clientId);
            if (width != null && !this.isPercentStr(width)) {
                config.set("width", width.trim(), true);
            }
            if (height != null && !this.isPercentStr(height)) {
                config.set("height", height.trim(), true);
            }
        } else {
            if (width != null && !this.isPercentStr(width)) {
                config.set("width", width.trim(), true);
            }
            if (height != null && !this.isPercentStr(height)) {
                config.set("height", height.trim(), true);
            }
        }
        this.processExtConfig(context, component, config);
        this.postProcessExtConfig(component, config);
        String configStr = config.toScript(c);
        buf.append(configStr);
        if (this.hasItemChildren(component)) {
            fmt.format(",%s:[", c.prop("items"));
        }
        resource.addInitScriptBegin(fmt.toString());
    }

    public void encodeResourceEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        StringBuilder script = new StringBuilder();
        if (this.hasItemChildren(component)) {
            script.append("]");
        }
        this.encodeToolbar(context, component, script);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("panel");
        script.append("}").append(c.end()).append(")");
        UIComponent parent = component.getParent();
        if (this.isContainer(parent)) {
            if (!component.equals(RendererUtils.getLastContainerItem((UIComponent)parent))) {
                script.append(",");
            }
        } else {
            script.append(";");
        }
        resource.addInitScriptEnd(script.toString());
    }

    protected boolean isContainer(UIComponent component) {
        if (RendererUtils.isContainer((UIComponent)component)) {
            return true;
        }
        UIComponent parent = component.getParent();
        while (parent != null && parent.getClass().getName().equals("org.operamasks.faces.component.ajax.AjaxUpdater")) {
            parent = parent.getParent();
        }
        return parent != null && RendererUtils.isContainer((UIComponent)parent);
    }

    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        StringBuilder buf = new StringBuilder();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        StringBuilder fmtStr = new StringBuilder();
        Aliases alias = Aliases.getInstance((FacesContext)context);
        if (!this.isSizeSpecial(component)) {
            String height;
            UIPanel panel = (UIPanel)component;
            Boolean parentIsContainer = null;
            String width = panel.getWidth();
            if (width != null && this.isPercentStr(width)) {
                double percentWidth = this.percentToDouble(width);
                parentIsContainer = RendererUtils.isContainer((UIComponent)component.getParent());
                if (!parentIsContainer.booleanValue()) {
                    fmtStr.append(String.format("%s(null,'%s',%s,%f,'width');", alias.alias("OM.layout.fixPercentSize"), component.getClientId(context), jsvar, percentWidth));
                } else {
                    fmtStr.append(String.format("%s(%s,null,%s,%f,'width');", alias.alias("OM.layout.fixPercentSize"), FacesUtils.getJsvar((FacesContext)context, (UIComponent)component.getParent()), jsvar, percentWidth));
                }
            }
            if ((height = panel.getHeight()) != null && this.isPercentStr(height)) {
                if (parentIsContainer == null) {
                    parentIsContainer = RendererUtils.isContainer((UIComponent)component.getParent());
                }
                double percentHeight = this.percentToDouble(height);
                if (!parentIsContainer.booleanValue()) {
                    fmtStr.append(String.format("%s(null,'%s',%s,%f,'height');", alias.alias("OM.layout.fixPercentSize"), component.getClientId(context), jsvar, percentHeight));
                }
            }
        }
        if (fmtStr.length() > 0) {
            buf.append(fmtStr.toString());
            buf.append(alias.alias("Ext.EventManager.onWindowResize")).append("(function(){");
            buf.append(fmtStr.toString());
            buf.append("});\n");
            resource.addInitScriptEnd(buf.toString());
            if (!RendererUtils.isContainer((UIComponent)component.getParent())) {
                RendererUtils.addLastScript((String)String.format("%s.doLayout();", alias.var(jsvar)));
                RendererUtils.addLastScript((String)String.format("%s(function(){%s.doLayout();});", alias.alias("Ext.EventManager.onWindowResize"), jsvar));
            }
        }
        AjaxActionEventHandler handler = new AjaxActionEventHandler(component);
        resource.addInitScript(handler.toScript());
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    protected void addConfig(UIPanel panel, ExtConfig config, String name) {
        Object value = panel.getAttributes().get(name);
        if (value != null) {
            config.set(name, value);
        }
    }

    protected void addConfig(ExtConfig config, String name, Object value) {
        if (value != null) {
            config.set(name, value);
        }
    }

    protected void encodeToolbar(FacesContext context, UIComponent component, StringBuilder script) {
        Iterator<ToolBar> toolbars = ToolBarHelper.getToolBarIterator(component, ToolBar.class, true);
        String toolbarScript = ToolBarHelper.encodeToolBarExtConfig(context, component, toolbars);
        if (toolbarScript.length() > 0) {
            script.append(",").append(toolbarScript);
        }
    }

    protected boolean isPercentStr(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().endsWith("%");
    }

    protected boolean hasItemChildren(UIComponent component) {
        for (UIComponent c : component.getChildren()) {
            if (RendererUtils.isContainerItem((UIComponent)c)) {
                return true;
            }
            if (!this.hasItemChildren(c)) continue;
            return true;
        }
        return false;
    }

    protected double percentToDouble(String percentStr) {
        if (!this.isPercentStr(percentStr)) {
            return 0.0;
        }
        return (double)Integer.parseInt(percentStr.trim().substring(0, percentStr.trim().indexOf("%"))) / 100.0;
    }

    protected boolean isSizeSpecial(UIComponent component) {
        UIComponent parent = component.getParent();
        return parent != null && (parent instanceof UITabLayout || parent instanceof UICardLayout || parent instanceof UIAccordionLayout);
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }

    public void setWidth(UIPanel panel, String width) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)panel, new String[]{"width"});
    }

    public void setHeight(UIPanel panel, String height) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)panel, new String[]{"height"});
    }

    public void setTitle(UIPanel panel, String title) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)panel, new String[]{"title"});
    }

    public void collapse(UIPanel panel, boolean animate) {
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)panel);
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.addOperationScript(String.format("%s.collapse(%b);", jsvar, animate));
    }

    public void expand(UIPanel panel, boolean animate) {
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)panel);
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.addOperationScript(String.format("%s.expand(%b);", jsvar, animate));
    }
}

