/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.layout.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.html.HtmlGridCell;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.util.StructureValidateUtils;

public class AjaxPanelGridRenderer
extends AjaxRendererBase {
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("table", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
        out.writeText((Object)"\n", null);
        this.renderCaption(context, component);
        this.renderHeader(context, component);
        this.renderFooter(context, component);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        this.renderBody(context, component);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.endElement("table");
        out.writeText((Object)"\n", null);
    }

    private void renderCaption(FacesContext context, UIComponent component) throws IOException {
        UIComponent caption = component.getFacet("caption");
        if (caption == null || !caption.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String captionClass = (String)component.getAttributes().get("captionClass");
        String captionStyle = (String)component.getAttributes().get("captionStyle");
        out.startElement("caption", caption);
        if (captionClass != null) {
            out.writeAttribute("class", (Object)captionClass, "captionClass");
        }
        if (captionStyle != null) {
            out.writeAttribute("style", (Object)captionStyle, "captionStyle");
        }
        caption.encodeAll(context);
        out.endElement("caption");
    }

    private void renderHeader(FacesContext context, UIComponent component) throws IOException {
        UIComponent header = component.getFacet("header");
        if (header == null || !header.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String headerClass = (String)component.getAttributes().get("headerClass");
        out.startElement("thead", component);
        out.writeText((Object)"\n", null);
        out.startElement("tr", header);
        out.startElement("th", header);
        if (headerClass != null) {
            out.writeAttribute("class", (Object)headerClass, "headerClass");
        }
        this.writeCellpadding(component, out);
        out.writeAttribute("colspan", (Object)this.getColumnCount(component), null);
        out.writeAttribute("scope", (Object)"colgroup", null);
        header.encodeAll(context);
        out.endElement("th");
        out.endElement("tr");
        out.writeText((Object)"\n", null);
        out.endElement("thead");
        out.writeText((Object)"\n", null);
    }

    private void renderFooter(FacesContext context, UIComponent component) throws IOException {
        UIComponent footer = component.getFacet("footer");
        if (footer == null || !footer.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String footerClass = (String)component.getAttributes().get("footerClass");
        out.startElement("tfoot", component);
        out.writeText((Object)"\n", null);
        out.startElement("tr", footer);
        out.startElement("td", footer);
        if (footerClass != null) {
            out.writeAttribute("class", (Object)footerClass, "footerClass");
        }
        this.writeCellpadding(component, out);
        out.writeAttribute("colspan", (Object)this.getColumnCount(component), null);
        footer.encodeAll(context);
        out.endElement("td");
        out.endElement("tr");
        out.writeText((Object)"\n", null);
        out.endElement("tfoot");
        out.writeText((Object)"\n", null);
    }

    protected void renderBody(FacesContext context, UIComponent component) throws IOException {
        int columns = this.getColumnCount(component);
        String[] rowClasses = this.getStyleClasses(component, "rowClasses");
        String[] columnClasses = this.getStyleClasses(component, "columnClasses");
        int rowStyles = rowClasses.length;
        int columnStyles = columnClasses.length;
        int rowStyleIndex = 0;
        int columnStyleIndex = 0;
        int columnIndex = 0;
        int[] rowSpans = new int[columns];
        boolean isRowStart = true;
        boolean isRowEnd = false;
        ResponseWriter out = context.getResponseWriter();
        out.startElement("tbody", component);
        out.write("\n");
        for (UIComponent kid : component.getChildren()) {
            if (!kid.isRendered()) continue;
            if (StructureValidateUtils.isLiteralText((UIComponent)kid)) {
                kid.encodeAll(context);
                continue;
            }
            if (isRowStart) {
                out.startElement("tr", component);
                if (rowStyles > 0) {
                    out.writeAttribute("class", (Object)rowClasses[rowStyleIndex], "rowClasses");
                }
                columnStyleIndex = 0;
                isRowStart = false;
            }
            int i = columnIndex;
            while (i < columns) {
                if (rowSpans[i] > 1) {
                    int n = i++;
                    rowSpans[n] = rowSpans[n] - 1;
                    ++columnIndex;
                    ++columnStyleIndex;
                    continue;
                }
                columnIndex = i;
                break;
            }
            if (columnIndex >= columns) {
                columnIndex = 0;
            }
            if (columnStyleIndex >= columnStyles) {
                columnStyleIndex = 0;
            }
            if (kid instanceof HtmlGridCell) {
                out.startElement("td", kid);
                String styleClass = (String)kid.getAttributes().get("styleClass");
                if (styleClass == null && columnStyles > 0) {
                    styleClass = columnClasses[columnStyleIndex];
                }
                if (styleClass != null) {
                    out.writeAttribute("class", (Object)styleClass, "styleClass");
                }
                this.addCellPaddingToStyle(component, kid);
                RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)kid, (String)"styleClass");
                kid.encodeAll(context);
                out.endElement("td");
                out.write("\n");
                int rowspan = ((HtmlGridCell)kid).getRowspan();
                int colspan = ((HtmlGridCell)kid).getColspan();
                if (rowspan == 0) {
                    rowspan = Integer.MAX_VALUE;
                } else if (rowspan <= 1) {
                    rowspan = 1;
                }
                if (colspan == 0) {
                    colspan = columns - columnIndex;
                } else if (colspan > 1) {
                    if (columnIndex + colspan > columns) {
                        colspan = columns - columnIndex;
                    }
                } else {
                    colspan = 1;
                }
                for (int i2 = columnIndex; i2 < columnIndex + colspan; ++i2) {
                    rowSpans[i2] = rowspan;
                }
                columnIndex += colspan;
                columnStyleIndex += colspan;
            } else {
                out.startElement("td", component);
                if (columnStyles > 0) {
                    out.writeAttribute("class", (Object)columnClasses[columnStyleIndex], "columnClasses");
                }
                this.writeCellpadding(component, out);
                kid.encodeAll(context);
                out.endElement("td");
                out.write("\n");
                ++columnIndex;
                ++columnStyleIndex;
            }
            i = columnIndex;
            while (i < columns) {
                if (rowSpans[i] > 1) {
                    int n = i++;
                    rowSpans[n] = rowSpans[n] - 1;
                    ++columnIndex;
                    ++columnStyleIndex;
                    continue;
                }
                columnIndex = i;
                break;
            }
            if (columnIndex >= columns) {
                columnIndex = 0;
                isRowEnd = true;
            }
            if (columnStyleIndex >= columnStyles) {
                columnStyleIndex = 0;
            }
            if (!isRowEnd) continue;
            out.endElement("tr");
            out.write("\n");
            isRowEnd = false;
            isRowStart = true;
            if (++rowStyleIndex < rowStyles) continue;
            rowStyleIndex = 0;
        }
        if (!isRowEnd && !isRowStart) {
            out.endElement("tr");
            out.write("\n");
        }
        out.endElement("tbody");
        out.writeText((Object)"\n", null);
    }

    private String[] getStyleClasses(UIComponent component, String name) {
        String values = (String)component.getAttributes().get(name);
        if (values == null) {
            return new String[0];
        }
        String[] result = values.split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    private int getColumnCount(UIComponent component) {
        Integer count = (Integer)component.getAttributes().get("columns");
        if (count == null) {
            return 2;
        }
        if (count < 1) {
            int childCount = 0;
            for (UIComponent kid : component.getChildren()) {
                if (!kid.isRendered()) continue;
                ++childCount;
            }
            return childCount;
        }
        return count;
    }

    private void writeCellpadding(UIComponent component, ResponseWriter out) throws IOException {
        String cellpadding = this.getCellPaddingWithUnit(component);
        if (cellpadding != null) {
            out.writeAttribute("style", (Object)("padding:" + cellpadding), "cellpadding");
        }
    }

    private void addCellPaddingToStyle(UIComponent cellpaddingSource, UIComponent styleTarget) {
        String style;
        String cellpadding = this.getCellPaddingWithUnit(cellpaddingSource);
        if (cellpadding != null && (style = (String)styleTarget.getAttributes().get("style")) != null && style.indexOf("padding:") == -1) {
            styleTarget.getAttributes().put("style", "padding:" + cellpadding + ";" + style);
        }
    }

    private String getCellPaddingWithUnit(UIComponent component) {
        String cellpadding = (String)component.getAttributes().get("cellpadding");
        if (cellpadding != null && Pattern.matches("[0-9]+", cellpadding)) {
            cellpadding = cellpadding + "px";
        }
        return cellpadding;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)uc.getAttributeCandidates(component), (Map)this.getLiteAttributes());
    }
}

