/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.layout.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.layout.impl.UIAccordionLayout;
import org.operamasks.faces.component.layout.impl.UIBorderLayout;
import org.operamasks.faces.component.layout.impl.UICardLayout;
import org.operamasks.faces.component.layout.impl.UIPanel;
import org.operamasks.faces.component.layout.impl.UITabLayout;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.layout.ajax.AbstractLayoutRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.LoggerUtil;

public class AjaxPanelRenderer
extends AbstractLayoutRenderer {
    protected static final String INNER_FRAME_ID = "_frame";
    protected static Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        UIPanel panel = (UIPanel)component;
        if (panel.getUrl() != null) {
            return;
        }
        out.startElement("div", component);
        out.writeAttribute("id", (Object)component.getClientId(context), null);
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        String defaultStyle = "";
        boolean isFit = Boolean.TRUE.equals(component.getAttributes().get("fit"));
        if (isFit) {
            defaultStyle = "width:100%;height:100%;";
        }
        if ((style = style != null && style.length() > 0 ? String.valueOf(defaultStyle) + style : defaultStyle).trim().length() > 0 && !style.trim().endsWith(";")) {
            style = String.valueOf(style) + ";";
        }
        Boolean parentIsContainer = RendererUtils.isContainer((UIComponent)component.getParent());
        Boolean parentUnsupportPercent = component.getParent() instanceof UICardLayout || component.getParent() instanceof UITabLayout;
        String width = ((UIPanel)component).getWidth();
        if (width != null) {
            if (this.isPercentStr(width)) {
                style = String.valueOf(style) + "width:" + width.trim() + ";";
            } else if (!parentIsContainer.booleanValue()) {
                style = String.valueOf(style) + "width:" + width.trim() + "px;";
            }
        } else if (!isFit) {
            boolean widthSet = false;
            if (style != null && style.indexOf("width") > 0) {
                widthSet = true;
            }
            if (!widthSet && !parentUnsupportPercent.booleanValue()) {
                style = String.valueOf(style) + "width:100%;";
            }
        }
        String height = ((UIPanel)component).getHeight();
        if (height != null) {
            if (this.isPercentStr(height)) {
                style = String.valueOf(style) + "height:" + height.trim() + ";";
            } else if (!parentIsContainer.booleanValue()) {
                style = String.valueOf(style) + "height:" + height.trim() + "px;";
            }
        } else if (!isFit) {
            boolean heightSet = false;
            if (style != null && style.indexOf("width") > 0) {
                heightSet = true;
            }
            if (!(heightSet || parentUnsupportPercent.booleanValue() || this.isAutoHeightRegion((UIPanel)component))) {
                style = String.valueOf(style) + "height:100%;";
            }
        }
        out.writeAttribute("style", (Object)style, "style");
        if (styleClass != null && styleClass.length() > 0) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        out.write("\n");
        boolean autoScroll = Boolean.TRUE.equals(panel.getAutoScroll());
        if (!RendererUtils.isContainer((UIComponent)component.getParent()) || autoScroll) {
            out.startElement("div", component);
            out.writeAttribute("id", (Object)this.getSinglePanelContentId(context, component), null);
            String contentStyle = "overflow:visible;*overflow:auto;_overflow:auto;position: relative;";
            if (autoScroll || panel.getHeight() != null && panel.getAutoScroll() == null) {
                contentStyle = String.valueOf(contentStyle) + "height:100%";
            }
            out.writeAttribute("style", (Object)contentStyle, null);
        }
    }

    private boolean isAutoHeightRegion(UIPanel panel) {
        assert (panel.getParent() != null);
        String region = panel.getRegion();
        return panel.getParent() instanceof UIBorderLayout && ("east".equals(region) || "center".equals(region) || "west".equals(region));
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        UIPanel panel = (UIPanel)component;
        if (panel.getUrl() != null) {
            return;
        }
        if (!RendererUtils.isContainer((UIComponent)component.getParent()) || Boolean.TRUE.equals(((UIPanel)component).getAutoScroll())) {
            HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
            out.endElement("div");
        }
        super.encodeHtmlEnd(context, component);
    }

    public void encodeResourceEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        StringBuilder buf = new StringBuilder();
        if (this.hasItemChildren(component)) {
            buf.append("]");
        }
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("panel");
        this.encodeToolbar(context, component, buf);
        UIPanel panel = (UIPanel)component;
        if (panel.getUrl() != null) {
            Formatter fmt = new Formatter(buf);
            fmt.format(",%s:'<iframe style=\"width: 100%%; height: 100%%;\" frameborder=\"no\"", c.prop("html"));
            String frameName = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component).concat(INNER_FRAME_ID);
            fmt.format(" id=\"%s\" name=\"%s\"", frameName, frameName);
            if (!Boolean.TRUE.equals(panel.getLazyLoad())) {
                fmt.format(" src=\"%s\"", FacesUtils.fixURL((String)panel.getUrl()));
            }
            buf.append("/>'");
            if (Boolean.TRUE.equals(panel.getLazyLoad())) {
                String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)panel);
                fmt.format(",%s:{", c.prop("listeners"));
                fmt.format("'%s':{", this.calPanelListenerType((UIComponent)panel));
                fmt.format("fn:function() {document.getElementById('%s%s').src='%s';},", jsvar, INNER_FRAME_ID, FacesUtils.fixURL((String)panel.getUrl()));
                buf.append("single:true}}");
            }
        }
        buf.append("}").append(c.end()).append(")");
        UIComponent parent = component.getParent();
        if (RendererUtils.isContainer((UIComponent)parent)) {
            if (!component.equals(RendererUtils.getLastContainerItem((UIComponent)parent))) {
                buf.append(",");
            }
        } else {
            buf.append(";");
        }
        resource.addInitScriptEnd(buf.toString());
    }

    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        UIPanel panel = (UIPanel)component;
        String title = panel.getTitle();
        if (title != null) {
            config.set("title", title);
        }
        if (panel.getLayout() == null) {
            config.set("layout", "fit");
        }
        this.addConfig(panel, config, "ctCls");
        this.addConfig(panel, config, "iconCls");
        this.addConfig(config, "cls", panel.getAttributes().get("styleClass"));
        if (panel.getUrl() == null || panel.getUrl().length() == 0) {
            if (!RendererUtils.isContainer((UIComponent)component.getParent()) || Boolean.TRUE.equals(panel.getAutoScroll())) {
                config.set("contentEl", this.getSinglePanelContentId(context, component));
            } else {
                config.set("contentEl", component.getClientId(context));
            }
        }
        if (("east".equals(panel.getRegion()) || "west".equals(panel.getRegion())) && panel.getWidth() == null) {
            config.set("width", 100);
        }
        if (("north".equals(panel.getRegion()) || "south".equals(panel.getRegion())) && panel.getHeight() == null) {
            config.set("height", 100);
        }
    }

    protected String getExtClass(UIComponent component) {
        return "Ext.Panel";
    }

    protected String getSinglePanelContentId(FacesContext context, UIComponent component) {
        return String.valueOf(component.getClientId(context)) + "_content";
    }

    private String calPanelListenerType(UIComponent panel) {
        if (panel.getParent() instanceof UITabLayout) {
            return "activate";
        }
        if (panel.getParent() instanceof UICardLayout) {
            return "show";
        }
        if (panel.getParent() instanceof UIAccordionLayout) {
            return "expand";
        }
        if (panel.getParent() instanceof UIBorderLayout) {
            return "expand";
        }
        return "activate";
    }
}

