/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.layout.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.layout.FramePanel;
import org.operamasks.faces.component.layout.impl.UIPanel;
import org.operamasks.faces.component.layout.impl.UITabLayout;
import org.operamasks.faces.component.layout.impl.UIWindow;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.layout.ajax.AbstractLayoutRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.ToolBarHelper;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxTabLayoutRenderer
extends AbstractLayoutRenderer {
    private static final String ACTIVE_TAB_PARAM = "_ActiveTab";

    @Override
    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.ux.TabPanel"};
    }

    public void decode(FacesContext context, UIComponent component) {
        UITabLayout tabLayout = null;
        if (component != null && component instanceof UITabLayout) {
            tabLayout = (UITabLayout)component;
        }
        if (context == null || tabLayout == null) {
            throw new NullPointerException();
        }
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String activeTab = (String)requestMap.get(String.valueOf(tabLayout.getClientId(context)) + ACTIVE_TAB_PARAM);
        if (activeTab != null) {
            tabLayout.setActiveTab(Integer.parseInt(activeTab));
        }
    }

    @Override
    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UITabLayout tab;
        List items;
        super.encodeInitScriptBegin(context, rm, component);
        ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        String script = ToolBarHelper.encodeItemInitScript(context, component, ToolBar.class, true);
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        if (script.length() > 0) {
            resource.addInitScript(script);
        }
        if ((items = (tab = (UITabLayout)component).getItems()) != null && items.size() > 0) {
            int index = 0;
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            for (Object obj : items) {
                if (!(obj instanceof FramePanel)) continue;
                FramePanel framePanel = (FramePanel)obj;
                resource.addVariable(framePanel.getJsvar(jsvar, index));
                resource.addInitScript(framePanel.toScript(jsvar, index));
                ++index;
            }
        }
    }

    @Override
    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        super.encodeInitScriptEnd(context, rm, component);
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        fmt.format("%s(%s,'%s');", alias.alias("OM.SC.setTabOnChange"), alias.var(jsvar), String.valueOf(component.getClientId(context)) + ACTIVE_TAB_PARAM);
        resource.addInitScript(fmt.toString());
    }

    @Override
    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UITabLayout tab = (UITabLayout)component;
        if ("left".equals(tab.getTabPosition()) || "right".equals(tab.getTabPosition())) {
            ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
            String jsvar = resource.allocVariable(component);
            Formatter fmt = new Formatter(new StringBuffer());
            Aliases alias = Aliases.getInstance((FacesContext)context);
            Aliases.ConfigBuilder c = alias.configBuilder("panel");
            fmt.format("%s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.ux.TabPanel"), c.start());
            ExtConfig config = new ExtConfig(component);
            if (!RendererUtils.isContainer((UIComponent)component.getParent())) {
                config.set("applyTo", component.getClientId(context));
            }
            this.processExtConfig(context, component, config);
            this.postProcessExtConfig(component, config);
            String configStr = config.toScript(c);
            fmt.format(configStr, new Object[0]);
            if (this.hasItemChildren(component)) {
                fmt.format(",%s:[", c.prop("items"));
            }
            resource.addInitScriptBegin(fmt.toString());
        } else {
            super.encodeResourceBegin(context, rm, component);
        }
    }

    @Override
    public void encodeResourceEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        super.encodeResourceEnd(context, rm, component);
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        UITabLayout tab = (UITabLayout)component;
        Aliases alias = Aliases.getInstance((FacesContext)context);
        List items = tab.getItems();
        if (items != null && items.size() > 0) {
            Formatter fmt = new Formatter();
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            int index = 0;
            for (Object obj : items) {
                if (obj == null || !(obj instanceof FramePanel)) continue;
                FramePanel framePanel = (FramePanel)obj;
                fmt.format("%s.add(%s);", alias.var(jsvar), alias.var(framePanel.getJsvar(jsvar, index)));
                ++index;
            }
            fmt.format("%s.activate(0);", alias.var(FacesUtils.getJsvar((FacesContext)context, (UIComponent)component)));
            resource.addInitScript(fmt.toString());
        }
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("name", (Object)(String.valueOf(component.getClientId(context)) + ACTIVE_TAB_PARAM), null);
        out.writeAttribute("id", (Object)(String.valueOf(component.getClientId(context)) + ACTIVE_TAB_PARAM), null);
        out.writeAttribute("value", (Object)"0", null);
        out.endElement("input");
        super.encodeHtmlEnd(context, component);
    }

    @Override
    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        config.set("activeTab", 0);
        config.set("deferredRender", false);
        config.set("autoScroll", true);
        config.set("plugins", "new " + Aliases.getAlias((String)"Ext.ux.TabCloseMenu") + "()", true);
        if (component.getParent() instanceof UIWindow) {
            config.set("applyTo", component.getClientId(context));
        }
    }

    @Override
    protected String getExtClass(UIComponent component) {
        return "Ext.TabPanel";
    }

    public void setActiveTab(UITabLayout tab, Integer activeTab) {
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tab);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        fmt.format("if(%s.items.get(%d)){", jsvar, activeTab);
        fmt.format("%s.activate(%s.items.get(%d));", jsvar, jsvar, activeTab);
        fmt.format("};", new Object[0]);
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(buf.toString());
    }

    public void addTab(UITabLayout tab, String title, String url, String iconClass, ExtConfig config) {
        String configScript;
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tab);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        fmt.format("if(typeof(%s) === 'undefined' && window.parent.%s){%s = window.parent.%s};", jsvar, jsvar, jsvar, jsvar);
        fmt.format("var item = %s.getItem('%s');\n", jsvar, title);
        fmt.format("if (item) {\n", new Object[0]);
        fmt.format("    item.show();\n", new Object[0]);
        fmt.format("    \n", new Object[0]);
        fmt.format("} else {\n", new Object[0]);
        fmt.format("%s.add({\n", jsvar);
        fmt.format("      id : '%s',\n", title);
        fmt.format("      title: '%s',\n", title);
        if (iconClass != null) {
            fmt.format("      iconCls: '%s',\n", iconClass);
        }
        buf.append("      html: '<iframe frameborder=\"no\" style=\"width: 100%;  height: 100%;\" src=\"");
        buf.append(FacesUtils.fixURL((String)url));
        buf.append("\"></iframe>',\n");
        fmt.format("      closable:true\n", new Object[0]);
        if (config != null && (configScript = config.toScript().trim()).length() != 0) {
            buf.append(",\n");
            buf.append(configScript);
        }
        fmt.format("   }).show();\n", new Object[0]);
        fmt.format("}\n", new Object[0]);
        UIComponent parent = tab.getParent();
        if (tab.getChildCount() == 0 && parent instanceof UIPanel) {
            fmt.format("if(%s.items.length ==1){%s.doLayout();}\n", jsvar, FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent));
        }
        if (Boolean.TRUE.equals(tab.getFit())) {
            fmt.format("if(%s.items.getCount()===1){", jsvar);
            fmt.format("    %s.setHeight(Ext.fly(%s.getEl().parent()).getHeight());", jsvar, jsvar);
            buf.append("}");
        }
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(buf.toString());
    }

    public void addTabs(UITabLayout tab, List<?> items) {
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tab);
        if (items != null && items.size() > 0) {
            StringBuffer buf = new StringBuffer();
            Formatter fmt = new Formatter(buf);
            int index = 0;
            String firstId = null;
            for (Object obj : items) {
                if (!(obj instanceof FramePanel)) continue;
                FramePanel framePanel = (FramePanel)obj;
                String innerJavar = framePanel.getJsvar(jsvar, index);
                if (firstId == null) {
                    firstId = innerJavar;
                }
                buf.append(framePanel.toScript(jsvar, index));
                fmt.format("%s.add(%s);\n", jsvar, innerJavar);
                ++index;
            }
            if (firstId != null) {
                fmt.format("%s.activate(%s);\n", jsvar, firstId);
            } else {
                fmt.format("%s.activate(0);\n", jsvar);
            }
            ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(fmt.toString());
        }
    }

    public void removeTab(UITabLayout tab, String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tab);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        UIComponent panel = tab.findComponent(id);
        if (panel != null) {
            fmt.format("%s.remove(%s);\n", jsvar, FacesUtils.getJsvar((FacesContext)context, (UIComponent)panel));
        } else {
            fmt.format("%s.remove('%s');\n", jsvar, id);
        }
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(buf.toString());
    }

    public void removeAllTab(UITabLayout tab) {
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tab);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        fmt.format("var items = %s.items;\n", jsvar);
        fmt.format("for(i=0;i<items.length;) {\n", new Object[0]);
        fmt.format("    %s.remove(items.get(0));\n", jsvar);
        fmt.format("}\n", new Object[0]);
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(buf.toString());
    }
}

