/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.layout.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.layout.impl.UIWindow;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.layout.ajax.AbstractLayoutRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.user.ajax.PartialUpdateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxWindowRenderer
extends AbstractLayoutRenderer {
    protected static final String INNER_FRAME_ID = "_frame";
    private static Map<String, LiteAttributeEncoder> liteAttributes = null;

    @Override
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        UIWindow window = (UIWindow)component;
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)component.getClientId(context), "clientId");
        out.writeAttribute("class", (Object)"x-hidden", null);
        String style = window.getStyle();
        String defaultStyle = "";
        style = style != null && style.length() > 0 ? String.valueOf(defaultStyle) + style : defaultStyle;
        out.writeAttribute("style", (Object)style, "style");
        out.write("\n");
        String title = window.getTitle();
        out.startElement("div", component);
        out.writeAttribute("class", (Object)"x-window-header", null);
        out.write(title == null ? "" : title);
        out.endElement("div");
        String bodyStyle = window.getBodyStyle();
        out.startElement("div", component);
        String styleExtra = "position:relative;";
        if (bodyStyle != null) {
            styleExtra = String.valueOf(styleExtra) + bodyStyle;
        }
        out.writeAttribute("style", (Object)styleExtra, null);
        out.writeAttribute("class", (Object)"x-window-body", null);
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.endElement("div");
        out.endElement("div");
        out.write("\n");
    }

    @Override
    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.Window"};
    }

    @Override
    public void encodeResourceEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        StringBuilder buf = new StringBuilder();
        if (this.hasItemChildren(component)) {
            buf.append("]\n");
        }
        this.encodeToolbar(context, component, buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("panel");
        UIWindow window = (UIWindow)component;
        if (window.getUrl() != null) {
            Formatter fmt = new Formatter(buf);
            fmt.format(",%s:'<iframe style=\"width: 100%; height: 100%;\" frameborder=\"no\"", c.prop("html"));
            String frameName = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component).concat(INNER_FRAME_ID);
            fmt.format(" id=\"%s\" name=\"%s\"", frameName, frameName);
            buf.append("/>'");
        }
        buf.append("}").append(c.end()).append(")");
        UIComponent parent = component.getParent();
        if (RendererUtils.isContainer((UIComponent)parent)) {
            if (!component.equals(RendererUtils.getLastContainerItem((UIComponent)parent))) {
                buf.append(",");
            }
        } else {
            buf.append(";");
        }
        resource.addInitScriptEnd(buf.toString());
    }

    @Override
    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        super.encodeInitScriptEnd(context, rm, component);
        UIWindow window = (UIWindow)component;
        if (Boolean.TRUE.equals(window.getShow())) {
            ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            resource.addInitScript(String.valueOf(jsvar) + ".show();\n");
        }
    }

    @Override
    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)((UIWindow)component), new String[]{"width"});
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)((UIWindow)component), new String[]{"height"});
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        if (attrs.contains("show")) {
            attrs.remove("show");
            AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
            Boolean show = (Boolean)component.getAttributes().get("show");
            if (show != null) {
                String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
                AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
                if (Boolean.TRUE.equals(show)) {
                    out.writeScriptBlock(String.format("%s.show();", jsvar));
                    component.getAttributes().put("show", null);
                } else {
                    out.writeScriptBlock(String.format("%s.hide();", jsvar));
                }
            }
        } else {
            AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
        }
    }

    @Override
    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        String styleClass;
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        UIWindow window = (UIWindow)component;
        String height = window.getHeight();
        if (height == null) {
            config.set("height", 100);
        } else if (this.isPercentStr(height)) {
            config.set("height", "Ext.getBody().getHeight()*" + this.percentToDouble(height), true);
        } else {
            config.set("height", window.getHeight(), true);
        }
        String width = window.getWidth();
        if (width == null) {
            config.set("width", 100);
        } else if (this.isPercentStr(width)) {
            config.set("width", "Ext.getBody().getWidth()*" + this.percentToDouble(width), true);
        } else {
            config.set("width", window.getWidth(), true);
        }
        Boolean modal = window.getModal();
        if (Boolean.TRUE.equals(modal)) {
            config.set("modal", true);
        }
        if ((styleClass = window.getStyleClass()) != null && styleClass.length() > 0) {
            config.set("cls", styleClass);
        }
        config.set("layout", "fit");
        config.set("closeAction", "hide");
        config.set("keys", String.format("[{key: 27, fn: function(){%s.hide();}}]", jsvar), true);
    }

    @Override
    protected String getExtClass(UIComponent component) {
        return "Ext.Window";
    }

    public void show(UIWindow window) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)window, new String[]{"show"});
    }

    public void close(UIWindow window) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)window, new String[]{"show"});
    }

    public void setModal(UIWindow window, Boolean modal) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)window, new String[]{"modal"});
    }

    public void setUrl(UIWindow window, String url) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)window, new String[]{"url"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        Class<AjaxWindowRenderer> clazz = AjaxWindowRenderer.class;
        synchronized (AjaxWindowRenderer.class) {
            if (liteAttributes == null) {
                liteAttributes = new HashMap<String, LiteAttributeEncoder>(super.getLiteAttributes());
                liteAttributes.put("modal", new LiteAttributeEncoder(){

                    public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                        Boolean modal = (Boolean)component.getAttributes().get("modal");
                        if (Boolean.TRUE.equals(modal)) {
                            Formatter fmt = new Formatter();
                            fmt.format("%1$s.modal=true;if (!%1$s.mask) {%1$s.mask = %1$s.container.createChild({cls:\"ext-el-mask\"}, %1$s.el.dom);%1$s.mask.enableDisplayMode(\"block\");%1$s.mask.hide();}", jsvar);
                            out.writeScriptBlock(fmt.toString());
                        } else if (Boolean.FALSE.equals(modal)) {
                            out.writeScriptBlock(String.format("%s.modal=false;", jsvar));
                        }
                    }
                });
                liteAttributes.put("show", null);
                liteAttributes.put("url", new LiteAttributeEncoder(){

                    public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                        UIWindow window = (UIWindow)component;
                        String url = window.getUrl();
                        if (url != null) {
                            StringBuffer buf = new StringBuffer();
                            Formatter fmt = new Formatter(buf);
                            String fixedUrl = FacesUtils.fixURL((String)window.getUrl());
                            if (!Boolean.TRUE.equals(window.getLazyLoad())) {
                                fmt.format("window.frames['%s%s'].location.href='%s';", jsvar, AjaxWindowRenderer.INNER_FRAME_ID, fixedUrl);
                            } else {
                                fmt.format("\nif(%s.isVisible()){\n", jsvar);
                                fmt.format("    window.frames['%s%s'].location.href='%s';\n", jsvar, AjaxWindowRenderer.INNER_FRAME_ID, fixedUrl);
                                buf.append("}else{\n");
                                fmt.format("    %s.purgeListeners();\n", jsvar);
                                fmt.format("    %s.addListener('show',function(){", jsvar);
                                fmt.format("window.frames['%s%s'].location.href='%s';", jsvar, AjaxWindowRenderer.INNER_FRAME_ID, fixedUrl);
                                buf.append("},this,{single: true});\n");
                                buf.append("}");
                            }
                            out.writeScriptBlock(buf.toString());
                        }
                    }
                });
                liteAttributes.put("width", new LiteAttributeEncoder(){

                    public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                        UIWindow window = (UIWindow)component;
                        String width = window.getWidth();
                        if (width == null) {
                            width = "100";
                        }
                        out.writeScriptBlock(String.format("%s.setWidth(%s);", jsvar, width));
                    }
                });
                liteAttributes.put("height", new LiteAttributeEncoder(){

                    public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                        UIWindow window = (UIWindow)component;
                        String height = window.getHeight();
                        if (height == null) {
                            height = "100";
                        }
                        out.writeScriptBlock(String.format("%s.setHeight(%s);", jsvar, height));
                    }
                });
                liteAttributes = Collections.unmodifiableMap(liteAttributes);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return liteAttributes;
        }
    }

    @Override
    protected boolean encodeAsItem(UIComponent component) {
        return true;
    }
}

