/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectGroupRenderer
extends AjaxRendererBase {
    protected List<String> jsvarNames = new ArrayList<String>();

    protected abstract String buildHtmls(FacesContext var1, UIComponent var2);

    protected abstract String buildScripts(FacesContext var1, UIComponent var2);

    protected String generateSelectBoxId(String prefix, int index) {
        return prefix + "_" + index;
    }

    protected String generateStateChangerName(String jsvar) {
        return jsvar + "ChangeState";
    }

    public void show(UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        String containerId = component.getOuterContainerId(context);
        this.addOperationScript("document.getElementById('" + containerId + "').style.display='block';");
    }

    public void hide(UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        String containerId = component.getOuterContainerId(context);
        this.addOperationScript("document.getElementById('" + containerId + "').style.display='none';");
    }

    public void enable(UIComponent component) {
        StringBuffer sb = new StringBuffer();
        for (String jsvarName : this.jsvarNames) {
            sb.append(jsvarName).append(".enable();\n");
        }
        this.addOperationScript(sb.toString());
    }

    public void disable(UIComponent component) {
        StringBuffer sb = new StringBuffer();
        for (String jsvarName : this.jsvarNames) {
            sb.append(jsvarName).append(".disable();\n");
        }
        this.addOperationScript(sb.toString());
    }

    public void focus(UIComponent component) {
        if (this.jsvarNames.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.jsvarNames.get(0)).append(".focus();\n");
            this.addOperationScript(sb.toString());
        }
    }

    protected void invokeAjaxOperation(UIComponent component, String opName, Map<String, Object> attrs) {
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        if (attrs != null) {
            cm.getAttributes().putAll(attrs);
        }
        cm.invoke(context, opName, component);
    }

    protected void addOperationScript(String script) {
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(script);
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[]{"Ext.form"});
        resource.allocVariable(component);
        resource.addInitScript(this.buildScripts(context, component));
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        String containerId = component.getOuterContainerId(context);
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("OM.T(\"%s\",\"%s\");\n", containerId, this.buildHtmls(context, component));
        sb.append(this.buildScripts(context, component));
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        out.writeScriptBlock(sb.toString());
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        String containerId = component.getOuterContainerId(context);
        out.startElement("div", null);
        out.writeAttribute("id", (Object)containerId, null);
        if (style != null) {
            out.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, null);
        }
        out.write(this.buildHtmls(context, component));
        out.endElement("div");
    }
}

