/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.operamasks.faces.component.form.impl.UICheckBoxGroup;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.widget.ajax.AbstractSelectGroupRenderer;
import org.operamasks.faces.render.widget.helper.SelectItemsRenderHelper;

public class AjaxCheckBoxGroupRenderer
extends AbstractSelectGroupRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String checkBoxNames = this.getAllCheckBoxNames(context, component);
        ArrayList<SelectItem> newSelectItems = new ArrayList<SelectItem>();
        List<SelectItem> selectItems = SelectItemsRenderHelper.getSelectItems(component);
        HashSet submittedValue = new HashSet();
        String[] stringArray = checkBoxNames.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String checkBoxName = stringArray[n2];
            String currentStatus = (String)requestMap.get(checkBoxName);
            if (currentStatus != null) {
                Boolean newValue = "on".equals(requestMap.get(checkBoxName));
                String indexStr = checkBoxName.replace(String.valueOf(clientId) + "_", "");
                String label = selectItems.get(Integer.valueOf(indexStr) - 1).getLabel();
                newSelectItems.add(new SelectItem((Object)newValue, label));
            }
            ++n2;
        }
        SelectItemsRenderHelper.updateSelectItems(component, newSelectItems);
    }

    protected String buildHtmls(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        UICheckBoxGroup group = (UICheckBoxGroup)component;
        List<SelectItem> selectItems = SelectItemsRenderHelper.getSelectItems(component);
        int index = 1;
        Formatter fmt = new Formatter(new StringBuffer());
        fmt.format("<table><tr>", new Object[0]);
        for (SelectItem item : selectItems) {
            Boolean isChecked = Boolean.parseBoolean(item.getValue().toString());
            String strChecked = "";
            if (isChecked.booleanValue()) {
                strChecked = " checked='true'";
            }
            String checkBoxName = this.generateSelectBoxId(clientId, index);
            fmt.format("<td><input type='checkbox' id='%s' name='%s'%s/></td>", checkBoxName, checkBoxName, strChecked);
            if ("v".equals(group.getDirection()) || "vertical".equals(group.getDirection())) {
                fmt.format("</tr><tr>", new Object[0]);
            } else if (group.getDimension() != null && index % group.getDimension() == 0) {
                fmt.format("</tr><tr>", new Object[0]);
            }
            ++index;
        }
        fmt.format("</tr></table>", new Object[0]);
        return fmt.toString();
    }

    private String getAllCheckBoxNames(FacesContext context, UIComponent component) {
        List<SelectItem> selectItems = SelectItemsRenderHelper.getSelectItems(component);
        StringBuffer names = new StringBuffer();
        int index = 0;
        while (index < selectItems.size()) {
            names.append(component.getClientId(context));
            names.append("_");
            names.append(index + 1);
            names.append(",");
            ++index;
        }
        return names.toString();
    }

    protected String buildScripts(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        StringBuffer buf = new StringBuffer();
        Formatter fmt = new Formatter(buf);
        this.jsvarNames = new ArrayList();
        List<SelectItem> selectItems = SelectItemsRenderHelper.getSelectItems(component);
        int index = 1;
        for (SelectItem item : selectItems) {
            String clientId_checkBox = this.generateSelectBoxId(clientId, index);
            String jsvar_checkBox = this.generateSelectBoxId(jsvar, index);
            ++index;
            this.jsvarNames.add(jsvar_checkBox);
            fmt.format("var %s = new Ext.form.Checkbox({", jsvar_checkBox);
            ExtConfig config = new ExtConfig(component);
            config.set("boxLabel", item.getLabel());
            if (Boolean.TRUE.equals(((UICheckBoxGroup)component).getDisabled()) || item.isDisabled()) {
                config.set("disabled", true);
            }
            config.set("checked", Boolean.parseBoolean(item.getValue().toString()));
            String configStr = config.toScript();
            buf.append(configStr);
            fmt.format("});\n", new Object[0]);
            fmt.format("if(Ext.get('%s')) {%s.applyToMarkup('%s');}\n", clientId_checkBox, jsvar_checkBox, clientId_checkBox);
            String oncheck = "";
            UICheckBoxGroup checkboxGroup = (UICheckBoxGroup)component;
            if (checkboxGroup.getOncheck() != null && !(oncheck = checkboxGroup.getOncheck()).endsWith(";")) {
                oncheck = String.valueOf(oncheck) + ";";
            }
            fmt.format("%s.on('check',function(){%s});\n", jsvar_checkBox, oncheck);
        }
        return fmt.toString();
    }
}

