/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.form.impl.UICheckBox;
import org.operamasks.faces.component.form.impl.UIField;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.widget.ajax.AbstractFieldRenderer;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxCheckBoxRenderer
extends AbstractFieldRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!CompRendererUtils.needsDecode(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String currentStatus = (String)requestMap.get(clientId);
        if (currentStatus != null) {
            Boolean newValue = "on".equals(currentStatus);
            this.setSubmittedValue(component, newValue.toString());
            if (component instanceof UICheckBox) {
                ((UICheckBox)component).setChecked(newValue);
            }
        }
    }

    protected String getHtmlMarkup() {
        return "input";
    }

    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        if ("'true'".equals(config.get("value", String.class))) {
            config.set("checked", Boolean.TRUE);
        }
    }

    protected void beforeHtmlBegin(FacesContext context, UIComponent component) {
        ((UIField)component).setInputType("checkbox");
    }

    protected String getExtClass(UIComponent component) {
        return "Ext.form.Checkbox";
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        if (uc.isUpdateValue(component)) {
            StringBuilder script = new StringBuilder();
            String value = this.getCurrentValue(FacesContext.getCurrentInstance(), component);
            if (value == null) {
                value = "";
            }
            value = value.replaceAll("\\r", "");
            value = HtmlEncoder.enquote((String)value);
            script.append(String.format("%s.suspendEvents();", jsvar));
            if (value != null && value.length() != 0) {
                script.append(String.format("%s.setValue(%s);", jsvar, value));
            } else {
                script.append(String.format("%s.setValue(false);", jsvar));
            }
            script.append(String.format("%s.resumeEvents();\n", jsvar));
            out.writeScriptBlock(script.toString());
        }
        Set attr = uc.getAttributeCandidates(component);
        attr.remove("value");
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attr, (Map)liteAttributes);
    }
}

