/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.widget.menu.UICheckMenuItem;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxInputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.MenuItemRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxCheckMenuItemRenderer
extends AjaxInputRenderer
implements MenuItemRenderer {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxCheckMenuItemRenderer() {
        liteAttrCore.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                if (RendererUtils.isDisabled((UIComponent)component)) {
                    out.writeScriptBlock(String.format("%s.disable();", jsvar));
                } else {
                    out.writeScriptBlock(String.format("%s.enable();", jsvar));
                }
            }
        });
        liteAttrCore.put("label", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String text = HtmlEncoder.enquote((String)MenuRendererHelper.getItemText(context, component, false), (Character)Character.valueOf('\''));
                out.writeScriptBlock(String.format("%s.setText(%s);", jsvar, text));
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly((UIComponent)component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            String newValue = (String)paramMap.get(clientId);
            this.setSubmittedValue(component, newValue);
            ActionEvent event = new ActionEvent(component);
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            component.queueEvent((FacesEvent)event);
        }
    }

    @Override
    protected void renderCurrentValue(FacesContext context, UIComponent component, String currentValue) throws IOException {
        String clientId = component.getClientId(context);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        out.writeAttribute("value", (Object)currentValue, "value");
        out.endElement("input");
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UIMenu menu = MenuRendererHelper.getParentMenu(component);
        if (menu == null) {
            return;
        }
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        resource.addInitScript(this.getMenuItemInitScript(context, component, (UIComponent)menu));
    }

    public String getMenuItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        String clientId = component.getClientId(context);
        String text = MenuRendererHelper.getItemText(context, component, false);
        String value = this.getCurrentValue(context, component);
        String onbeforechange = (String)component.getAttributes().get("onbeforechange");
        String onchange = (String)component.getAttributes().get("onchange");
        String onclick = (String)component.getAttributes().get("click");
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        String var = resource.allocVariable(component);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        buf.append(RendererUtils.getJsvarAliasDef((String)var, (Aliases)alias));
        fmt.format("%s=new %s(%s{", var, alias.alias("Ext.menu.CheckItem"), c.start());
        var = alias.var(var);
        MenuRendererHelper.encodeItemConfig(fmt, context, component, text, c);
        if (value != null) {
            fmt.format(",%s:%b", c.prop("check"), Boolean.valueOf(value));
        }
        fmt.format("}%s);", c.end());
        if (onbeforechange != null) {
            fmt.format("%s.on('beforecheckchange', function(item,checked){%s});", var, onbeforechange);
        }
        fmt.format("%s.on('checkchange', function(item,checked){", var);
        if (onchange != null) {
            buf.append(onchange);
            if (!onchange.endsWith(";")) {
                buf.append(";");
            }
        }
        buf.append(RendererUtils.encodeAjaxSubmit((FacesContext)context, (UIComponent)component, (String)var, (String[])new String[]{HtmlEncoder.enquote((String)clientId), "checked"}));
        buf.append("});");
        if (onclick != null) {
            fmt.format("%s.on('click', function(){%s};", var, onclick);
        }
        fmt.format("%s.addItem(%s);", FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent), var);
        return fmt.toString();
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        if (uc.isUpdateValue(component)) {
            String value = this.getCurrentValue(context, component);
            out.writeScriptBlock(String.format("%s.setChecked(%b,true);", jsvar, Boolean.valueOf(value)));
        }
        Set attrs = uc.getAttributeCandidates(component);
        attrs.remove("value");
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attrs, this.getLiteAttributes());
    }

    public void setDisabled(UICheckMenuItem item, boolean disabled) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)item, new String[]{"disabled"});
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

