/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeListener;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.component.form.impl.UICombo;
import org.operamasks.faces.component.form.impl.UIField;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.ajax.AbstractFieldRenderer;
import org.operamasks.faces.render.widget.helper.SelectItemsRenderHelper;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxComboRenderer
extends AbstractFieldRenderer {
    protected static final String STORE_VAR_SUFFIX = "_store";
    protected static final String VALUE_VAR_SUFFIX = "_value";

    @Override
    protected String getHtmlMarkup() {
        return "input";
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!CompRendererUtils.needsDecode(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(String.valueOf(clientId) + VALUE_VAR_SUFFIX);
        this.setSubmittedValue(component, newValue);
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource.getResourceInstance((ResourceManager)rm).addInitScript(AjaxComboRenderer.getActionURLVarDefinition((FacesContext)context));
    }

    @Override
    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.form.ComboBox", "Ext.form", "Ext.data.Store", "Ext.View", "OM.ExtExtra"};
    }

    @Override
    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String jsvar_store = String.valueOf(jsvar) + STORE_VAR_SUFFIX;
        config.remove("value");
        config.set("store", Aliases.getVar((String)jsvar_store), true);
        config.set("displayField", "text");
        config.set("valueField", "value");
        config.set("mode", "local");
        config.set("triggerAction", "all");
        config.set("hiddenName", String.valueOf(component.getClientId(context)) + VALUE_VAR_SUFFIX);
    }

    protected boolean isSelected(FacesContext context, UIComponent component, Object itemValue, String itemStr) {
        String currentValue = this.getCurrentValue(context, component);
        if (currentValue == null) {
            return itemValue == null;
        }
        Class<?> itemType = currentValue.getClass();
        itemValue = TypeCoercion.coerce((Object)itemValue, itemType);
        return currentValue.equals(itemValue);
    }

    @Override
    protected String innerResourceBegin(FacesContext context, UIComponent component, ResourceManager rm) {
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        StringBuffer buf = new StringBuffer();
        Aliases alias = Aliases.getInstance((FacesContext)context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        this.encodeDataStore(buf, resource, context, component);
        buf.append(super.innerResourceBegin(context, component, rm));
        this.encodeValueChangeListenerFn(buf, context, component, rm);
        String selectedValue = this.encodeOptions(buf, context, component, SelectItemsRenderHelper.getSelectItems(component), jsvar, true);
        this.encodeSelectValue(buf, context, component, selectedValue);
        UICombo combo = (UICombo)component;
        if (Boolean.TRUE.equals(combo.getShowTooltip())) {
            buf.append(String.format("%s(%s);", alias.alias("OM.SC.addComboTip"), alias.var(jsvar)));
        }
        return buf.toString();
    }

    private void encodeValueChangeListenerFn(StringBuffer buf, FacesContext context, UIComponent component, ResourceManager rm) {
        buf.append(this.getValueChangeListenerFn(context, component));
    }

    protected String getValueChangeListenerFn(FacesContext context, UIComponent component) {
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String clientId = component.getClientId(context);
        ValueChangeListener[] listeners = ((UIInput)component).getValueChangeListeners();
        String valueChangeListenerFn = null;
        if (listeners != null && listeners.length > 0) {
            StringBuffer tmpbuf = new StringBuffer();
            tmpbuf.append(String.format("function(_src, record, index){%s('%s',record.data['value']);", Aliases.getAlias((String)"OM.SC.addRequestParameter"), clientId));
            UIForm form = this.getParentForm(component);
            tmpbuf.append(String.format("OM.ajax.action(%s,%s,null,%b);", form == null ? "null" : "document.forms['" + form.getClientId(context) + "']", AjaxComboRenderer.getActionURLVar(), false));
            tmpbuf.append("}");
            valueChangeListenerFn = tmpbuf.toString();
        }
        if (valueChangeListenerFn != null && valueChangeListenerFn.length() > 0) {
            return String.format("%s.on('select',%s);", Aliases.getVar((String)jsvar), valueChangeListenerFn);
        }
        return "";
    }

    private void encodeDataStore(StringBuffer buf, ComponentResource resource, FacesContext context, UIComponent component) {
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String jsvar_store = String.valueOf(jsvar) + STORE_VAR_SUFFIX;
        buf.append(RendererUtils.getJsvarAliasDef((String)jsvar_store, (Aliases)Aliases.getInstance((FacesContext)context)));
        buf.append(jsvar_store);
        buf.append("=").append(Aliases.getAlias((String)"OM.SC.comboStore")).append("();");
    }

    protected String encodeOptions(StringBuffer buf, FacesContext context, UIComponent component, List<SelectItem> items, String jsvar, boolean encodeStore) {
        StringBuffer bufContent = new StringBuffer();
        int[] index = new int[1];
        String selectedValue = null;
        bufContent.append(Aliases.getAlias((String)"OM.SC.buildComboRecord")).append("([");
        for (SelectItem item : items) {
            if (item instanceof SelectItemGroup) {
                SelectItem[] groupItems = ((SelectItemGroup)item).getSelectItems();
                int i = 0;
                while (i < groupItems.length) {
                    String v = this.encodeOption(bufContent, context, component, groupItems[i], index, encodeStore);
                    if (v != null) {
                        selectedValue = v;
                    }
                    ++i;
                }
                continue;
            }
            String v = this.encodeOption(bufContent, context, component, item, index, encodeStore);
            if (v == null) continue;
            selectedValue = v;
        }
        if (bufContent.charAt(bufContent.length() - 1) == ',') {
            bufContent.deleteCharAt(bufContent.length() - 1);
        }
        bufContent.append("])");
        String jsvar_store = String.valueOf(jsvar) + STORE_VAR_SUFFIX;
        if (items.size() > 0) {
            buf.append(Aliases.getVar((String)jsvar_store)).append(".add(").append(bufContent).append(");");
        }
        return selectedValue;
    }

    protected String encodeOption(StringBuffer buf, FacesContext context, UIComponent component, SelectItem item, int[] index, boolean encodeStore) {
        String selectedValue = null;
        String itemValueStr = this.getFormattedValue(context, component, item.getValue());
        if (this.isSelected(context, component, item.getValue(), itemValueStr)) {
            selectedValue = itemValueStr;
        }
        if (encodeStore) {
            buf.append("[").append(HtmlEncoder.enquote((String)item.getLabel(), (Character)Character.valueOf('\"'))).append(",").append(HtmlEncoder.enquote((String)itemValueStr, (Character)Character.valueOf('\"'))).append("],");
        }
        return selectedValue;
    }

    protected void encodeSelectValue(StringBuffer buf, FacesContext context, UIComponent component, String selectedValue) {
        String jsvar = Aliases.getVar((String)FacesUtils.getJsvar((FacesContext)context, (UIComponent)component));
        String script = "%s.setValue('%s');\n";
        if (selectedValue != null) {
            buf.append(String.format(script, jsvar, selectedValue.replace("'", "\\'")));
        } else {
            ValueExpression valueEl = component.getValueExpression("value");
            Object value = null;
            if (valueEl != null) {
                value = valueEl.getValue(context.getELContext());
                if (value != null) {
                    buf.append(String.format(script, jsvar, value.toString().replace("'", "\\'")));
                } else {
                    buf.append(jsvar).append(".reset();\n");
                }
            }
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        List<SelectItem> items = SelectItemsRenderHelper.getSelectItems(component);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String jsvar_store = String.valueOf(jsvar) + STORE_VAR_SUFFIX;
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        boolean isEncodeStore = uc.isUpdateDataModel(component);
        StringBuffer buf = new StringBuffer();
        if (isEncodeStore) {
            buf.append(jsvar_store).append(".removeAll();\n");
        }
        String selectedValue = this.encodeOptions(buf, context, component, items, jsvar, isEncodeStore);
        this.encodeSelectValue(buf, context, component, selectedValue);
        if (buf.length() > 0) {
            out.writeActionScript(buf.toString());
        }
        Set attrs = uc.getAttributeCandidates(component);
        attrs.remove("value");
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attrs, this.getLiteAttributes());
    }

    @Override
    protected void encodeField(StringBuilder buf, FacesContext context, UIComponent component, ResourceManager rm) {
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        Formatter fmt = new Formatter(buf);
        String clientId = component.getClientId(context);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("combo");
        fmt.format("(", new Object[0]);
        fmt.format("%s('%s'),", alias.alias("OM.SC.clearCmp"), clientId);
        buf.append(RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias));
        fmt.format("%s=new %s(%s{", jsvar, alias.alias(this.getExtClass(component)), c.start());
        ExtConfig config = new ExtConfig(component);
        UIField field = (UIField)component;
        config.set("displayField", "text");
        config.set("valueField", "value");
        config.set("mode", "local");
        config.set("triggerAction", "all");
        config.set("hiddenName", String.valueOf(component.getClientId(context)) + VALUE_VAR_SUFFIX);
        UICombo combo = (UICombo)component;
        if (Boolean.TRUE.equals(combo.getShowItemTooltip())) {
            config.set("tpl", "<tpl for=\".\"><div ext:qtip=\"{text}\" class=\"x-combo-list-item\">{text}</div></tpl>");
        }
        if (combo.getRegex() != null) {
            config.remove("regex");
            config.set("regex", combo.getRegex(), true);
        }
        if (combo.getMaskRe() != null) {
            config.remove("maskRe");
            config.set("maskRe", combo.getMaskRe(), true);
        }
        if ("true".equals(combo.getShadow())) {
            config.set("shadow", true);
        } else if ("false".equals(combo.getShadow())) {
            config.set("shadow", false);
        }
        String tooltip = field.getTooltip();
        if (tooltip != null && tooltip.length() > 0) {
            config.set("listeners", String.format("{render:function(c){Ext.QuickTips.register({target:c.getEl(),text:'%s'});}}", tooltip), true);
        }
        this.addClientValidateSets(context, config, field, alias);
        String configStr = config.toScript(c);
        fmt.format(configStr, new Object[0]);
        if (Boolean.TRUE.equals(field.getAttributes().get("org.operamasks.faces.fieldInEditDataGrid"))) {
            fmt.format(",%s:new %s({fields:['text','value'],data:[", c.prop("store"), alias.alias("Ext.data.SimpleStore"));
            List<SelectItem> items = SelectItemsRenderHelper.getSelectItems(component);
            int cnt = 0;
            for (SelectItem item : items) {
                if (item instanceof SelectItemGroup) {
                    SelectItem[] groupItems = ((SelectItemGroup)item).getSelectItems();
                    int i = 0;
                    while (i < groupItems.length) {
                        String itemValueStr = this.getFormattedValue(context, component, item.getValue());
                        if (cnt > 0) {
                            fmt.format(",", new Object[0]);
                        }
                        fmt.format("[%s,%s]", HtmlEncoder.enquote((String)item.getLabel(), (Character)Character.valueOf('\"')), HtmlEncoder.enquote((String)itemValueStr, (Character)Character.valueOf('\"')));
                        ++cnt;
                        ++i;
                    }
                    continue;
                }
                String itemValueStr = this.getFormattedValue(context, component, item.getValue());
                if (cnt > 0) {
                    fmt.format(",", new Object[0]);
                }
                fmt.format("[%s,%s]", HtmlEncoder.enquote((String)item.getLabel(), (Character)Character.valueOf('\"')), HtmlEncoder.enquote((String)itemValueStr, (Character)Character.valueOf('\"')));
                ++cnt;
            }
            fmt.format("]})", new Object[0]);
        } else {
            String jsvar_store = String.valueOf(jsvar) + STORE_VAR_SUFFIX;
            fmt.format(",%s:%s", c.prop("store"), alias.var(jsvar_store));
        }
        fmt.format("}%s))", c.end());
    }

    @Override
    public ExtConfig getExtraConfig(UIField field) {
        ExtConfig config = new ExtConfig();
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)field);
        StringBuilder buf = new StringBuilder();
        buf.append(Aliases.getAlias((String)"OM.SC.comboExtraConfig")).append("('").append(jsvar).append("')");
        config.set("renderer", buf.toString());
        return config;
    }

    protected UIForm getParentForm(UIComponent component) {
        while (component != null) {
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            component = component.getParent();
        }
        return null;
    }

    @Override
    protected String getExtClass(UIComponent component) {
        return "Ext.form.ComboBox";
    }
}

