/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.operamasks.faces.application.StateAware;
import org.operamasks.faces.component.grid.CellEditor;
import org.operamasks.faces.component.grid.CellEditorFactory;
import org.operamasks.faces.component.grid.CellSelectionModel;
import org.operamasks.faces.component.grid.CheckboxSelectionModel;
import org.operamasks.faces.component.grid.GridColumn;
import org.operamasks.faces.component.grid.GridColumnModel;
import org.operamasks.faces.component.grid.GridHeader;
import org.operamasks.faces.component.grid.GridHeaderCell;
import org.operamasks.faces.component.grid.GridHeaderModel;
import org.operamasks.faces.component.grid.GridSelectionModel;
import org.operamasks.faces.component.grid.MultiCellSelectionModel;
import org.operamasks.faces.component.grid.RowSelectionModel;
import org.operamasks.faces.component.grid.UIOutputColumn;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.faces.component.grid.provider.GridViewProvider;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.component.widget.UIPager;
import org.operamasks.faces.component.widget.UIPagingToolbar;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxIconClsEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.event.AjaxEventDesc;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ContainerRenderUtils;
import org.operamasks.faces.render.html.FormRenderer;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.ajax.AjaxPagingToolbarRenderer;
import org.operamasks.faces.render.widget.helper.DataGridRenderHelper;
import org.operamasks.faces.render.widget.helper.PagingLinkHelper;
import org.operamasks.faces.render.widget.helper.ToolBarHelper;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.ComponentUtils;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.faces.util.StateUtils;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxDataGridRenderer
extends AjaxRendererBase {
    public static final String REQUEST_DATA_PARAM = "_ajaxDataProxy_datagrid";
    public static final String DELEGATE_PARAM = "_ajaxDataProxy_datagrid_POST";
    private static final int DEFAULT_ROWS = 10;
    protected static final String SELECTED_ROWS_PARAM = "_selectedRows";
    protected static final String SELECTED_CLIENTROWS_PARAM = "_selectedClientRows";
    protected static final String SELECTED_ROW_IDS_PARAM = "_selectedRowIds";
    protected static final String SELECTED_CELLS_PARAM = "_selectedCells";
    protected static final String SELECTED_CLIENTCELLS_PARAM = "_selectedClientCells";
    private static final Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");
    private static final String GENERATED_PAGINGTOOLBAR_JSVAR = "pg_jsvar";
    private static final String TOOLBAR_CHANGEMODE_KEY = "tb_changemode";
    public static final String SHADOW_TOOLBAR_KEY = "shadow_toolbar";
    protected static final Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(){
        {
            this.put("iconCls", AjaxIconClsEncoder.getInstance());
        }
    });

    public void decode(FacesContext context, UIComponent component) {
        String s;
        int n;
        int n2;
        String[] stringArray;
        int i;
        String[] selectionsValue;
        int[] selections2;
        UIDataGrid grid = null;
        if (component != null && component instanceof UIDataGrid) {
            grid = (UIDataGrid)component;
        }
        if (context == null || grid == null) {
            throw new NullPointerException();
        }
        String clientId = grid.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String gridPostId = (String)paramMap.get(DELEGATE_PARAM);
        if (grid.getId().equals(gridPostId)) {
            return;
        }
        String gridId = (String)paramMap.get(REQUEST_DATA_PARAM);
        if (gridId == null) {
            grid.updateModel();
            StateUtils.saveState((FacesContext)context, (String)grid.getId(), (StateAware)grid);
        }
        String selectionsParam = (String)paramMap.get(String.valueOf(clientId) + SELECTED_ROWS_PARAM);
        String clientSelectionsParam = (String)paramMap.get(String.valueOf(clientId) + SELECTED_CLIENTROWS_PARAM);
        String selectedRowIdsParam = (String)paramMap.get(String.valueOf(clientId) + SELECTED_ROW_IDS_PARAM);
        String selectedCellsParam = (String)paramMap.get(String.valueOf(clientId) + SELECTED_CELLS_PARAM);
        String selectedClientCellsParam = (String)paramMap.get(String.valueOf(clientId) + SELECTED_CLIENTCELLS_PARAM);
        if (selectionsParam != null) {
            try {
                selections2 = null;
                if (selectionsParam.length() > 0) {
                    selectionsValue = selectionsParam.split(",");
                    selections2 = new int[selectionsValue.length];
                    i = 0;
                    stringArray = selectionsValue;
                    n2 = selectionsValue.length;
                    n = 0;
                    while (n < n2) {
                        s = stringArray[n];
                        selections2[i++] = Integer.parseInt(s);
                        ++n;
                    }
                } else {
                    selections2 = new int[]{};
                }
                grid.setSelections(selections2);
            }
            catch (NumberFormatException selections2) {
                // empty catch block
            }
        }
        if (clientSelectionsParam != null) {
            try {
                selections2 = null;
                if (clientSelectionsParam.length() > 0) {
                    selectionsValue = clientSelectionsParam.split(",");
                    selections2 = new int[selectionsValue.length];
                    i = 0;
                    stringArray = selectionsValue;
                    n2 = selectionsValue.length;
                    n = 0;
                    while (n < n2) {
                        s = stringArray[n];
                        selections2[i++] = Integer.parseInt(s);
                        ++n;
                    }
                } else {
                    selections2 = new int[]{};
                }
                grid.setClientSelections(selections2);
            }
            catch (NumberFormatException selections3) {
                // empty catch block
            }
        }
        if (selectedRowIdsParam != null) {
            try {
                String[] selectedRowIds = null;
                selectedRowIds = selectedRowIdsParam.length() > 0 ? selectedRowIdsParam.split(",") : new String[]{};
                grid.setSelectedIds(selectedRowIds);
            }
            catch (Exception selectedRowIds) {
                // empty catch block
            }
        }
        if (selectedCellsParam != null) {
            try {
                Object selectedCells = null;
                if (selectedCellsParam.length() > 0) {
                    String[] selectedCellsValue = selectedCellsParam.split(",");
                    selectedCells = new int[selectedCellsValue.length / 2][2];
                    i = 0;
                    int j = 0;
                    while (i < selectedCellsValue.length) {
                        selectedCells[j][0] = Integer.parseInt(selectedCellsValue[i]);
                        selectedCells[j][1] = Integer.parseInt(selectedCellsValue[i + 1]);
                        ++j;
                        i += 2;
                    }
                    this.sortSelectedCells((int[][])selectedCells);
                } else {
                    selectedCells = new int[0][];
                }
                grid.setSelectedCells((int[][])selectedCells);
            }
            catch (Exception selectedCells) {
                // empty catch block
            }
        }
        if (selectedClientCellsParam != null) {
            try {
                Object clientSelectedCells = null;
                if (selectedClientCellsParam.length() > 0) {
                    String[] clientSelectedCellsValue = selectedClientCellsParam.split(",");
                    clientSelectedCells = new int[clientSelectedCellsValue.length / 2][2];
                    i = 0;
                    int j = 0;
                    while (i < clientSelectedCellsValue.length) {
                        clientSelectedCells[j][0] = Integer.parseInt(clientSelectedCellsValue[i]);
                        clientSelectedCells[j][1] = Integer.parseInt(clientSelectedCellsValue[i + 1]);
                        ++j;
                        i += 2;
                    }
                    this.sortSelectedCells((int[][])clientSelectedCells);
                } else {
                    clientSelectedCells = new int[0][];
                }
                grid.setClientSelectedCells((int[][])clientSelectedCells);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        UIDataGrid grid = (UIDataGrid)component;
        out.startElement("div", component);
        out.writeAttribute("id", (Object)component.getClientId(context), null);
        String style = grid.getStyle();
        if (style != null && !style.trim().endsWith(";")) {
            style = String.valueOf(style) + ";";
        }
        String styleClass = grid.getStyleClass();
        String defaultStyle = "";
        style = style != null && style.length() > 0 ? String.valueOf(defaultStyle) + style : defaultStyle;
        if (grid.getHeight() != null) {
            style = String.format("%sheight: %spx;", style, grid.getHeight());
        }
        if (grid.getWidth() != null) {
            style = String.format("%swidth:%spx;", style, grid.getWidth());
        }
        if (Boolean.TRUE.equals(grid.getAutoHeight())) {
            style = String.format("%sheight: auto;", style);
        }
        out.writeAttribute("style", (Object)style, "style");
        if (styleClass != null && styleClass.length() > 0) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        out.write("\n");
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.endElement("div");
        out.write("\n");
        StateUtils.removeState((FacesContext)context, (String)component.getId());
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        UIDataGrid grid = null;
        if (component != null && component instanceof UIDataGrid) {
            grid = (UIDataGrid)component;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        assert (grid != null);
        for (UIComponent c : grid.getChildren()) {
            if (!(c instanceof ToolBar)) continue;
            c.encodeAll(context);
        }
        out.setViewStateChanged();
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        if (uc.isUpdateValue(component) && this.isRowSelectionModel(grid)) {
            DataGridRenderHelper.addOperationScript(this.constructSelectScript(context, grid, false));
        }
        Set attr = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attr, this.getLiteAttributes());
    }

    private String constructSelectScript(FacesContext context, UIDataGrid component, boolean isClient) {
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String clientId = component.getClientId(context);
        if (!isClient) {
            String selectedRows = "";
            int[] selections = component.getSelections();
            if (selections != null) {
                int i = 0;
                while (i < selections.length) {
                    selectedRows = String.valueOf(selectedRows) + (i > 0 ? ", " : "") + selections[i];
                    ++i;
                }
            }
            fmt.format("var serverRows = [%s];\n", selectedRows);
            fmt.format("var %s_selModel = %s.selModel;\n", jsvar, jsvar);
            fmt.format("%s_selModel.grid = %s;\n", jsvar, jsvar);
            fmt.format("%s_selModel.suspendEvents();\n", jsvar);
            fmt.format("var clientRows = [];\n", new Object[0]);
            fmt.format("for(var i=0; i<serverRows.length; i++){\n", new Object[0]);
            fmt.format("clientRows.push(%s.getStore().find('_serverRowIndex',serverRows[i]));\n", jsvar);
            fmt.format("}\n", new Object[0]);
            fmt.format("if(%s_selModel.selectRows){\n", jsvar);
            fmt.format("%s_selModel.selectRows(clientRows,%b);\n", jsvar, false);
            fmt.format("} else if(%s_selModel.select){\n", jsvar);
            fmt.format("for(var i=0; i<clientRows.length; i++){\n", new Object[0]);
            fmt.format("if(clientRows[i] > 0) ", new Object[0]);
            fmt.format("%s_selModel.select(clientRows[i], 0);\n", jsvar);
            fmt.format("}\n", new Object[0]);
            fmt.format("}\n", new Object[0]);
            fmt.format("%s_selModel.resumeEvents();\n", jsvar);
            fmt.format("%s.selectedRows = serverRows;", jsvar);
            fmt.format("var items = %s_selModel.getSelections();\n", jsvar);
            fmt.format("var rowIds = [];\n", new Object[0]);
            fmt.format("for (var i = 0; i < items.length; i++ ) {\n", new Object[0]);
            fmt.format("rowIds.push(items[i].id);\n", new Object[0]);
            fmt.format("}\n", new Object[0]);
            fmt.format("OM.ajax.removeRequestParameter('%s%s');\n", clientId, SELECTED_ROWS_PARAM);
            fmt.format("OM.ajax.addRequestParameter('%s%s', serverRows);\n", clientId, SELECTED_ROWS_PARAM);
            fmt.format("OM.ajax.removeRequestParameter('%s%s');\n", clientId, SELECTED_CLIENTROWS_PARAM);
            fmt.format("OM.ajax.addRequestParameter('%s%s', clientRows);\n", clientId, SELECTED_CLIENTROWS_PARAM);
            fmt.format("OM.ajax.removeRequestParameter('%s%s');\n", clientId, SELECTED_ROW_IDS_PARAM);
            fmt.format("OM.ajax.addRequestParameter('%s%s', rowIds);\n", clientId, SELECTED_ROW_IDS_PARAM);
        } else {
            fmt.format("if(%s.selectedRows && %s.selectedRows != null){\n", jsvar, jsvar);
            fmt.format("var serverRows = %s.selectedRows;\n", jsvar);
            fmt.format("var %s_selModel = %s.selModel;\n", jsvar, jsvar);
            fmt.format("%s_selModel.grid = %s;\n", jsvar, jsvar);
            fmt.format("var clientRows = [];\n", new Object[0]);
            fmt.format("for(var i=0; i<serverRows.length; i++){\n", new Object[0]);
            fmt.format("clientRows.push(%s.getStore().find('_serverRowIndex',serverRows[i]));\n", jsvar);
            fmt.format("}\n", new Object[0]);
            fmt.format("if(%s_selModel.selectRows){\n", jsvar);
            fmt.format("%s_selModel.selectRows(clientRows,%b);\n", jsvar, false);
            fmt.format("} else if(%s_selModel.select){\n", jsvar);
            fmt.format("for(var i=0; i<clientRows.length; i++){\n", new Object[0]);
            fmt.format("if(clientRows[i] > 0) ", new Object[0]);
            fmt.format("%s_selModel.select(clientRows[i], 0);\n", jsvar);
            fmt.format("}}}\n", new Object[0]);
            fmt.format("OM.ajax.removeRequestParameter('%s%s');\n", clientId, SELECTED_ROWS_PARAM);
            fmt.format("OM.ajax.addRequestParameter('%s%s', serverRows);\n", clientId, SELECTED_ROWS_PARAM);
            fmt.format("OM.ajax.removeRequestParameter('%s%s');\n", clientId, SELECTED_CLIENTROWS_PARAM);
            fmt.format("OM.ajax.addRequestParameter('%s%s', clientRows);\n", clientId, SELECTED_CLIENTROWS_PARAM);
        }
        return buf.toString();
    }

    protected boolean isRowSelectionModel(UIDataGrid grid) {
        return grid.getSelectionModel() instanceof RowSelectionModel;
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager manager, UIComponent component) {
        UIDataGrid grid = (UIDataGrid)component;
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)manager);
        DataGridRenderHelper.mergeColumn(grid);
        DataGridRenderHelper.mergeHeader(grid);
        this.validateStructure(grid);
        this.validateDataGrid(context, grid);
        this.processColumnEditor(grid);
        String jsvar = resource.allocVariable((UIComponent)grid);
        String dsvar = String.valueOf(jsvar) + "_ds";
        AjaxDataGridRenderer.adjustPagers(context, grid);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        buf.append(AjaxDataGridRenderer.getActionURLVarDefinition((FacesContext)context));
        this.encodeDataStore(buf, context, grid, jsvar, dsvar);
        this.encodeToolBarAsItem(context, grid, buf, jsvar);
        List<UIPagingToolbar> pagingToolBars = ToolBarHelper.findExternalPagingToolBar(component);
        for (UIPagingToolbar tb : pagingToolBars) {
            Renderer toolbarRenderer;
            this.encodeToolBarItem(context, fmt, (UIComponent)tb);
            tb.getAttributes().put("dsvar", dsvar);
            if (!tb.isRendered() || tb.getTarget() != null && tb.getTarget().length() != 0 || !((toolbarRenderer = FacesUtils.getRenderer((FacesContext)context, (UIComponent)tb)) instanceof AjaxPagingToolbarRenderer)) continue;
            buf.append(((AjaxPagingToolbarRenderer)toolbarRenderer).getInitScript(context, (UIComponent)tb, manager, dsvar, false));
        }
        resource.addInitScript(buf.toString());
    }

    private void processColumnEditor(UIDataGrid grid) {
        for (UIComponent child : grid.getChildren()) {
            GridColumn modelColumn;
            if (!(child instanceof UIOutputColumn)) continue;
            UIOutputColumn column = (UIOutputColumn)child;
            ArrayList editors = new ArrayList();
            GridColumnModel colModel = grid.getColumnModel();
            if (colModel == null || (modelColumn = colModel.getColumn(column.getId())) == null) continue;
            for (UIComponent editor : column.getChildren()) {
                CellEditor cellEditor;
                if (editor == null || !(editor instanceof CellEditorFactory) || (cellEditor = ((CellEditorFactory)editor).getCellEditor()) == null || editors.contains(cellEditor)) continue;
                modelColumn.setCellEditor(cellEditor);
            }
        }
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        String[] resultJsPackages = new String[]{"Ext.grid.Grid", "Ext.data.FacesProxy", "Ext.ux.grid.GridSummary"};
        ArrayList<String> resultJsPackageList = new ArrayList<String>();
        String[] stringArray = resultJsPackages;
        int n = resultJsPackages.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgName = stringArray[n2];
            resultJsPackageList.add(pkgName);
            ++n2;
        }
        UIDataGrid grid = (UIDataGrid)component;
        GridSelectionModel selectionModel = grid.getSelectionModel();
        if (selectionModel == null) {
            selectionModel = new RowSelectionModel();
            grid.setSelectionModel(selectionModel);
        }
        if (selectionModel instanceof MultiCellSelectionModel) {
            resultJsPackageList.add("Ext.ux.MultiCellSelectionModel");
        }
        return resultJsPackageList.toArray(new String[0]);
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    private static void adjustPagers(FacesContext context, UIDataGrid grid) {
        ToolBarHelper.findToolBar((UIComponent)grid, UIPagingToolbar.class, false);
        List<UIPager> pagers = ComponentUtils.findAssociatedComponents(grid.getId(), (UIComponent)context.getViewRoot(), UIPager.class, "for", null);
        List<ToolBar> toolbars = ToolBarHelper.findInternalToolBar((UIComponent)grid, UIPagingToolbar.class, false, false);
        if (toolbars != null) {
            for (ToolBar t : toolbars) {
                UIPagingToolbar ptb = (UIPagingToolbar)t;
                if (ptb.getFor() != null) continue;
                pagers.add(ptb);
            }
        }
        Integer rows = grid.getRows();
        Boolean paged = grid.getPaged();
        if (Boolean.TRUE.equals(paged)) {
            if (rows == null || rows < 1) {
                rows = pagers.size() > 0 ? Integer.valueOf(pagers.get(0).getPageSize()) : Integer.valueOf(10);
                grid.setRows(rows);
            } else if (pagers.size() > 0) {
                pagers.get(0).setPageSize(rows);
            }
        }
        for (UIPager pager : pagers) {
            pager.setPageSize(rows);
        }
    }

    private void encodeToolBarAsItem(FacesContext context, UIDataGrid component, StringBuilder buf, String jsvar) {
        ToolBar toolbar2;
        Iterator<ToolBar> toolbars = ToolBarHelper.getToolBarIterator((UIComponent)component, ToolBar.class, false);
        List<UIPagingToolbar> externalToolBars = ToolBarHelper.findExternalPagingToolBar((UIComponent)component);
        List<UIPager> externalPagingLinks = PagingLinkHelper.findExternalPagingLink((UIComponent)component);
        String tbPosition = component.getToolBarPosition();
        Formatter fmt = new Formatter(buf);
        boolean paged = component.getPaged() != null ? component.getPaged() : false;
        ToolBar toolbar1 = toolbars.hasNext() ? toolbars.next() : null;
        ToolBar toolBar = toolbar2 = toolbars.hasNext() ? toolbars.next() : null;
        if (toolbar1 != null) {
            boolean change = this.needChangeToPagingToolBar(toolbar1, toolbar2, externalToolBars, tbPosition, paged);
            UIComponent tb = (UIComponent)toolbar1;
            if (!change) {
                this.encodeToolBarItem(context, fmt, tb);
            } else {
                this.encodeToolBarItem(context, fmt, tb);
                component.getAttributes().put(GENERATED_PAGINGTOOLBAR_JSVAR, FacesUtils.getJsvar((FacesContext)context, (UIComponent)tb));
                component.getAttributes().put(TOOLBAR_CHANGEMODE_KEY, "replace");
            }
            if (toolbar2 != null) {
                this.encodeToolBarItem(context, fmt, (UIComponent)toolbar2);
            }
        } else if (paged && externalToolBars.size() < 1 && externalPagingLinks.size() < 1) {
            String pg_jsvar = String.valueOf(jsvar) + "_pg";
            component.getAttributes().put(GENERATED_PAGINGTOOLBAR_JSVAR, pg_jsvar);
            component.getAttributes().put(TOOLBAR_CHANGEMODE_KEY, "add");
        }
    }

    private void encodeToolBarItem(FacesContext context, Formatter fmt, UIComponent toolbar) {
        if (toolbar.isRendered()) {
            ContainerRenderUtils.encodeItemInitScript((FacesContext)context, (UIComponent)toolbar, (Formatter)fmt);
        } else {
            ContainerRenderUtils.ignoreItems((FacesContext)context, (UIComponent)toolbar);
        }
    }

    private boolean needChangeToPagingToolBar(ToolBar toolbar1, ToolBar toolbar2, List<UIPagingToolbar> externalToolBars, String position, boolean paged) {
        if (!paged) {
            return false;
        }
        if (externalToolBars.size() > 0) {
            return false;
        }
        if (toolbar1 instanceof UIPagingToolbar) {
            return false;
        }
        return toolbar2 == null || !(toolbar2 instanceof UIPagingToolbar);
    }

    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) {
        UIDataGrid grid = null;
        if (component != null && component instanceof UIDataGrid) {
            grid = (UIDataGrid)component;
        }
        if (context == null || grid == null) {
            throw new NullPointerException();
        }
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
        String cmvar = String.valueOf(jsvar) + "_cm";
        String dsvar = String.valueOf(jsvar) + "_ds";
        String smvar = String.valueOf(jsvar) + "_sm";
        this.registerAjaxEvents(grid, jsvar);
        StringBuilder buf = new StringBuilder();
        this.encodeSelectionModel(buf, context, grid, smvar);
        this.encodeColumnModel(buf, context, grid, cmvar, smvar);
        this.encodeColumnHeader(buf, context, grid, cmvar, smvar);
        Iterator<ToolBar> toolbars = ToolBarHelper.getToolBarIterator((UIComponent)grid, ToolBar.class, false);
        this.encodeGridDefinition(buf, context, grid, jsvar, dsvar, smvar, cmvar, toolbars);
        this.encodeGridEvents(buf, context, grid, jsvar, dsvar, smvar, cmvar);
        this.encodeGridOptions(buf, context, grid, jsvar, dsvar, smvar, cmvar);
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        fmt.format("%s.load({params:{start:%d,limit:%d}});", alias.var(dsvar), grid.getFirst(), grid.getRows());
        fmt.format("%s.render();", alias.var(jsvar));
        if (Boolean.TRUE.equals(grid.getRowResizable())) {
            resource.addJSPackageDependency("Ext.Resizable");
            this.encodeRowResizableScript(jsvar, fmt);
        }
        this.encodeInitSelection(context, grid, fmt);
        resource.addInitScript(buf.toString());
    }

    private void validateStructure(UIDataGrid grid) {
        int headersCount;
        GridHeaderModel headerModel = grid.getHeaderModel();
        GridColumnModel columnModel = grid.getColumnModel();
        int n = headersCount = headerModel != null ? headerModel.getHeadersCount() : 0;
        if (headersCount > 0) {
            int headerColCount = headerModel.getColumnCount(headersCount - 1);
            if (columnModel != null) {
                int colCntWithoutHidden = columnModel.getColumnCount();
                int colCntWithHidden = columnModel.getColumnCount(true);
                if (headerColCount != colCntWithoutHidden && headerColCount != colCntWithHidden) {
                    System.out.println("headersCount : " + headersCount);
                    System.out.println("headerColCount : " + headerColCount);
                    System.out.println("colCntWithoutHidden : " + colCntWithoutHidden);
                    System.out.println("colCntWithHidden : " + colCntWithHidden);
                    int i = 0;
                    while (i < colCntWithHidden) {
                        System.out.println("ColId : " + columnModel.getColumn(i).getId());
                        ++i;
                    }
                    throw new FacesException(Resources._T((String)"UI_MISMATCH_COLUMN_NUM", (Object[])new Object[]{grid.getId(), FacesUtils.getComponentDesc((UIComponent)grid), headerColCount, colCntWithHidden}));
                }
            }
        }
    }

    private void encodeInitSelection(FacesContext context, UIDataGrid grid, Formatter fmt) {
        GridSelectionModel selectionModel = grid.getSelectionModel();
        if (selectionModel instanceof RowSelectionModel) {
            int[] selections;
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
            ValueExpression ve = grid.getValueExpression("selections");
            if (ve != null && (selections = (int[])ve.getValue(context.getELContext())) != null && selections.length > 0) {
                grid.setSelections(selections);
                StringBuffer selectedRowsBuf = new StringBuffer();
                int i = 0;
                while (i < selections.length) {
                    selectedRowsBuf.append(String.valueOf(i > 0 ? ", " : "") + selections[i]);
                    ++i;
                }
                Aliases alias = Aliases.getInstance((FacesContext)context);
                fmt.format("%s.selectedRows=[%s];", alias.var(jsvar), selectedRowsBuf.toString());
                fmt.format("var %s=function(){", alias.var(String.valueOf(jsvar) + "_selectrowsafterloadhandler"));
                fmt.format(this.constructSelectScript(context, grid, true), new Object[0]);
                fmt.format("};", new Object[0]);
                fmt.format("%s.getStore().on('load',%s);", alias.var(jsvar), alias.var(String.valueOf(jsvar) + "_selectrowsafterloadhandler"));
            }
        }
    }

    protected void encodeGridOptions(StringBuilder buf, FacesContext context, UIDataGrid grid, String jsvar, String dsvar, String smvar, String cmvar) {
    }

    protected void registerAjaxEvents(UIDataGrid grid, String jsvar) {
        String smvar = String.valueOf(jsvar) + "_sm";
        grid.getAjaxEvents().clear();
        grid.getAjaxEvents().add(new AjaxEventDesc(smvar, "selectionchange", grid.getOnselectionchange()));
        grid.getAjaxEvents().add(new AjaxEventDesc(smvar, "rowselect", grid.getOnrowselect()));
        grid.getAjaxEvents().add(new AjaxEventDesc(smvar, "rowdeselect", grid.getOnrowdeselect()));
        grid.getAjaxEvents().add(new AjaxEventDesc(jsvar, "rowdblclick", grid.getOndblclick()));
        grid.getAjaxEvents().add(new AjaxEventDesc(smvar, "cellselect", grid.getOncellselect()));
    }

    private void encodeGridEvents(StringBuilder buf, FacesContext context, UIDataGrid grid, String jsvar, String dsvar, String smvar, String cmvar) {
        boolean hasEvent = false;
        for (AjaxEventDesc event : grid.getAjaxEvents()) {
            String eventScript = event.getEventCode();
            if (eventScript == null || eventScript.length() == 0) continue;
            this.encodeEvent(buf, event.getOwnerVar(), event.getEventName(), eventScript);
            hasEvent = true;
        }
        if (hasEvent && FacesUtils.getParentForm((UIComponent)grid) == null) {
            try {
                context.getApplication().getViewHandler().writeState(context);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "write state fails");
            }
        }
    }

    private void validateDataGrid(FacesContext context, UIDataGrid grid) {
        GridHeaderModel headerModel;
        Object value;
        GridViewProvider provider = grid.getViewProvider();
        if (grid.getColumnModel() == null) {
            value = grid.getValue();
            try {
                grid.setColumnModel(provider.getColumnModel(value));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("DataGrid must be associated with a ColumnModel!  For example you can put <w:outputColumn> in the <w:dataGrid>, or bind a ViewProvider to the DataGrid.");
            }
        }
        if (provider != null && (headerModel = provider.getHeaderModel(value = grid.getValue())) != null) {
            grid.setHeaderModel(headerModel);
        }
    }

    protected void encodeSelectionModel(StringBuilder buf, FacesContext context, UIDataGrid grid, String smvar) {
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        String _smvar = alias.var(smvar);
        GridSelectionModel selectionModel = grid.getSelectionModel();
        if (selectionModel == null) {
            selectionModel = new RowSelectionModel();
            grid.setSelectionModel(selectionModel);
        }
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
        fmt.format("var %s=new %s({%s});", _smvar, alias.alias("Ext.grid." + selectionModel.getClass().getSimpleName()), this.getSelectionModelConfig(grid).toScript());
        String clientId = grid.getClientId(context);
        if (selectionModel instanceof RowSelectionModel) {
            fmt.format("var %s=%s('%s',%s,'%s');", alias.var(String.valueOf(_smvar) + "_eventhandler"), "Ext.grid.createRowSelectionHandler", jsvar, _smvar, clientId);
            fmt.format("%s.on('selectionchange', %s);", _smvar, alias.var(String.valueOf(_smvar) + "_eventhandler"));
        } else if (selectionModel instanceof CellSelectionModel) {
            fmt.format("var %s=%s('%s','%s');", alias.var(String.valueOf(_smvar) + "_eventhandler"), "Ext.grid.createCellSelectionHandler", jsvar, clientId);
            fmt.format("%s.on('cellselect',%s);", _smvar, alias.var(String.valueOf(_smvar) + "_eventhandler"));
        }
    }

    protected ExtConfig getSelectionModelConfig(UIDataGrid grid) {
        ExtConfig config = new ExtConfig();
        if (grid.getSingleSelect() != null && grid.getSingleSelect().booleanValue()) {
            config.set("singleSelect", Boolean.TRUE);
        }
        return config;
    }

    private void encodeEvent(StringBuilder buf, String var, String eventName, String eventScript) {
        Formatter fmt = new Formatter(buf);
        fmt.format("%s.on('%s', function(){", Aliases.getVar((String)var), eventName);
        buf.append(eventScript);
        if (!eventScript.endsWith(";")) {
            buf.append(";");
        }
        fmt.format("});\n", new Object[0]);
    }

    protected String getExtClass() {
        return "Ext.grid.GridPanel";
    }

    protected void encodeGridDefinition(StringBuilder buf, FacesContext context, UIDataGrid grid, String jsvar, String dsvar, String smvar, String cmvar, Iterator<ToolBar> toolbars) {
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("grid");
        Formatter fmt = new Formatter(buf);
        fmt.format("%s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias(this.getExtClass()), c.start());
        fmt.format("%s:%s,", c.prop("store"), alias.var(dsvar));
        fmt.format("%s:%s,", c.prop("cm"), alias.var(cmvar));
        fmt.format("%s:%s,", c.prop("sm"), alias.var(smvar));
        fmt.format("%s:'%s',", c.prop("el"), grid.getClientId(context));
        fmt.format("%s:'fit',", c.prop("layout"));
        if (grid.getMerged() != null && grid.getMerged().booleanValue()) {
            grid.setEnableColumnMove(false);
            grid.setEnableColumnResize(false);
        }
        ExtConfig config = new ExtConfig((UIComponent)grid);
        this.processExtConfig(context, (UIComponent)grid, config);
        this.postProcessExtConfig(context, (UIComponent)grid, config);
        String script = config.toScript(c);
        if (script.length() > 0) {
            buf.append(script).append(",");
        }
        fmt.format("%s:[", c.prop("plugins"));
        GridColumn[] gridColumnArray = grid.getColumnModel().getColumns();
        int n = gridColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn gridColumn = gridColumnArray[n2];
            if ("check".equals(gridColumn.getType())) {
                buf.append("new ").append(alias.alias("Ext.ux.plugins.CheckColumn")).append("(),");
                break;
            }
            ++n2;
        }
        if (grid.getSummaryRowPosition() != null) {
            buf.append("new ").append(alias.alias("Ext.ux.grid.GridSummary")).append("(),");
        }
        buf.append("new ").append(alias.alias("Ext.ux.plugins.XGrid")).append("()");
        fmt.format("]", new Object[0]);
        Aliases.ConfigBuilder vcConfig = alias.configBuilder("grid");
        ExtConfig viewConfig = new ExtConfig();
        if (grid.getForceFit() != null && grid.getForceFit().booleanValue()) {
            viewConfig.set("forceFit", true, true);
        }
        if (grid.getMerged() != null && grid.getMerged().booleanValue()) {
            viewConfig.set("merged", true, true);
        }
        fmt.format(",%s:%s{%s}%s", c.prop("viewConfig"), vcConfig.start(), viewConfig.toScript(vcConfig), vcConfig.end());
        String toolbarScript = this.encodeToolBarExtConfig(context, grid, toolbars);
        if (toolbarScript.length() > 0) {
            fmt.format(",%s", toolbarScript);
        }
        fmt.format("}%s);", c.end());
    }

    protected void postProcessExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        CompRendererUtils.mergeUserExtConfig(component, config);
    }

    protected String encodeToolBarExtConfig(FacesContext context, UIDataGrid grid, Iterator<ToolBar> toolbars) {
        StringBuilder script = new StringBuilder();
        String tbPosition = grid.getToolBarPosition();
        String pg_jsvar = (String)grid.getAttributes().get(GENERATED_PAGINGTOOLBAR_JSVAR);
        String change_mode = (String)grid.getAttributes().get(TOOLBAR_CHANGEMODE_KEY);
        ToolBar toolbar1 = toolbars.hasNext() ? toolbars.next() : null;
        ToolBar toolbar2 = toolbars.hasNext() ? toolbars.next() : null;
        Application app = context.getApplication();
        String toolbar1Config = "";
        if (pg_jsvar != null) {
            UIPagingToolbar pager = (UIPagingToolbar)app.createComponent("org.operamasks.faces.component.widget.UIPagingToolbar");
            pager.setPageSize(grid.getRows());
            pager.setJsvar(pg_jsvar);
            if ("replace".equals(change_mode)) {
                for (Map.Entry entry : ((UIComponent)toolbar1).getAttributes().entrySet()) {
                    pager.getAttributes().put((String)entry.getKey(), entry.getValue());
                }
                pager.setRendered(((UIComponent)toolbar1).isRendered());
                pager.getAttributes().put(SHADOW_TOOLBAR_KEY, toolbar1);
            }
            if (pager.isRendered()) {
                toolbar1Config = pager.encodeAsItem((UIComponent)grid);
            }
            pager.getAttributes().remove(SHADOW_TOOLBAR_KEY);
        } else if (toolbar1 != null && ((UIComponent)toolbar1).isRendered()) {
            toolbar1Config = toolbar1.encodeAsItem((UIComponent)grid);
        }
        String toolbar2Config = "";
        if (toolbar2 != null && ((UIComponent)toolbar2).isRendered()) {
            toolbar2Config = toolbar2.encodeAsItem((UIComponent)grid);
        }
        if (toolbar1Config.length() > 0) {
            if ("bottom".equals(tbPosition)) {
                script.append("bbar:").append(toolbar1Config);
            } else {
                script.append("tbar:").append(toolbar1Config);
            }
            if (toolbar2Config.length() > 0) {
                script.append(",");
            }
        }
        if (toolbar2Config.length() > 0) {
            script.append("bbar:").append(toolbar2Config);
        }
        return script.toString();
    }

    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        UIDataGrid grid = (UIDataGrid)component;
        Object h = grid.getHeight();
        if (h != null) {
            try {
                h = Integer.parseInt((String)h);
            }
            catch (Exception exception) {
                // empty catch block
            }
            config.set("height", h);
        }
        config.set("bodyStyle", "height:100%");
    }

    protected void encodeColumnHeader(StringBuilder buf, FacesContext context, UIDataGrid grid, String cmvar, String smvar) {
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        int rows = grid.getHeaderModel().getHeaders().length;
        String firstColumn = null;
        boolean showRowNumber = true;
        showRowNumber = grid.getShowRowNumber() != null ? grid.getShowRowNumber().booleanValue() : grid.getColumnModel().isShowRowNumber();
        if (grid.getSelectionModel() instanceof CheckboxSelectionModel) {
            firstColumn = alias.var(smvar);
        } else if (showRowNumber) {
            firstColumn = alias.var(String.valueOf(smvar) + "_firstcolumn");
        }
        if (rows > 1 && firstColumn != null) {
            fmt.format("%s.rowspan=%d;", firstColumn, rows);
        }
        fmt.format("%s.headers=[", alias.var(cmvar));
        GridHeader[] headers = grid.getHeaderModel().getHeaders();
        int i = 0;
        while (i < headers.length) {
            GridHeaderCell[] cells;
            GridHeader header = headers[i];
            fmt.format("[", new Object[0]);
            if (i == 0 && firstColumn != null) {
                fmt.format("%s,", firstColumn);
            }
            GridHeaderCell[] gridHeaderCellArray = cells = header.getCells();
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                GridHeaderCell cell = gridHeaderCellArray[n2];
                fmt.format("%s,", cell.toScript());
                ++n2;
            }
            if (buf.charAt(buf.length() - 1) == ',') {
                buf.setLength(buf.length() - 1);
            }
            fmt.format("],", new Object[0]);
            ++i;
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        fmt.format("];", new Object[0]);
    }

    protected void encodeColumnModel(StringBuilder buf, FacesContext context, UIDataGrid grid, String cmvar, String smvar) {
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        String encodedCmvar = alias.var(cmvar);
        if (grid.getSelectionModel() instanceof CheckboxSelectionModel) {
            fmt.format("var %s=new %s([", encodedCmvar, "Ext.grid.ColumnModel");
            fmt.format("%s,", alias.var(smvar));
        } else {
            boolean showRowNumber = true;
            showRowNumber = grid.getShowRowNumber() != null ? grid.getShowRowNumber().booleanValue() : grid.getColumnModel().isShowRowNumber();
            if (showRowNumber) {
                String firstColumn = alias.var(String.valueOf(smvar) + "_firstcolumn");
                fmt.format("var %s=new %s();", firstColumn, "Ext.grid.RowNumberer");
                fmt.format("var %s=new %s([", encodedCmvar, "Ext.grid.ColumnModel");
                fmt.format("%s,", firstColumn);
            } else {
                fmt.format("var %s=new %s([", encodedCmvar, "Ext.grid.ColumnModel");
            }
        }
        GridColumn[] columns = grid.getColumnModel().getColumns();
        GridHeader firstHeader = null;
        if (grid.getHeaderModel().getHeadersCount() > 0) {
            firstHeader = grid.getHeaderModel().getHeader(0);
        }
        int i = 0;
        GridColumn[] gridColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn column = gridColumnArray[n2];
            String header = "''";
            if (firstHeader != null && firstHeader.getCellCount() > i) {
                GridHeaderCell headerCell = firstHeader.getCell(i);
                header = headerCell.getLabel();
                if (headerCell.isRequireEscape()) {
                    header = HtmlEncoder.encode((String)header);
                }
                header = HtmlEncoder.enquote((String)header);
            }
            ++i;
            fmt.format("%s,", column.toScript(header));
            ++n2;
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]);");
    }

    private boolean isParamAboutGridItself(String paramKey, String girdClientId) {
        String suffix;
        return paramKey.startsWith(String.valueOf(girdClientId) + "_") && (suffix = paramKey.replace(String.valueOf(girdClientId) + "_", "")).indexOf("_") == -1;
    }

    public static String getRebindActionURL(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(url);
    }

    protected void encodeDataStore(StringBuilder buf, FacesContext context, UIDataGrid grid, String jsvar, String dsvar) {
        String[] columnIds;
        UIForm form;
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        fmt.format("%s%s=new %s({", RendererUtils.getJsvarAliasDef((String)dsvar, (Aliases)alias), dsvar, alias.alias("Ext.data.Store"));
        Boolean honorViewState = grid.getHonorViewState();
        if (honorViewState != null && honorViewState.booleanValue()) {
            fmt.format("proxy: new %s({url:%s,extraParams:{", alias.alias("Ext.data.FacesProxy"), "'" + AjaxDataGridRenderer.getRebindActionURL(context) + "'");
        } else {
            fmt.format("proxy:new %s({url:%s,extraParams:{", alias.alias("Ext.data.FacesScriptProxy"), "'" + AjaxDataGridRenderer.getRebindActionURL(context) + "'");
        }
        if (FacesUtils.isAjaxHtmlResponse((FacesContext)context)) {
            try {
                context.getApplication().getViewHandler().writeState(context);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "write state fails");
            }
        }
        ExtConfig extraParams = new ExtConfig();
        extraParams.set(HtmlEncoder.enquote((String)DELEGATE_PARAM), grid.getId());
        extraParams.set(HtmlEncoder.enquote((String)"__view_delegate_request__"), "");
        if (!Boolean.FALSE.equals(grid.getKeepLastParams())) {
            Map params = context.getExternalContext().getRequestParameterMap();
            List<String> excludeParamKeys = null;
            String sourceWidgetClientId = "sourceWidgetClientId";
            String girdClientId = grid.getClientId(context);
            if (params.containsKey(sourceWidgetClientId)) {
                String actionSourceClientId = (String)params.get(sourceWidgetClientId);
                excludeParamKeys = Arrays.asList("javax.faces.ViewState", "javax.faces.ViewId", sourceWidgetClientId, actionSourceClientId);
            } else {
                excludeParamKeys = Arrays.asList("javax.faces.ViewState", "javax.faces.ViewId");
            }
            assert (excludeParamKeys != null);
            for (Map.Entry entry : params.entrySet()) {
                if (excludeParamKeys.contains(entry.getKey()) || this.isParamAboutGridItself((String)entry.getKey(), girdClientId)) continue;
                extraParams.set(HtmlEncoder.enquote((String)((String)entry.getKey())), entry.getValue());
            }
        }
        if ((form = FacesUtils.getParentForm((UIComponent)grid)) != null) {
            extraParams.set(HtmlEncoder.enquote((String)FormRenderer.getPostbackFieldName((FacesContext)context, (UIComponent)form)), "");
        }
        buf.append(extraParams.toScript());
        buf.append("}}),");
        if (grid.getRemoteSort() != null && grid.getRemoteSort().booleanValue()) {
            buf.append("remoteSort:true,");
        }
        alias.registerConfig("gridreader");
        Aliases.ConfigBuilder config = alias.configBuilder("grid");
        fmt.format("reader:new %s(%s{%s:'id123',%s:'%s',%s:'%s'", alias.alias("Ext.data.FacesReader"), config.start(), config.prop("id"), config.prop("root"), "records", config.prop("totalProperty"), "totalcount");
        if (grid.getIdColumn() != null && grid.getIdColumn().length() > 0) {
            fmt.format(",id:%s", HtmlEncoder.enquote((String)grid.getIdColumn(), (Character)Character.valueOf('\'')));
        }
        buf.append("}").append(config.end()).append(",[");
        String[] stringArray = columnIds = grid.getColumnModel().getColumnIds();
        int n = columnIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            fmt.format("'%s',", id);
            ++n2;
        }
        fmt.format("'%s'", "_serverRowIndex");
        buf.append("])});");
    }

    public void reload(UIDataGrid grid) {
        FacesContext context = FacesContext.getCurrentInstance();
        StateUtils.saveState((FacesContext)context, (String)grid.getId(), (StateAware)grid);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
        String reloadScript = String.format("%1$s.getStore().load({params:{start: %1$s.getStore().lastOptions.params.start, limit: %1$s.getStore().lastOptions.params.limit}});\n", jsvar);
        if (this.isRowSelectionModel(grid)) {
            reloadScript = this.appendSelectScript(reloadScript, context, grid);
        }
        DataGridRenderHelper.addOperationScript(reloadScript);
    }

    private String appendSelectScript(String reloadScript, FacesContext context, UIDataGrid grid) {
        StringBuilder buf = new StringBuilder(reloadScript);
        Formatter fmt = new Formatter(buf);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
        fmt.format("var %s_selectrowsafterloadhandler = function(){\n", jsvar);
        fmt.format(this.constructSelectScript(context, grid, true), new Object[0]);
        fmt.format("};\n", new Object[0]);
        fmt.format("%s.getStore().on('load', %s_selectrowsafterloadhandler);\n", jsvar, jsvar);
        return fmt.toString();
    }

    public void rebind(UIDataGrid grid) {
        FacesContext context = FacesContext.getCurrentInstance();
        grid.updateModel();
        StateUtils.saveState((FacesContext)context, (String)grid.getId(), (StateAware)grid);
        grid.getAttributes().put("HEADER_MODEL_SET_BY_FRAMEWORK", false);
        grid.getAttributes().put("COLUMN_MODEL_SET_BY_FRAMEWORK", false);
        DataGridRenderHelper.mergeHeader(grid);
        DataGridRenderHelper.mergeColumn(grid);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
        StringBuilder buf = new StringBuilder();
        String dsvar = String.valueOf(jsvar) + "_newds";
        String smvar = String.valueOf(jsvar) + "_newsm";
        String cmvar = String.valueOf(jsvar) + "_newcm";
        AjaxDataGridRenderer.adjustPagers(context, grid);
        this.encodeDataStore(buf, context, grid, jsvar, dsvar);
        this.encodeSelectionModel(buf, context, grid, smvar);
        this.encodeColumnModel(buf, context, grid, cmvar, smvar);
        this.encodeColumnHeader(buf, context, grid, cmvar, smvar);
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        smvar = alias.var(smvar);
        cmvar = alias.var(cmvar);
        fmt.format("%s.selModel = %s;\n", jsvar, smvar);
        fmt.format("%s.reconfigure(%s, %s);\n", jsvar, dsvar, cmvar);
        List<UIPager> pagers = ComponentUtils.findAssociatedComponents(grid.getId(), (UIComponent)context.getViewRoot(), UIPager.class, "for", null);
        for (UIPager pager : pagers) {
            String pagerJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)pager);
            fmt.format("if(%s){\n", pagerJsvar);
            fmt.format("%s.pageSize = %d;\n", pagerJsvar, grid.getRows());
            fmt.format("%s.bind(%s);\n", pagerJsvar, dsvar);
            fmt.format("}\n", new Object[0]);
        }
        fmt.format("var %s_tbar = %s.getTopToolbar();\n", jsvar, jsvar);
        fmt.format("var %s_bbar = %s.getBottomToolbar();\n", jsvar, jsvar);
        fmt.format("if(%s_tbar) {\n", jsvar);
        fmt.format("%s_tbar.pageSize = %d;\n", jsvar, grid.getRows());
        fmt.format("%s_tbar.bind(%s);\n", jsvar, dsvar);
        fmt.format("}\n", new Object[0]);
        fmt.format("if(%s_bbar) {\n", jsvar);
        fmt.format("%s_bbar.pageSize = %d;\n", jsvar, grid.getRows());
        fmt.format("%s_bbar.bind(%s);\n", jsvar, dsvar);
        fmt.format("}\n", new Object[0]);
        fmt.format("%s.getStore().load({params:{start: %d, limit: %d}});\n", jsvar, grid.getFirst(), grid.getRows());
        DataGridRenderHelper.addOperationScript(buf.toString());
    }

    private void encodeRowResizableScript(String jsvar, Formatter fmt) {
        fmt.format("%s(%s);", Aliases.getAlias((String)"OM.SC.addGridRowResizeHandler"), Aliases.getVar((String)jsvar));
    }

    private void sortSelectedCells(int[][] cells) {
        Arrays.sort(cells, new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] a = (int[])o1;
                int[] b = (int[])o2;
                if (a[0] > b[0]) {
                    return 1;
                }
                if (a[0] < b[0]) {
                    return -1;
                }
                if (a[0] == b[0]) {
                    if (a[1] > b[1]) {
                        return 1;
                    }
                    if (a[1] < b[1]) {
                        return -1;
                    }
                }
                return 0;
            }
        });
    }

    public void setTitle(UIDataGrid grid, String title) {
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.getAttributes().put("jsvar", FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid));
        cm.getAttributes().put("title", title);
        cm.invoke(context, "setTitle", (UIComponent)grid);
    }

    protected String getStyleHeight(String style) {
        if (style == null) {
            return null;
        }
        String[] styleArray = style.split(";");
        String heightStr = null;
        String height = null;
        int i = 0;
        while (i < styleArray.length) {
            if (styleArray[i].toLowerCase().indexOf("height") != -1) {
                heightStr = styleArray[i];
                break;
            }
            ++i;
        }
        if (heightStr != null) {
            height = heightStr.indexOf("px") != -1 ? heightStr.substring(heightStr.indexOf(":") + 1, heightStr.indexOf("px")).trim() : heightStr.substring(heightStr.indexOf(":") + 1).trim();
        }
        return height;
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return false;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeResourceChildren(UIComponent component) {
        return true;
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }

    public boolean isRepaintable(UIComponent component) {
        log.fine("DataGrid[" + component.getId() + "] cannot be repaint.");
        return false;
    }
}

