/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.operamasks.faces.component.form.impl.UIDateField;
import org.operamasks.faces.component.form.impl.UIField;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.convert.DefaultDateTimeConverter;
import org.operamasks.faces.render.widget.ajax.AjaxTextFieldRenderer;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.DateTimeFormatUtils;
import org.operamasks.resources.format.FormatResources;

public class AjaxDateFieldRenderer
extends AjaxTextFieldRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIDateField field = (UIDateField)component;
        if (!CompRendererUtils.needsDecode((UIComponent)field)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(clientId);
        Converter c = field.getConverter();
        if (c == null) {
            DefaultDateTimeConverter dateTimeConverter = new DefaultDateTimeConverter();
            String format = field.getFormat();
            format = format == null ? this.getDefaultFormat(field) : format;
            dateTimeConverter.setPattern(format);
            dateTimeConverter.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            field.setConverter((Converter)dateTimeConverter);
        } else {
            field.setFormat(DateTimeFormatUtils.getPattenFromConverter((Converter)c));
        }
        this.setSubmittedValue(component, newValue);
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.form", "Ext.menu.DateMenu"};
    }

    public ExtConfig getExtraConfig(UIField field) {
        ExtConfig config = new ExtConfig();
        StringBuilder buf = new StringBuilder();
        buf.append("function(value){return value?(value.dateFormat ? value.dateFormat('");
        assert (field instanceof UIDateField);
        String format = ((UIDateField)field).getFormat();
        if (format == null) {
            String defaultFormat = this.getDefaultFormat(field);
            Converter c = field.getConverter();
            String patten = DateTimeFormatUtils.getPattenFromConverter((Converter)c);
            if (patten != null) {
                defaultFormat = patten;
            }
            buf.append(DateTimeFormatUtils.converToClientFormat((String)defaultFormat));
        } else {
            buf.append(DateTimeFormatUtils.converToClientFormat((String)format));
        }
        buf.append("') : value):'';}");
        config.set("renderer", buf.toString());
        return config;
    }

    protected String getDefaultFormat(UIField field) {
        return FormatResources.getText((String)"DEFAUTL_DATE_FORMAT", (Locale)this.getLocale(field));
    }

    protected Locale getLocale(UIField field) {
        UIDateField dateField;
        if (field instanceof UIDateField && (dateField = (UIDateField)field).getLocale() != null) {
            return dateField.getLocale();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null && context.getViewRoot().getLocale() != null) {
            return context.getViewRoot().getLocale();
        }
        return Locale.US;
    }

    protected String getExtClass(UIComponent component) {
        return "Ext.form.DateField";
    }

    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        Converter c;
        UIDateField field = (UIDateField)component;
        Object currentValue = field.getValue();
        String format = field.getFormat();
        if (format == null) {
            format = this.getDefaultFormat(field);
            c = field.getConverter();
            String patten = DateTimeFormatUtils.getPattenFromConverter((Converter)c);
            if (patten != null) {
                format = patten;
            }
        }
        if (field.getConverter() == null) {
            c = new DefaultDateTimeConverter();
            field.setConverter(c);
            c.setPattern(format);
        }
        config.set("value", this.getFormattedValue(context, component, currentValue));
        config.set("format", DateTimeFormatUtils.converToClientFormat((String)format));
        if (field.getRegex() != null) {
            config.set("regex", field.getRegex(), true);
        }
        if (field.getMaskRe() != null) {
            config.set("maskRe", field.getMaskRe(), true);
        }
        this.setJsArray(config, "disabledDates", field.getDisabledDates());
        this.setJsArray(config, "disabledDays", field.getDisabledDays());
    }

    private void setJsArray(ExtConfig config, String attrName, String attrValue) {
        if (attrValue != null) {
            if (attrValue.length() == 0) {
                config.set(attrName, "[]", true);
            } else {
                config.set(attrName, attrValue, true);
            }
        }
    }
}

