/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.operamasks.faces.component.AjaxActionEventHandler;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.component.widget.fileupload.impl.UIFileUploadDialog;
import org.operamasks.faces.conversation.ConversationContext;
import org.operamasks.faces.conversation.ConversationHelper;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.user.ajax.PartialUpdateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxFileUploadDialogRenderer
extends AjaxRendererBase {
    public static final String DELEGATE_PARAM = "fileUploadId";
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxFileUploadDialogRenderer() {
        liteAttrCore.put("show", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                Boolean show = (Boolean)component.getAttributes().get("show");
                if (show != null) {
                    if (Boolean.TRUE.equals(show)) {
                        out.writeScriptBlock(String.format("%s.show();", jsvar));
                    } else {
                        out.writeScriptBlock(String.format("%s.hide();", jsvar));
                    }
                }
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"OM.fileupload-dialog"};
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.ux.FileUploadDialog"};
    }

    private String getExtClass() {
        return "Ext.ux.UploadDialog.Dialog";
    }

    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        StringBuffer sb;
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String jsvar = resource.allocVariable(component);
        UIFileUploadDialog upload = (UIFileUploadDialog)component;
        Formatter fmt = new Formatter(new StringBuffer());
        fmt.format("%s = new %s({", jsvar, this.getExtClass());
        ExtConfig config = new ExtConfig(component);
        config.set("allow_close_on_upload", true);
        config.set("post_var_name", "upload");
        if (upload.getPermittedExtensions() != null) {
            String[] extensions = upload.getPermittedExtensions().split(",");
            sb = new StringBuffer();
            sb.append("[");
            for (int i = 0; i < extensions.length; ++i) {
                sb.append("'");
                sb.append(extensions[i]);
                sb.append("'");
                if (i >= extensions.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            config.set("permitted_extensions", sb.toString(), true);
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        sb = new StringBuffer();
        sb.append(request.getRequestURL().toString());
        sb.append("?").append(DELEGATE_PARAM).append("=");
        sb.append(component.getId());
        sb.append("&__view_delegate_request__=");
        String url = sb.toString();
        ConversationContext cctx = ConversationContext.getCurrentInstance();
        if (cctx != null) {
            url = ConversationHelper.appendCidIfNecessary((String)cctx.getId(), (String)url);
        }
        config.set("url", url);
        String configStr = config.toScript();
        fmt.format(configStr, new Object[0]);
        fmt.format("});\n", new Object[0]);
        AjaxActionEventHandler handler = new AjaxActionEventHandler(component);
        fmt.format(handler.toScript(), new Object[0]);
        resource.addInitScript(fmt.toString());
    }

    public void setWidth(UIFileUploadDialog fileUploadDialog, String width) {
    }

    public void setHeight(UIFileUploadDialog fileUploadDialog, String height) {
    }

    public void show(UIFileUploadDialog fileUploadDialog) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)fileUploadDialog, new String[]{"show"});
    }

    public void close(UIFileUploadDialog fileUploadDialog) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)fileUploadDialog, new String[]{"show"});
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

