/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.component.ServerSideValidateSupport;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.component.widget.FormMessageTarget;
import org.operamasks.faces.component.widget.UIForm;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.Resource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.resources.Resources;

public class AjaxFormRenderer
extends AjaxRendererBase {
    private static final String CLIENT_VALIDATE_PARAM = "org.operamasks.faces.CLIENT_VALIDATE";
    private static final String HIDDEN_FIELDS_ATTR = "org.operamasks.faces.HIDDEN_FIElDS";
    private static final String TRANSIENT_FORM_PARAM = "org.operamasks.faces.TRANSIENT_FORM";
    private static final String FORM_RICH_PARAM = "org.operamasks.faces.FORM_RICH";
    private static final String SUPPORT_SCRIPTS_ATTR = "org.operamasks.faces.SUPPORT_SCRIPTS";

    public void decode(FacesContext context, UIComponent component) {
        String postback = AjaxFormRenderer.getPostbackFieldName(context, component);
        if (context.getExternalContext().getRequestParameterMap().containsKey(postback)) {
            ((UIForm)component).setSubmitted(true);
            PartialUpdateCandidates.getInstance().markSubmitForm(component);
        } else {
            ((UIForm)component).setSubmitted(false);
        }
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        if (this.hasFormParent(component)) {
            throw new FacesException(Resources._T((String)"JSF_NESTED_FORM"));
        }
        ResponseWriter out = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String method = null;
        if (this.isTransientFormSupported()) {
            method = component.getAttributes().get("method");
        }
        if (method == null) {
            method = "post";
        }
        out.startElement("form", component);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        out.writeAttribute("method", (Object)method, null);
        out.writeAttribute("action", (Object)RendererUtils.getActionURL((FacesContext)context), null);
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
        out.writeText((Object)"\n", null);
    }

    public static String getPostbackFieldName(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        return clientId + ':' + "_postback";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        Double timeout;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        String renderId = this.getRenderId(component);
        ResponseWriter out = context.getResponseWriter();
        if (renderId != null && renderId.length() != 0) {
            out.startElement("input", component);
            out.writeAttribute("type", (Object)"hidden", null);
            out.writeAttribute("name", (Object)"org.operamasks.faces.RenderId", null);
            out.writeAttribute("value", (Object)renderId, null);
            out.endElement("input");
        }
        out.startElement("span", component);
        out.writeAttribute("id", (Object)(component.getClientId(context) + "_none"), null);
        out.endElement("span");
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        fmt.format("document.forms['%s']._clientValidateFieldIds=new Array();", component.getClientId(context));
        fmt.format("document.forms['%s']._validateBeforeSubmit=%b;", component.getClientId(context), ((UIForm)component).getValidateBeforeSubmit());
        String onsubmit = (String)component.getAttributes().get("onsubmit");
        String onbeforerequest = (String)component.getAttributes().get("onbeforerequest");
        String onsuccess = (String)component.getAttributes().get("onsuccess");
        String onfailure = (String)component.getAttributes().get("onfailure");
        String oncomplete = (String)component.getAttributes().get("oncomplete");
        String ontimeout = (String)component.getAttributes().get("ontimeout");
        String groupId = (String)component.getAttributes().get("groupId");
        fmt.format("OM.ajax.initForm(document.forms['%s'],{", component.getClientId(context));
        if (onsubmit != null) {
            fmt.format("onsubmit:function(){%s},", onsubmit);
        }
        if (onbeforerequest != null) {
            fmt.format("onbeforerequest:function(){%s},", onbeforerequest);
        }
        if (onsuccess != null) {
            fmt.format("onsuccess:function(){%s},", onsuccess);
        }
        if (onfailure != null) {
            fmt.format("onfailure:function(){%s},", onfailure);
        }
        if (oncomplete != null) {
            fmt.format("oncomplete:function(){%s},", oncomplete);
        }
        if (ontimeout != null) {
            fmt.format("ontimeout:function(){%s},", ontimeout);
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.deleteCharAt(buf.length() - 1);
        }
        buf.append("},");
        if (groupId == null) {
            fmt.format("null", new Object[0]);
        } else {
            fmt.format("'%s'", groupId);
        }
        Boolean queueRequest = (Boolean)component.getAttributes().get("queueRequest");
        if (Boolean.TRUE.equals(queueRequest)) {
            buf.append(",");
            fmt.format("%s", (boolean)queueRequest);
        }
        if ((timeout = (Double)component.getAttributes().get("timeout")) != null) {
            buf.append(",");
            fmt.format("%s", (double)timeout);
        }
        buf.append(");");
        this.addSupportScript((UIForm)component, buf.toString());
        this.renderHiddenFields(context, component);
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("name", (Object)AjaxFormRenderer.getPostbackFieldName(context, component), null);
        out.endElement("input");
        if (this.isTransientForm((UIForm)component)) {
            out.startElement("input", component);
            out.writeAttribute("type", (Object)"hidden", null);
            out.writeAttribute("name", (Object)"javax.faces.ViewId", null);
            out.writeAttribute("value", (Object)context.getViewRoot().getViewId(), null);
            out.endElement("input");
            try {
                FacesUtils.markForTransientState((FacesContext)context);
                context.getApplication().getViewHandler().writeState(context);
            }
            finally {
                FacesUtils.unmarkTransientState((FacesContext)context);
            }
        } else {
            context.getApplication().getViewHandler().writeState(context);
        }
        out.endElement("form");
        this.renderScripts(context, component);
    }

    public void encodeInitScriptBegin(FacesContext context, final ResourceManager manager, final UIComponent component) throws IOException {
        if (this.isRichEnabled(context, component)) {
            this.setRichRendererType(component, context);
        }
        if (!this.isClientValidateEnabled(context, component)) {
            return;
        }
        manager.registerResource((Resource)new AbstractResource("urn:client-validate:" + component.getClientId(context)){

            public int getPriority() {
                return 0;
            }

            public void encodeEnd(FacesContext context) throws IOException {
                String script;
                ComponentResource resource = (ComponentResource)manager.getRegisteredResource("urn:yui-ext");
                if (resource != null && (script = this.encodeExtStyleValidationScripts(context, (UIForm)component)) != null && script.length() != 0) {
                    resource.addInitScript(script);
                }
            }

            private String encodeExtStyleValidationScripts(FacesContext context, UIForm form) {
                Iterator kids = FacesUtils.createFacetsAndChildrenIterator((UIComponent)form, (boolean)false);
                StringBuilder buf = new StringBuilder();
                while (kids.hasNext()) {
                    UIComponent child = (UIComponent)kids.next();
                    if (!child.isRendered() || !AjaxFormRenderer.this.isServerSideValidateSupport(child)) continue;
                    buf.append(this.encodeExtStyleValidationScripts(context, form, (UIInput)child));
                }
                return buf.toString();
            }

            private String encodeExtStyleValidationScripts(FacesContext context, UIForm form, UIInput component2) {
                Aliases alias = Aliases.getInstance((FacesContext)context);
                return String.format("%s('%s','%s',%s);", alias.alias("OM.ajax.initValidation"), form.getClientId(context), component2.getClientId(context), alias.var(FacesUtils.getJsvar((FacesContext)context, (UIComponent)component2)));
            }
        });
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        context.getApplication().getViewHandler().writeState(context);
        UIForm form = (UIForm)component;
        if (!FormMessageTarget.none.toString().equals(form.getMsgTarget())) {
            this.updateServerSideValidationErrors(context, form);
        }
    }

    private boolean isServerSideValidateSupport(UIComponent component) {
        return component instanceof UIInput || component instanceof ServerSideValidateSupport;
    }

    private void updateServerSideValidationErrors(FacesContext context, UIForm form) {
        if (this.isImmediate(context)) {
            this.updateImmediateWidgetError(context, form);
        } else {
            this.updateAllWidgetErrors(context, form);
        }
    }

    private void updateImmediateWidgetError(FacesContext context, UIForm form) {
        Iterator kids = FacesUtils.createFacetsAndChildrenIterator((UIComponent)form, (boolean)false);
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (!this.isServerSideValidateSupport(child)) continue;
            UIInput input = (UIInput)child;
            if (!child.isRendered() || !this.isActionSourceWidget(context, (UIComponent)input)) continue;
            if (input.isValid()) {
                this.resetServerSideValidationErrors(context, input);
            } else {
                this.encodeServerSideValidationErrors(context, input);
            }
            return;
        }
    }

    private void updateAllWidgetErrors(FacesContext context, UIForm form) {
        Iterator kids = FacesUtils.createFacetsAndChildrenIterator((UIComponent)form, (boolean)false);
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (!this.isServerSideValidateSupport(child)) continue;
            UIInput input = (UIInput)child;
            if (!child.isRendered()) continue;
            if (input.isValid()) {
                this.resetServerSideValidationErrors(context, input);
                continue;
            }
            this.encodeServerSideValidationErrors(context, input);
        }
    }

    private boolean isActionSourceWidget(FacesContext context, UIComponent component) {
        String sourceWidgetClientId = ((HttpServletRequest)context.getExternalContext().getRequest()).getParameter("sourceWidgetClientId");
        return sourceWidgetClientId != null && sourceWidgetClientId.equals(component.getClientId(context));
    }

    private boolean isImmediate(FacesContext context) {
        String immediate = ((HttpServletRequest)context.getExternalContext().getRequest()).getParameter("immediate");
        return "true".equalsIgnoreCase(immediate);
    }

    private void resetServerSideValidationErrors(FacesContext context, UIInput input) {
        AjaxResponseWriter writer = (AjaxResponseWriter)context.getResponseWriter();
        String inputJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)input);
        writer.writeActionScript("if(typeof " + inputJsvar + " != 'undefined')if(" + inputJsvar + ".clearInvalid){" + inputJsvar + ".clearInvalid();}");
    }

    private void encodeServerSideValidationErrors(FacesContext context, UIInput input) {
        Iterator iter = context.getMessages(input.getClientId(context));
        if (null == iter || !iter.hasNext()) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            String summary = message.getSummary();
            String detail = message.getDetail();
            if (buf.length() > 0) {
                buf.append("<br/>");
            }
            if (summary != null && summary.length() > 0) {
                buf.append(summary);
            }
            if (detail == null || detail.length() <= 0 || detail.equals(summary)) continue;
            buf.append("<br/>").append(detail);
        }
        AjaxResponseWriter writer = (AjaxResponseWriter)context.getResponseWriter();
        String inputJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)input);
        writer.writeActionScript("if(typeof " + inputJsvar + " != 'undefined')if(" + inputJsvar + ".markInvalid){" + inputJsvar + ".markInvalid(" + HtmlEncoder.enquote((String)buf.toString()) + ");}");
    }

    private boolean isClientValidateEnabled(FacesContext context, UIComponent component) {
        Object clientValidate = component.getAttributes().get("clientValidate");
        if (clientValidate != null) {
            return "true".equalsIgnoreCase(clientValidate.toString());
        }
        String paramValue = context.getExternalContext().getInitParameter(CLIENT_VALIDATE_PARAM);
        return paramValue != null && paramValue.equalsIgnoreCase("true");
    }

    private String getRenderId(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AjaxUpdater) || ((AjaxUpdater)parent).getGlobalAction().booleanValue()) continue;
            return ((AjaxUpdater)parent).getRenderId();
        }
        return null;
    }

    private void addSupportScript(UIForm form, String script) {
        String key;
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        String supportScripts = (String)requestMap.get(key = SUPPORT_SCRIPTS_ATTR + form.getClientId(context));
        supportScripts = supportScripts == null ? script : supportScripts + script;
        requestMap.put(key, supportScripts);
    }

    private boolean hasFormParent(UIComponent component) {
        while (component != null) {
            if (!((component = component.getParent()) instanceof UIForm)) continue;
            return true;
        }
        return false;
    }

    private boolean isTransientFormSupported() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getViewHandler() instanceof ViewBuilder;
    }

    private void renderHiddenFields(FacesContext context, UIComponent form) throws IOException {
        String key;
        Map requestMap = context.getExternalContext().getRequestMap();
        Map hiddenFields = (Map)requestMap.get(key = HIDDEN_FIELDS_ATTR + form.getClientId(context));
        if (hiddenFields != null) {
            ResponseWriter out = context.getResponseWriter();
            for (Map.Entry entry : hiddenFields.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                out.startElement("input", null);
                out.writeAttribute("type", (Object)"hidden", null);
                out.writeAttribute("name", (Object)name, null);
                out.writeAttribute("value", (Object)value, null);
                out.endElement("input");
            }
        }
    }

    private boolean isTransientForm(UIForm form) {
        if (!this.isTransientFormSupported()) {
            return false;
        }
        if (form.isTransient()) {
            return true;
        }
        Object method = form.getAttributes().get("method");
        if (method != null && "get".equalsIgnoreCase(method.toString())) {
            return true;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String param = context.getExternalContext().getInitParameter(TRANSIENT_FORM_PARAM);
        return param != null && "true".equalsIgnoreCase(param);
    }

    private void renderScripts(FacesContext context, UIComponent form) throws IOException {
        String key;
        Map requestMap = context.getExternalContext().getRequestMap();
        String supportScripts = (String)requestMap.get(key = SUPPORT_SCRIPTS_ATTR + form.getClientId(context));
        if (supportScripts != null) {
            ResponseWriter out = context.getResponseWriter();
            out.startElement("script", null);
            out.writeAttribute("type", (Object)"text/javascript", null);
            out.writeAttribute("language", (Object)"Javascript", null);
            out.write(supportScripts);
            out.endElement("script");
            requestMap.remove(key);
        }
    }

    private boolean isRichEnabled(FacesContext context, UIComponent component) {
        Object rich = component.getAttributes().get("rich");
        if (rich != null) {
            return "true".equalsIgnoreCase(rich.toString());
        }
        String paramValue = context.getExternalContext().getInitParameter(FORM_RICH_PARAM);
        return paramValue != null && paramValue.equalsIgnoreCase("true");
    }

    private void setRichRendererType(UIComponent root, FacesContext context) {
        for (UIComponent kid : root.getChildren()) {
            String rendererType;
            if (kid.isRendered() && (rendererType = this.getRichRendererType(kid, context)) != null) {
                kid.setRendererType(rendererType);
            }
            this.setRichRendererType(kid, context);
        }
    }

    private String getRichRendererType(UIComponent component, FacesContext context) {
        return null;
    }
}

