/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.AjaxRendererBase;

public class AjaxHtmlScriptRenderer
extends AjaxRendererBase {
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        this.innerEncodeBegin(context, component);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        this.innerEncodeChildren(context, component);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        this.innerEncodeEnd(context, component);
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        this.innerEncodeBegin(context, component);
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public void encodeAjaxChildren(FacesContext context, UIComponent component) throws IOException {
        this.innerEncodeChildren(context, component);
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        this.innerEncodeEnd(context, component);
    }

    public void innerEncodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String type = (String)component.getAttributes().get("type");
        String language = (String)component.getAttributes().get("language");
        String src = (String)component.getAttributes().get("src");
        if (type == null) {
            type = "text/javascript";
        }
        if (src != null) {
            src = context.getApplication().getViewHandler().getResourceURL(context, src);
            out.startElement("script", component);
            out.writeAttribute("type", (Object)type, "type");
            if (language != null) {
                out.writeAttribute("language", (Object)language, "language");
            }
            out.writeAttribute("src", (Object)src, "src");
            out.endElement("script");
            out.write("\n");
        }
        if (component.getChildCount() > 0) {
            out.startElement("script", component);
            out.writeAttribute("type", (Object)type, "type");
            if (language != null) {
                out.writeAttribute("language", (Object)language, "language");
            }
        }
    }

    public void innerEncodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() == 0) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        StringWriter buf = new StringWriter();
        ResponseWriter bufOut = out.cloneWithWriter((Writer)buf);
        context.setResponseWriter(bufOut);
        this.encodeComponentChildren(context, component);
        context.setResponseWriter(out);
        StringBuffer output = new StringBuffer();
        Pattern p = Pattern.compile("@\\{([a-zA-Z0-9_:-]+)\\}");
        Matcher m = p.matcher(buf.getBuffer());
        while (m.find()) {
            String marker = m.group(1);
            UIComponent comp = FacesUtils.getForComponent((FacesContext)context, (String)marker, (UIComponent)component);
            String id = comp != null ? comp.getClientId(context) : marker;
            m.appendReplacement(output, "document.getElementById('" + id + "')");
        }
        m.appendTail(output);
        out.write(output.toString());
    }

    public void innerEncodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            ResponseWriter out = context.getResponseWriter();
            out.endElement("script");
            out.write("\n");
        }
    }

    public void encodeComponentChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                kid.encodeAll(context);
            }
        }
    }
}

