/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import org.operamasks.faces.component.AjaxActionEventHandler;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ContainerRenderUtils;
import org.operamasks.faces.render.container.MenuItemRenderer;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxMenuRenderer
extends AjaxRendererBase
implements ToolBarItemRenderer,
MenuItemRenderer {
    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.ux.ColumnMenu"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    private void replaceRenderer(UIComponent kid) {
        String rendererType;
        if (kid.isRendered() && (rendererType = this.getMenuItemRendererType(kid)) != null) {
            kid.setRendererType(rendererType);
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeMenuChildren(context, component);
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeMenuChildren(context, component);
    }

    private void encodeMenuChildren(FacesContext context, UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            Boolean isNew = (Boolean)child.getAttributes().get("isNew");
            if (isNew == null || !isNew.booleanValue()) continue;
            StringWriter strWriter = new StringWriter();
            RenderKit renderKit = context.getRenderKit();
            ResponseWriter out = context.getResponseWriter();
            ResponseWriter inner = renderKit.createResponseWriter((Writer)strWriter, null, "UTF-8");
            context.setResponseWriter(inner);
            ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
            try {
                inner.startDocument();
                rm.consumeResources(context, child);
                rm.encodeEnd(context);
                rm.reset();
                inner.endDocument();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (out != null) {
                context.setResponseWriter(out);
            }
            ComponentOperationManager.getInstance((FacesContext)context).addEndScript(strWriter.toString());
            child.getAttributes().remove("isNew");
        }
    }

    private void encodeColumnMenuInit(Formatter fmt, FacesContext context, UIComponent component, String jsvar, String clientId) {
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        fmt.format("%s%s=new %s({id:'%s'});", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.ux.ColumnMenu"), clientId);
        UIMenu parentMenu = MenuRendererHelper.getParentMenu(component);
        if (parentMenu != null) {
            String text = MenuRendererHelper.getItemText(context, component, false);
            String parentJsVar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)parentMenu);
            String itemJsVar = jsvar + "_item";
            fmt.format("%s", RendererUtils.getJsvarAliasDef((String)itemJsVar, (Aliases)alias));
            fmt.format("%s=new %s(%s{", itemJsVar, alias.alias("Ext.menu.Item"), c.start());
            MenuRendererHelper.encodeItemConfig(fmt, context, component, text, c);
            fmt.format(",%s:%s", c.prop("menu"), alias.var(jsvar));
            fmt.format("}%s);", c.end());
            fmt.format("%s.addItem(%s);", alias.var(parentJsVar), alias.var(itemJsVar));
        }
    }

    protected void encodeMenu(FacesContext context, ComponentResource resource, UIComponent component) {
        String clientId = component.getClientId(context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        Formatter fmt = new Formatter();
        this.encodeColumnMenuInit(fmt, context, component, jsvar, clientId);
        component.getAttributes().remove("isNew");
        resource.addJSPackageDependency("Ext.ux.ColumnMenu");
        resource.addVariable(jsvar);
        resource.addInitScript(fmt.toString());
    }

    protected String getMenuItemRendererType(UIComponent item) {
        String family = item.getFamily();
        String rendererType = item.getRendererType();
        if ("javax.faces.Command".equals(family) && "javax.faces.Link".equals(rendererType)) {
            return "org.operamasks.faces.widget.LinkMenuItem";
        }
        if ("javax.faces.Output".equals(family) && "javax.faces.Link".equals(rendererType)) {
            return "org.operamasks.faces.widget.LinkMenuItem";
        }
        if ("javax.faces.Output".equals(family) && "javax.faces.Text".equals(rendererType)) {
            return "org.operamasks.faces.widget.TextMenuItem";
        }
        if ("javax.faces.SelectBoolean".equals(family) && "javax.faces.Checkbox".equals(rendererType)) {
            return "org.operamasks.faces.widget.CheckMenuItem";
        }
        if ("javax.faces.SelectOne".equals(family) && "javax.faces.Radio".equals(rendererType)) {
            return "org.operamasks.faces.widget.RadioMenuItem";
        }
        if ("org.operamasks.faces.widget.Separator".equals(family)) {
            return "org.operamasks.faces.component.widget.UIMenuSeparator";
        }
        return null;
    }

    public void addMenu(FacesContext context, UIComponent component) {
        Boolean isNew = (Boolean)component.getAttributes().get("isNew");
        if (isNew == null || isNew.booleanValue()) {
            return;
        }
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        UIComponent newOne = (UIComponent)cm.getAttributes().get(component.getId() + ":addMenu:menu");
        component.getChildren().add(newOne);
        StringWriter strWriter = new StringWriter();
        RenderKit renderKit = context.getRenderKit();
        ResponseWriter out = context.getResponseWriter();
        ResponseWriter inner = renderKit.createResponseWriter((Writer)strWriter, null, "UTF-8");
        context.setResponseWriter(inner);
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        try {
            inner.startDocument();
            rm.consumeResources(context, newOne);
            rm.encodeEnd(context);
            rm.reset();
            inner.endDocument();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            context.setResponseWriter(out);
        }
        cm.addEndScript(strWriter.toString());
    }

    public String getToolBarItemAddScript(FacesContext context, UIComponent component, String jsvar) {
        StringBuilder script = new StringBuilder();
        Formatter fmt = new Formatter(script);
        fmt.format("%s.add(%s);", jsvar, this.getToolBarItemAddElement(context, component));
        return fmt.toString();
    }

    public String getToolBarItemAddElement(FacesContext context, UIComponent item) {
        return Aliases.getVar((String)this.getToolBarMenuTriggerJsvar(context, (UIMenu)item));
    }

    public String getToolBarItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        ResponseWriter out = context.getResponseWriter();
        boolean isAjaxPostback = !(out instanceof AjaxHtmlResponseWriter);
        String clientId = component.getClientId(context);
        String jsvar = null;
        jsvar = !isAjaxPostback ? resource.allocVariable(component) : FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        StringBuilder script = new StringBuilder();
        Formatter fmt = new Formatter(script);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menu");
        this.encodeColumnMenuInit(fmt, context, component, jsvar, clientId);
        for (UIComponent child : component.getChildren()) {
            this.replaceRenderer(child);
            if (!isAjaxPostback) {
                Object renderer = ContainerRenderUtils.getRenderer((UIComponent)child);
                if (!(renderer instanceof MenuItemRenderer)) continue;
                MenuItemRenderer itemRenderer = (MenuItemRenderer)renderer;
                script.append(itemRenderer.getMenuItemInitScript(context, child, component));
                continue;
            }
            StringWriter strWriter = new StringWriter();
            RenderKit renderKit = context.getRenderKit();
            ResponseWriter inner = renderKit.createResponseWriter((Writer)strWriter, null, "UTF-8");
            context.setResponseWriter(inner);
            try {
                inner.startDocument();
                rm.consumeResources(context, child);
                rm.encodeEnd(context);
                rm.reset();
                inner.endDocument();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (out != null) {
                context.setResponseWriter(out);
            }
            script.append(strWriter.toString());
        }
        UIMenu menu = (UIMenu)component;
        String triggerJsvar = this.getToolBarMenuTriggerJsvar(context, menu);
        resource.addVariable(triggerJsvar);
        script.append(RendererUtils.getJsvarAliasDef((String)triggerJsvar, (Aliases)alias));
        fmt.format("%s=new %s(%s{", triggerJsvar, alias.alias("Ext.Toolbar.Button"), c.start());
        fmt.format("%s:'%s'", c.prop("text"), MenuRendererHelper.getItemText(context, component, false));
        fmt.format(",%s:%s", c.prop("menu"), alias.var(jsvar));
        String image = MenuRendererHelper.getItemIcon(context, (UIComponent)menu);
        if (image != null && image.length() >= 0) {
            fmt.format(",%s:%s", c.prop("icon"), HtmlEncoder.enquote((String)image, (Character)Character.valueOf('\'')));
            fmt.format(",%s:%s", c.prop("iconCls"), HtmlEncoder.enquote((String)"x-btn-text-icon", (Character)Character.valueOf('\'')));
        }
        fmt.format("}%s);", c.end());
        return script.toString();
    }

    private String getToolBarMenuTriggerJsvar(FacesContext context, UIMenu menu) {
        String triggerJsvar = menu.getTriggerJsvar();
        if (triggerJsvar == null || triggerJsvar.length() == 0) {
            triggerJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)menu) + "_trigger";
        }
        return triggerJsvar;
    }

    public String getMenuItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        StringBuilder script = new StringBuilder();
        Formatter fmt = new Formatter(script);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String clientId = component.getClientId(context);
        this.encodeColumnMenuInit(fmt, context, component, jsvar, clientId);
        for (UIComponent kid : component.getChildren()) {
            this.replaceRenderer(kid);
            Object renderer = ContainerRenderUtils.getRenderer((UIComponent)kid);
            if (!(renderer instanceof MenuItemRenderer)) continue;
            MenuItemRenderer itemRenderer = (MenuItemRenderer)renderer;
            script.append(itemRenderer.getMenuItemInitScript(context, kid, component));
        }
        AjaxActionEventHandler handler = new AjaxActionEventHandler(component);
        fmt.format("%s", handler.toScript());
        return script.toString();
    }

    public boolean ignoreChildren() {
        return true;
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        Boolean isNew = (Boolean)component.getAttributes().get("isNew");
        if ((isNew == null || !isNew.booleanValue()) && FacesUtils.isAjaxResponse((FacesContext)context)) {
            return;
        }
        this.encodeMenu(context, resource, component);
        for (UIComponent kid : component.getChildren()) {
            this.replaceRenderer(kid);
        }
        ResponseWriter out = context.getResponseWriter();
        if (out instanceof AjaxHtmlResponseWriter) {
            ((AjaxHtmlResponseWriter)out).setViewStateChanged();
        }
    }
}

