/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.grid.UISimpleDataGrid;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.faces.component.widget.UIPager;
import org.operamasks.faces.component.widget.invisible.ForEach;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.Resource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.PagingLinkRenderHelper;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.user.ajax.UpdateLevel;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.resources.Resources;

public class AjaxPagingLinkRenderer
extends AjaxRendererBase {
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        String clientId = component.getClientId(context);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("div", component);
        this.encodeTheme((UIPager)component, out);
        out.writeAttribute("id", (Object)clientId, "clientId");
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
        out.endElement("div");
        out.write("\n");
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        UIComponent target;
        ResponseWriter out = context.getResponseWriter();
        UIPager pager = (UIPager)component;
        String clientId = component.getClientId(context);
        if (pager.getTargetDataStore() == null && (target = this.getUITarget(context, component)) != null) {
            int first = 0;
            int rows = 0;
            if (target instanceof UIData) {
                first = ((UIData)target).getFirst();
                rows = ((UIData)target).getRows();
            } else if (target instanceof UIDataGrid) {
                first = ((UIDataGrid)target).getFirst();
                rows = ((UIDataGrid)target).getRows();
            }
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            String instruction = null;
            if (this.supportAjaxDataStore(target)) {
                String targetJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)target);
                instruction = String.format("OM.ajax.addRequestParameter('%s','%d:%d');\n%s.repaint(%d,%s.store.getTotalCount());\n", clientId, first, rows, jsvar, first, targetJsvar);
            } else if (target instanceof UIData) {
                instruction = String.format("OM.ajax.addRequestParameter('%s','%d:%d');\n%s.repaint(%d,%d);\n", clientId, first, rows, jsvar, first, ((UIData)target).getRowCount());
            }
            ((AjaxResponseWriter)out).writeActionScript(instruction);
        }
    }

    private void encodeTheme(UIPager pager, ResponseWriter out) throws IOException {
        String theme = pager.getTheme();
        if (theme != null) {
            out.writeAttribute("class", (Object)PagingLinkRenderHelper.getThemeCssClass(theme), "");
        }
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.om.PagingLink"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"OM.paginglink"};
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        final ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        final UIPager pager = (UIPager)component;
        String dsvar = pager.getBindingDataStore();
        if (dsvar != null) {
            String jsvar = resource.allocVariable(component);
            String script = this.encodeScript(context, pager, jsvar, dsvar, null);
            resource.addInitScript(script);
            return;
        }
        final UIComponent target = this.getUITarget(context, (UIComponent)pager);
        if (target != null) {
            int pageSize = 0;
            if (target instanceof UIData) {
                pageSize = ((UIData)target).getRows();
            } else if (target instanceof UIDataGrid) {
                pageSize = ((UIDataGrid)target).getRows();
            }
            if (pageSize <= 0) {
                pageSize = pager.getPageSize();
            }
            pager.setPageSize(pageSize);
            if (target instanceof UIData) {
                ((UIData)target).setRows(pageSize);
            } else if (target instanceof UIDataGrid) {
                ((UIDataGrid)target).setRows(pageSize);
            }
            String id = "urn:paging-link:" + pager.getClientId(context);
            rm.registerResource((Resource)new AbstractResource(id){

                public int getPriority() {
                    return resource.getPriority() - 1;
                }

                public void encodeEnd(FacesContext context) {
                    if (!pager.isBound()) {
                        String jsvar = resource.allocVariable((UIComponent)pager);
                        String script = null;
                        if (AjaxPagingLinkRenderer.this.supportAjaxDataStore(target)) {
                            String targetJsvar = Aliases.getVar((String)FacesUtils.getJsvar((FacesContext)context, (UIComponent)target));
                            script = AjaxPagingLinkRenderer.this.encodeScript(context, pager, jsvar, targetJsvar + ".getStore()", target);
                        } else {
                            script = AjaxPagingLinkRenderer.this.encodeScript(context, pager, jsvar, null, target);
                        }
                        resource.addInitScript(script);
                    }
                }
            });
        }
    }

    private boolean supportAjaxDataStore(UIComponent target) {
        return !(target instanceof ForEach) && !(target instanceof UISimpleDataGrid);
    }

    private String encodeScript(FacesContext context, UIPager pager, String jsvar, String dsvar, UIComponent target) {
        Integer shownNumbers;
        String prevText;
        String clientId = pager.getClientId(context);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("paginglink");
        int pageSize = pager.getPageSize();
        fmt.format("%s%s=new %s('%s',%s{%s:%d,%s:%d", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.om.PagingLink"), clientId, c.start(), c.prop("start"), pager.getStart(), c.prop("pageSize"), pageSize);
        fmt.format(",%s:", c.prop("callback"));
        if (dsvar != null) {
            fmt.format("%s(%s)", alias.alias("OM.SC.pagingLinkCallback"), dsvar);
        } else {
            fmt.format("function(start,limit){%s('%s',start+':'+limit);", alias.alias("OM.SC.addRequestParameter"), clientId);
            buf.append(RendererUtils.encodeAjaxSubmit((FacesContext)context, (UIComponent)pager, (String)jsvar, (String[])new String[0])).append("}");
        }
        String totalText = this.getText(context, (UIComponent)pager, "total");
        if (totalText != null) {
            buf.append(String.format(",%s:", c.prop("totalText"))).append(HtmlEncoder.enquote((String)totalText));
        }
        Boolean showFirst = pager.isShowFirst();
        String firstText = this.getText(context, (UIComponent)pager, "first");
        if (showFirst == null && firstText != null || showFirst != null && showFirst.booleanValue()) {
            if (firstText == null) {
                firstText = Resources._T((String)"UI_PAGING_LINK_FIRST_PAGE");
            }
            buf.append(String.format(",%s:true,%s:", c.prop("showFirst"), c.prop("firstText"))).append(HtmlEncoder.enquote((String)firstText));
        }
        Boolean showLast = pager.isShowLast();
        String lastText = this.getText(context, (UIComponent)pager, "last");
        if (showLast == null && lastText != null || showLast != null && showLast.booleanValue()) {
            if (lastText == null) {
                lastText = Resources._T((String)"UI_PAGING_LINK_LAST_PAGE");
            }
            buf.append(String.format(",%s:true,%s:", c.prop("showLast"), c.prop("lastText"))).append(HtmlEncoder.enquote((String)lastText));
        }
        if ((prevText = this.getText(context, (UIComponent)pager, "previous")) == null) {
            prevText = Resources._T((String)"UI_PAGING_LINK_PREV_PAGE");
        }
        buf.append(String.format(",%s:", c.prop("prevText"))).append(HtmlEncoder.enquote((String)prevText));
        String nextText = this.getText(context, (UIComponent)pager, "next");
        if (nextText == null) {
            nextText = Resources._T((String)"UI_PAGING_LINK_NEXT_PAGE");
        }
        buf.append(String.format(",%s:", c.prop("nextText"))).append(HtmlEncoder.enquote((String)nextText));
        String numberText = this.getText(context, (UIComponent)pager, "number");
        if (numberText != null) {
            buf.append(String.format(",%s:", c.prop("numberText"))).append(HtmlEncoder.enquote((String)numberText));
        }
        if ((shownNumbers = pager.getShownNumbers()) != null) {
            buf.append(String.format(",%s:", c.prop("shownNumbers"))).append(shownNumbers);
        }
        fmt.format("}%s);", c.end());
        if (dsvar != null) {
            fmt.format("%s.bind(%s);", alias.var(jsvar), dsvar);
        } else {
            int first = 0;
            int rows = 0;
            if (target instanceof UIData) {
                first = ((UIData)target).getFirst();
                rows = ((UIData)target).getRows();
            } else if (target instanceof UIDataGrid) {
                first = ((UIDataGrid)target).getFirst();
                rows = ((UIDataGrid)target).getRows();
            }
            fmt.format("%s('%s','%d:%d');", alias.alias("OM.SC.addRequestParameter"), clientId, first, rows);
            if (this.supportAjaxDataStore(target)) {
                String targetJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)target);
                fmt.format("%s.repaint(%d,%s.store.getTotalCount());", alias.var(jsvar), first, alias.var(targetJsvar));
            } else if (target instanceof UIData) {
                fmt.format("%s.repaint(%d,%d);", alias.var(jsvar), first, ((UIData)target).getRowCount());
            }
        }
        return buf.toString();
    }

    public void decode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        String param = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (param != null && param.length() != 0) {
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            UIPager pager = (UIPager)component;
            UIComponent target = this.getUITarget(context, component);
            if (target != null) {
                try {
                    int sep = param.indexOf(58);
                    int first = Integer.parseInt(param.substring(0, sep));
                    int limit = Integer.parseInt(param.substring(sep + 1));
                    pager.setStart(first);
                    pager.setPageSize(limit);
                    if (target instanceof UIData) {
                        ((UIData)target).setFirst(first);
                        ((UIData)target).setRows(limit);
                        PartialUpdateManager.getInstance().markUpdate(true, UpdateLevel.Data, new UIComponent[]{target});
                    } else if (target instanceof UIDataGrid) {
                        ((UIDataGrid)target).setFirst(first);
                        ((UIDataGrid)target).setRows(limit);
                        PartialUpdateManager.getInstance().markUpdate(true, UpdateLevel.Data, new UIComponent[]{target});
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
    }

    private String getText(FacesContext context, UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        if (facet != null) {
            return FacesUtils.encodeComponent((FacesContext)context, (UIComponent)facet);
        }
        return null;
    }

    private UIComponent getUITarget(FacesContext context, UIComponent component) {
        UIComponent target;
        UIPager pager = (UIPager)component;
        String forId = pager.getFor();
        if (forId != null && ((target = FacesUtils.getForComponent((FacesContext)context, (String)forId, (UIComponent)component)) instanceof UIData || target instanceof UIDataGrid)) {
            return target;
        }
        return null;
    }
}

