/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.toolbar.ToolBarCarrier;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.component.widget.UIPager;
import org.operamasks.faces.component.widget.UIPagingToolbar;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ContainerRenderUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.ToolBarHelper;

public class AjaxPagingToolbarRenderer
extends AjaxRendererBase {
    public void decode(FacesContext context, UIComponent component) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String param = (String)paramMap.get(AjaxPagingToolbarRenderer.getDivId(context, component));
        if (param != null && param.length() != 0) {
            UIComponent target = ToolBarHelper.getTargetComponent(context, component, false);
            UIData data = null;
            if (target != null && target instanceof UIData) {
                data = (UIData)target;
            }
            if (data != null) {
                try {
                    UIPager pager = (UIPager)component;
                    int firstRow = Integer.parseInt(param);
                    int maxRows = data.getRowCount();
                    int pageSize = pager.getPageSize();
                    if (firstRow < 0) {
                        firstRow = 0;
                    } else if (maxRows > 0 && firstRow > maxRows) {
                        firstRow = (maxRows - 1) / pageSize * pageSize;
                    }
                    pager.setStart(firstRow);
                    data.setFirst(firstRow);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
    }

    private static UIData getUIData(FacesContext context, UIComponent component) {
        UIComponent target = ToolBarHelper.getForComponent(context, component, true);
        if (target != null && target instanceof UIData) {
            return (UIData)target;
        }
        return null;
    }

    public static String getDivId(FacesContext context, UIComponent component) {
        String cid = component.getClientId(context);
        if (cid.equals(FacesUtils.getJsvar((FacesContext)context, (UIComponent)component))) {
            cid = "div_" + cid;
        }
        return cid;
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        assert (context != null && component != null);
        if (!component.isRendered()) {
            return;
        }
        UIComponent target = ToolBarHelper.getTargetComponent(context, component, true);
        if (target instanceof ToolBarCarrier) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)AjaxPagingToolbarRenderer.getDivId(context, component), "clientId");
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        UIData data;
        assert (context != null && component != null);
        if (!component.isRendered()) {
            return;
        }
        UIComponent target = ToolBarHelper.getTargetComponent(context, component, true);
        if (target instanceof ToolBarCarrier) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.endElement("div");
        out.write("\n");
        UIPager pager = (UIPager)component;
        if (pager.getTargetDataStore() == null && (data = AjaxPagingToolbarRenderer.getUIData(context, component)) != null) {
            ((AjaxHtmlResponseWriter)out).setViewStateChanged();
        }
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        UIData data;
        assert (context != null && component != null);
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        UIPager pager = (UIPager)component;
        if (pager.getTargetDataStore() == null && (data = AjaxPagingToolbarRenderer.getUIData(context, component)) != null && out instanceof AjaxResponseWriter) {
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            ((AjaxResponseWriter)out).writeActionScript(String.format("%1$s.ds.count=%2$d;%1$s.ds.totalCount=%3$d;%1$s.onLoad(%1$s.ds,null,{params:{start:%4$d}});\n", jsvar, data.getRows(), data.getRowCount(), data.getFirst()));
            ((AjaxResponseWriter)out).setViewStateChanged();
        }
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.PagingToolbar"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        resource.addInitScript(this.getInitScript(context, component, rm, null, false));
    }

    public String getInitScript(FacesContext context, UIComponent component, ResourceManager rm, String dsvar, boolean asItem) {
        UIPagingToolbar pager = (UIPagingToolbar)component;
        if (dsvar == null) {
            dsvar = pager.getBindingDataStore();
        }
        String initScript = "";
        if (dsvar != null) {
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)pager);
            initScript = AjaxPagingToolbarRenderer.instantiationScript(context, (UIComponent)pager, jsvar, dsvar, asItem);
        }
        return initScript;
    }

    private static String instantiationScript(FacesContext context, UIComponent component, String jsvar, String dsvar, boolean asItem) {
        UIPagingToolbar pager = (UIPagingToolbar)component;
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("toolbar");
        int pageSize = pager.getPageSize();
        if (pageSize <= 0) {
            pageSize = 20;
        }
        ContainerRenderUtils.encodeItemInitScript((FacesContext)context, (UIComponent)component, (Formatter)fmt);
        ExtConfig config = new ExtConfig(component);
        if (!asItem) {
            config.set("renderTo", AjaxPagingToolbarRenderer.getDivId(context, component));
        }
        config.set("pageSize", pageSize);
        String configStr = config.toScript(c);
        fmt.format("if(typeof %1$s=='undefined'){%4$s%1$s=new %3$s(%5$s{%6$s:%2$s", jsvar, alias.var(dsvar), alias.alias("Ext.PagingToolbar"), RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), c.start(), c.prop("store"));
        if (configStr != null && configStr.length() > 0) {
            fmt.format(",%s", configStr);
        }
        fmt.format("}%s);};", c.end());
        return buf.toString();
    }

    private static String instantiationScriptAsItem(FacesContext context, UIComponent component, String jsvar, String dsvar) {
        UIComponent shadowToolBar;
        UIPagingToolbar pager = (UIPagingToolbar)component;
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("pagingtoolbar");
        int pageSize = pager.getPageSize();
        if (pageSize <= 0) {
            pageSize = 20;
        }
        ExtConfig config = new ExtConfig(component);
        config.set("pageSize", pageSize);
        String items = ToolBarHelper.encodeItemList(component);
        if (items.length() == 0 && (shadowToolBar = (UIComponent)component.getAttributes().get("shadow_toolbar")) != null) {
            items = ToolBarHelper.encodeItemList(shadowToolBar);
        }
        if (items.length() > 0) {
            config.set("items", items, true);
        }
        String configStr = config.toScript(c);
        fmt.format("%6$s%1$s=new %3$s(%4$s{%5$s:%2$s", jsvar, alias.var(dsvar), alias.alias("Ext.PagingToolbar"), c.start(), c.prop("store"), RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias));
        if (configStr != null && configStr.length() > 0) {
            fmt.format(",%s", configStr);
        }
        fmt.format("}%s)", c.end());
        return buf.toString();
    }

    public String encodeAsItem(UIPagingToolbar toolbar, UIComponent container) {
        FacesContext ctxt = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)ctxt, (UIComponent)toolbar);
        ResourceManager rm = ResourceManager.getInstance((FacesContext)ctxt);
        ComponentResource.registerJS((ResourceManager)rm, (String[])new String[]{"Ext.PagingToolbar"});
        StringBuilder buf = new StringBuilder();
        UIComponent forComponent = null;
        String forId = toolbar.getFor();
        forComponent = forId == null || forId.equals(container.getId()) ? container : ToolBarHelper.getForComponent(ctxt, (UIComponent)toolbar, true);
        if (forComponent == null) {
            StringBuilder msg = new StringBuilder("Cannot locate valid data component for paging tool bar ");
            msg.append(toolbar.getId());
            if (forId != null) {
                msg.append(". The component [" + forId + "] indicated by the 'for' attribute is not found.");
            }
            throw new FacesException(msg.toString());
        }
        String dsvar = FacesUtils.getJsvar((FacesContext)ctxt, (UIComponent)forComponent) + "_ds";
        buf.append(AjaxPagingToolbarRenderer.instantiationScriptAsItem(ctxt, (UIComponent)toolbar, jsvar, dsvar));
        return buf.toString();
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        for (UIComponent item : component.getChildren()) {
            rm.setIgnoreChildren(item, true);
        }
    }

    public boolean getEncodeResourceChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }
}

