/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.widget.UIPanelBox;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.Resource;
import org.operamasks.faces.render.resource.ResourceManager;

public class AjaxPanelBoxRenderer
extends AjaxRendererBase {
    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass == null || styleClass.indexOf("x-box") == -1) {
            styleClass = styleClass == null ? "x-box" : "x-box " + styleClass;
        }
        styleClass = styleClass + " " + this.getUniqueClassName(context, component);
        String style = (String)component.getAttributes().get("style");
        String height = "";
        if (style != null) {
            for (String cssAttr : style.split(";")) {
                String[] parts = cssAttr.split(":");
                if (!"height".equals(parts[0].trim())) continue;
                height = parts[1];
            }
            style = style.replaceAll("(?i)\\bheight:[^;]*;?", "");
        }
        out.startElement("div", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        out.writeAttribute("class", (Object)styleClass, "styleClass");
        out.writeAttribute("style", (Object)style, null);
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-tl", null);
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-tr", null);
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-tc", null);
        out.endElement("div");
        out.endElement("div");
        out.endElement("div");
        out.write("\n");
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-ml", null);
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-mr", null);
        String cstyle = (String)component.getAttributes().get("contentStyle");
        String cclass = (String)component.getAttributes().get("contentStyleClass");
        cclass = cclass == null ? "x-box-mc" : "x-box-mc " + cclass;
        out.startElement("div", null);
        out.writeAttribute("class", (Object)cclass, null);
        String styleHeight = String.format("height:%s;", height);
        if (cstyle != null) {
            out.writeAttribute("style", (Object)(cstyle + styleHeight), null);
        } else {
            out.writeAttribute("style", (Object)styleHeight, null);
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("div");
        out.endElement("div");
        out.endElement("div");
        out.write("\n");
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-bl", null);
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-br", null);
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"x-box-bc", null);
        out.endElement("div");
        out.endElement("div");
        out.endElement("div");
        out.write("\n");
        out.endElement("div");
    }

    private String getUniqueClassName(FacesContext context, UIComponent component) {
        String uniqueClass = (String)component.getAttributes().get("uniqueClass");
        if (uniqueClass == null) {
            uniqueClass = "x-box-" + context.getViewRoot().createUniqueId();
            component.getAttributes().put("uniqueClass", uniqueClass);
        }
        return uniqueClass;
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, final UIComponent component) {
        if (this.isDefaultConfig(component)) {
            ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        } else {
            String id = "urn:panelBox:stylesheet" + component.getClientId(FacesContext.getCurrentInstance());
            rm.registerResource((Resource)new AbstractResource(id){

                public int getPriority() {
                    return 900;
                }

                public void encodeBegin(FacesContext context) throws IOException {
                    AjaxPanelBoxRenderer.this.encodeStyleSheet(context, component);
                }
            });
        }
    }

    private boolean isDefaultConfig(UIComponent component) {
        UIPanelBox box = (UIPanelBox)component;
        return box.getBgcolor() == null && box.getColor() == null && box.getColor2() == null && box.getBorder() < 0 && box.getBorderColor() == null && box.getBorderRadius() < 0 && box.getRoundedCorners() == null;
    }

    private void encodeStyleSheet(FacesContext context, UIComponent component) throws IOException {
        String fillColor;
        boolean tl;
        boolean tr;
        boolean bl;
        boolean br;
        UIPanelBox box = (UIPanelBox)component;
        String id = this.getUniqueClassName(context, component);
        String bgcolor = box.getBgcolor();
        String color = box.getColor();
        String color2 = box.getColor2();
        String color3 = box.getColor3();
        int gradientExtent = box.getGradientExtent();
        int borderWidth = box.getBorder();
        String borderColor = box.getBorderColor();
        int borderRadius = box.getBorderRadius();
        String roundedCorners = box.getRoundedCorners();
        if (roundedCorners == null || roundedCorners.equals("all")) {
            br = true;
            bl = true;
            tr = true;
            tl = true;
        } else if (roundedCorners.equals("none")) {
            br = false;
            bl = false;
            tr = false;
            tl = false;
        } else {
            br = false;
            bl = false;
            tr = false;
            tl = false;
            for (String s : roundedCorners.split(",")) {
                if (s.equals("tl")) {
                    tl = true;
                    continue;
                }
                if (s.equals("tr")) {
                    tr = true;
                    continue;
                }
                if (s.equals("bl")) {
                    bl = true;
                    continue;
                }
                if (!s.equals("br")) continue;
                br = true;
            }
        }
        int radius = 0;
        if (borderWidth > borderRadius) {
            borderRadius = 0;
        }
        if (borderRadius > 0 && tl | tr | bl | br) {
            radius = borderRadius;
        } else if (borderWidth > 0) {
            radius = borderWidth;
        }
        String border = null;
        if (borderWidth > 0 || borderRadius > 0) {
            if (borderColor == null) {
                borderColor = "black";
            }
            border = borderWidth + "," + borderColor.replace("#", "") + "," + borderRadius;
        }
        String fill = null;
        if (color != null) {
            if (color2 != null) {
                if (gradientExtent <= 0) {
                    gradientExtent = 16;
                }
                fill = color.replace("#", "") + "," + color2.replace("#", "") + "," + gradientExtent;
                fillColor = color3 != null ? color3 : color2;
            } else {
                if (!color.equals("transparent") && radius > 0) {
                    fill = color.replace("#", "");
                }
                fillColor = color;
            }
        } else {
            fillColor = bgcolor != null ? bgcolor : "transparent";
        }
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        String url = rm.getServiceResourceURL("box-service", null);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        if (radius == 0) {
            fmt.format(".%s .x-box-tl {display:none;}\n", id);
        } else if (!tl && !tr) {
            if (borderWidth > 0) {
                fmt.format(".%s .x-box-tl{\nborder-top:%dpx solid %s;\n}\n", id, borderWidth, borderColor);
                fmt.format(".%s .x-box-tr{display:none;}\n", id);
            } else {
                fmt.format(".%s .x-box-tl{display:none;}\n", id);
            }
        } else {
            fmt.format(".%s .x-box-tl{\n", id);
            if (tl) {
                if (fill == null && border == null) {
                    fmt.format("background:%s;\n", fillColor);
                } else {
                    fmt.format("background:transparent url(\"%s?a=tl", url);
                    if (fill != null) {
                        fmt.format("&fill=%s", fill);
                    }
                    if (border != null) {
                        fmt.format("&border=%s", border);
                    }
                    if (bgcolor != null) {
                        fmt.format("&bg=%s", bgcolor.replace("#", ""));
                    }
                    buf.append("\") no-repeat top left;\n");
                }
            } else if (borderWidth > 0) {
                fmt.format("border-left:%dpx solid %s;\n", borderWidth, borderColor);
            }
            buf.append("}\n");
            fmt.format(".%s .x-box-tr{\n", id);
            if (tr) {
                if (fill == null && border == null) {
                    fmt.format("background:%s;\n", fillColor);
                } else {
                    fmt.format("background:transparent url(\"%s?a=tr", url);
                    if (fill != null) {
                        fmt.format("&fill=%s", fill);
                    }
                    if (border != null) {
                        fmt.format("&border=%s", border);
                    }
                    if (bgcolor != null) {
                        fmt.format("&bg=%s", bgcolor.replace("#", ""));
                    }
                    buf.append("\") no-repeat top right;\n");
                }
            } else if (borderWidth > 0) {
                fmt.format("border-right:%dpx solid %s;\n", borderWidth, borderColor);
            }
            buf.append("}\n");
            fmt.format(".%s .x-box-tc{\n", id);
            if (fill == null && border == null) {
                fmt.format("background:%s;\n", fillColor);
            } else {
                fmt.format("background:%s url(\"%s?a=mc", fillColor, url);
                if (fill != null) {
                    fmt.format("&fill=%s", fill);
                }
                if (border != null) {
                    fmt.format("&border=%s", border);
                }
                if (bgcolor != null) {
                    fmt.format("&bg=%s", bgcolor);
                }
                buf.append("\") repeat-x 0 0;\n");
            }
            if (radius > 0 && (tl || tr)) {
                fmt.format("height:%dpx;\nmargin:0 %dpx 0 %dpx;\n", radius, tr ? radius : 0, tl ? radius : 0);
            }
            buf.append("}\n");
        }
        fmt.format(".%s .x-box-ml{\n", id);
        if (fill != null) {
            fmt.format("background:%s url(\"%s?a=mc&fill=%s\") repeat-x 0 %dpx;\n", fillColor, url, fill, tl || tr ? -radius : 0);
        } else {
            fmt.format("background:%s;\n", fillColor);
        }
        if (borderWidth > 0) {
            fmt.format("border-left:%dpx solid %s;\n", borderWidth, borderColor);
        }
        buf.append("padding:0;\noverflow:hidden;\n}\n");
        fmt.format(".%s .x-box-mr{\n", id);
        if (borderWidth > 0) {
            fmt.format("border-right:%dpx solid %s;\n", borderWidth, borderColor);
        }
        buf.append("background:transparent;\npadding:0;\noverflow:hidden;\n}\n");
        if (radius > 0 && (tl || tr || bl || br)) {
            fmt.format(".%s .x-box-mc{\n", id);
            fmt.format("background:transparent;\n", new Object[0]);
            fmt.format("margin:0 %dpx 0 %dpx;\npadding:4px 10px;\n", tr || br ? radius / 2 : 0, tl || bl ? radius / 2 : 0);
            buf.append("}\n");
        }
        if (radius == 0) {
            fmt.format(".%s .x-box-bl {display:none;}\n", id);
        } else if (!bl && !br) {
            if (borderWidth > 0) {
                fmt.format(".%s .x-box-bl{\nborder-bottom:%dpx solid %s;\n}\n", id, borderWidth, borderColor);
                fmt.format(".%s .x-box-br{display:none;}\n", id);
            } else {
                fmt.format(".%s .x-box-bl{display:none;}\n", id);
            }
        } else {
            fmt.format(".%s .x-box-bl{\n", id);
            if (bl) {
                if (border != null) {
                    fmt.format("background:transparent url(\"%s?a=bl&border=%s&fill=%s", url, border, fillColor.replace("#", ""));
                    if (bgcolor != null) {
                        fmt.format("&bg=%s", bgcolor.replace("#", ""));
                    }
                    buf.append("\") no-repeat bottom left;\n");
                } else {
                    fmt.format("background:%s;\n", fillColor);
                }
            } else if (borderWidth > 0) {
                fmt.format("border-left:%dpx solid %s;\n", borderWidth, borderColor);
            }
            buf.append("}\n");
            fmt.format(".%s .x-box-br{\n", id);
            if (br) {
                if (border != null) {
                    fmt.format("background:transparent url(\"%s?a=br&border=%s&fill=%s", url, border, fillColor.replace("#", ""));
                    if (bgcolor != null) {
                        fmt.format("&bg=%s", bgcolor.replace("#", ""));
                    }
                    buf.append("\") no-repeat bottom right;\n");
                } else {
                    fmt.format("background:%s;\n", fillColor);
                }
            } else if (borderWidth > 0) {
                fmt.format("border-right:%dpx solid %s;\n", borderWidth, borderColor);
            }
            buf.append("}\n");
            fmt.format(".%s .x-box-bc{\n", id);
            fmt.format("background:%s;\n", fillColor);
            if (borderWidth > 0) {
                fmt.format("border-bottom:%dpx solid %s;\n", borderWidth, borderColor);
            }
            if (radius > 0 && (bl || br)) {
                fmt.format("height:%dpx;\nmargin:0 %dpx 0 %dpx;\n", radius - borderWidth, br ? radius : 0, bl ? radius : 0);
            }
            buf.append("}\n");
        }
        if (radius > 0) {
            fmt.format(".%1$s .x-box-tl,.%1$s .x-box-tr,.%1$s .x-box-tc,.%1$s .x-box-bl,.%1$s .x-box-br,.%1$s .x-box-bc", id);
            fmt.format("{\npadding:0;\noverflow:hidden;\n}\n", new Object[0]);
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("style", null);
        out.writeAttribute("type", (Object)"text/css", null);
        out.write("\n");
        out.write(buf.toString());
        out.endElement("style");
        out.write("\n");
    }
}

