/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.operamasks.faces.component.widget.UIProgressBar;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxProgressBarRenderer
extends AjaxRendererBase {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxProgressBarRenderer() {
        liteAttrCore.put("minimum", null);
        liteAttrCore.put("maximum", null);
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        String style;
        UIProgressBar progressBar = (UIProgressBar)component;
        Integer width = progressBar.getWidth();
        if (width == null || width <= 0) {
            width = 200;
        }
        if ((style = progressBar.getStyle()) == null) {
            style = "";
        } else if (!style.endsWith(";")) {
            style = style + ";";
        }
        style = style + "width:" + width + "px;";
        ResponseWriter out = context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)component.getClientId(context), "clientId");
        out.writeAttribute("style", (Object)style, "style");
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"style");
        out.endElement("div");
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        this.renderAjaxResponse(context, component);
    }

    private void renderAjaxResponse(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        UIProgressBar progressBar = (UIProgressBar)component;
        boolean repaint = false;
        Set attrs = uc.getAttributeCandidates(component);
        if (attrs.contains("minimum")) {
            Integer minimum = progressBar.getMinimum();
            if (minimum != null) {
                out.writeScriptBlock(String.format("%s.minimum=%d;", jsvar, minimum));
                repaint = true;
            }
            attrs.remove("minimum");
        }
        if (attrs.contains("maximum")) {
            Integer maximum = progressBar.getMaximum();
            if (maximum != null) {
                out.writeScriptBlock(String.format("%s.maximum=%d;", jsvar, maximum));
                repaint = true;
            }
            attrs.remove("maximum");
        }
        if (uc.isUpdateValue(component)) {
            String value = this.getCurrentValue(context, component);
            if (value == null) {
                value = "";
            }
            out.writeScriptBlock(String.format("%s.setValue(%s);", jsvar, value));
            attrs.remove("value");
            repaint = false;
        }
        if (repaint) {
            out.writeScriptBlock(String.format("%s.repaint();\n", jsvar));
        }
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attrs, this.getLiteAttributes());
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.om.ProgressBar"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        String value;
        UIProgressBar progressBar = (UIProgressBar)component;
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String clientId = component.getClientId(context);
        String jsvar = resource.allocVariable(component);
        Integer minimum = progressBar.getMinimum();
        Integer maximum = progressBar.getMaximum();
        if (minimum == null) {
            minimum = 0;
        }
        if (maximum == null) {
            maximum = 100;
        }
        if ((value = this.getCurrentValue(context, component)) == null || value.length() == 0) {
            value = "null";
        }
        String script = String.format("%s=new Ext.om.ProgressBar('%s',{minimum:%d,maximum:%d,value:%s});", jsvar, clientId, minimum, maximum, value);
        resource.addInitScript(script);
        resource.releaseVariable(jsvar);
    }

    public String getCurrentValue(FacesContext context, UIComponent component) {
        Object currentValue = this.getValue(component);
        if (currentValue != null) {
            return this.getFormattedValue(context, component, currentValue);
        }
        return null;
    }

    private Object getValue(UIComponent component) {
        if (component instanceof ValueHolder) {
            return ((ValueHolder)component).getValue();
        }
        return null;
    }

    private String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return FacesUtils.getFormattedValue((FacesContext)context, (UIComponent)component, (Object)currentValue);
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

