/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.operamasks.faces.component.form.impl.UIRadioGroup;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.widget.ajax.AbstractSelectGroupRenderer;
import org.operamasks.faces.render.widget.helper.SelectItemsRenderHelper;

public class AjaxRadioGroupRenderer
extends AbstractSelectGroupRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(clientId);
        String radioGroupSubmitFlag = clientId + "_flag";
        String isSubmitted = (String)requestMap.get(radioGroupSubmitFlag);
        if (isSubmitted != null) {
            if (newValue == null) {
                newValue = "";
            }
            this.setSubmittedValue(component, newValue);
        }
    }

    private void setSubmittedValue(UIComponent component, Object newValue) {
        if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setSubmittedValue(newValue);
        }
    }

    private String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        Object currentValue = this.getValue(component);
        if (currentValue != null) {
            return this.getFormattedValue(context, component, currentValue);
        }
        return null;
    }

    private Object getValue(UIComponent component) {
        if (component instanceof ValueHolder) {
            return ((ValueHolder)component).getValue();
        }
        return null;
    }

    private String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return FacesUtils.getFormattedValue((FacesContext)context, (UIComponent)component, (Object)currentValue);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return RendererUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected String buildHtmls(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        UIRadioGroup group = (UIRadioGroup)component;
        Formatter fmt = new Formatter(new StringBuffer());
        List<SelectItem> selectItems = SelectItemsRenderHelper.getSelectItems(component);
        int index = 1;
        String value = this.getCurrentValue(context, component);
        if (value == null) {
            value = "";
        }
        String radioGroupSubmitFlag = clientId + "_flag";
        fmt.format("<input type='hidden' name='%s'></input>", radioGroupSubmitFlag);
        fmt.format("<table id='%s'><tr>", clientId);
        for (SelectItem item : selectItems) {
            String strChecked = "";
            if (item.getValue() != null && item.getValue().toString().equals(this.getCurrentValue(context, component))) {
                strChecked = " checked='true'";
            }
            String radioId = this.generateSelectBoxId(clientId, index);
            fmt.format("<td><input type='radio' id='%s' name='%s' value='%s' %s/></td>", radioId, clientId, item.getValue(), strChecked);
            if ("v".equals(group.getDirection()) || "vertical".equals(group.getDirection())) {
                fmt.format("</tr><tr>", new Object[0]);
            } else if (group.getDimension() != null && index % group.getDimension() == 0) {
                fmt.format("</tr><tr>", new Object[0]);
            }
            ++index;
        }
        fmt.format("</tr></table>", new Object[0]);
        return fmt.toString();
    }

    protected String buildScripts(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        this.jsvarNames = new ArrayList();
        List<SelectItem> selectItems = SelectItemsRenderHelper.getSelectItems(component);
        int index = 1;
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("field");
        for (SelectItem item : selectItems) {
            String clientId_radio = this.generateSelectBoxId(clientId, index);
            String jsvar_radio = this.generateSelectBoxId(jsvar, index);
            ++index;
            this.jsvarNames.add(jsvar_radio);
            fmt.format("var %s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)jsvar_radio, (Aliases)alias), jsvar_radio, alias.alias("Ext.form.Radio"), c.start());
            ExtConfig config = new ExtConfig(component);
            config.set("boxLabel", item.getLabel());
            if (Boolean.TRUE.equals(((UIRadioGroup)component).getDisabled()) || item.isDisabled()) {
                config.set("style", "filter:auto\\9;");
            }
            String configStr = config.toScript(c);
            fmt.format(configStr, new Object[0]);
            fmt.format("}%s);", c.end());
            fmt.format("%s(%s,'%s');", alias.alias("OM.applyToMarkup"), alias.var(jsvar_radio), clientId_radio);
            String onchange = "";
            UIRadioGroup radioGroup = (UIRadioGroup)component;
            if (radioGroup.getOnchange() != null && !(onchange = radioGroup.getOnchange()).endsWith(";")) {
                onchange = onchange + ";";
            }
            if (Boolean.TRUE.equals(radioGroup.getDisabled()) || item.isDisabled()) {
                fmt.format("%s.disable();", alias.var(jsvar_radio));
            } else {
                fmt.format("%s.enable();", alias.var(jsvar_radio));
            }
            fmt.format("%s.on('check',function(){%s(%s);%s});", alias.var(jsvar_radio), alias.var(this.generateStateChangerName(jsvar)), alias.var(jsvar_radio), onchange);
        }
        fmt.format("%s=%s([", alias.var(this.generateStateChangerName(jsvar)), alias.alias("OM.SC.radioGroupStateChanger"));
        int n = selectItems.size();
        for (int i = 1; i <= n; ++i) {
            buf.append(alias.var(this.generateSelectBoxId(jsvar, i)));
            if (i >= n) continue;
            buf.append(",");
        }
        buf.append("]);");
        return fmt.toString();
    }
}

