/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.component.widget.menu.UIRadioMenuItem;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.MenuItemRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.ajax.RadioMenuItemRenderer;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxRadioMenuItemRenderer
extends RadioMenuItemRenderer
implements MenuItemRenderer {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxRadioMenuItemRenderer() {
        liteAttrCore.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                List<SelectItem> items = AjaxRadioMenuItemRenderer.this.getSelectItems(context, component);
                Formatter fmt = new Formatter();
                boolean isDisabled = RendererUtils.isDisabled((UIComponent)component);
                for (int i = 0; i < items.size(); ++i) {
                    if (isDisabled) {
                        fmt.format("%s$%d.disable();\n", jsvar, i);
                        continue;
                    }
                    fmt.format("%s$%d.enable();\n", jsvar, i);
                }
                out.writeScriptBlock(fmt.toString());
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String getMenuItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        String menuId = alias.var(FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent));
        String clientId = component.getClientId(context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        List<SelectItem> items = this.getSelectItems(context, component);
        boolean disabled = RendererUtils.isDisabled((UIComponent)component);
        String onbeforechange = (String)component.getAttributes().get("onbeforechange");
        String onchange = (String)component.getAttributes().get("onchange");
        String onclick = (String)component.getAttributes().get("onclick");
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        for (int i = 0; i < items.size(); ++i) {
            SelectItem item = items.get(i);
            String itemValue = this.getFormattedValue(context, component, item.getValue());
            String var = jsvar + "$" + i;
            fmt.format("if(window['%s']){%s.remove(window['%s']);}", var, menuId, var);
            fmt.format("%s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)var, (Aliases)alias), var, alias.alias("Ext.menu.CheckItem"), c.start());
            MenuRendererHelper.encodeItemConfig(fmt, context, component, item.getLabel(), c);
            fmt.format(",%s:'%s'", c.prop("group"), clientId);
            if (this.isOneSelected(context, component, item.getValue())) {
                fmt.format(",%s:true", c.prop("checked"));
            }
            if (!disabled && item.isDisabled()) {
                fmt.format(",%s:true", c.prop("disabled"));
            }
            fmt.format("}%s);", c.end());
            if (onbeforechange != null) {
                fmt.format("%s.on('beforecheckchange', function(item,checked){%s});", alias.var(var), onbeforechange);
            }
            fmt.format("%s.on('checkchange', function(item,checked){", alias.var(var));
            if (onchange != null) {
                buf.append(onchange);
                if (!onchange.endsWith(";")) {
                    buf.append(";");
                }
            }
            buf.append("if(checked){");
            buf.append(RendererUtils.encodeAjaxSubmit((FacesContext)context, (UIComponent)component, (String)jsvar, (String[])new String[]{HtmlEncoder.enquote((String)clientId), HtmlEncoder.enquote((String)itemValue)}));
            buf.append("}});");
            if (onclick != null) {
                fmt.format("%s.on('click', function(){%s});", alias.var(var), onclick);
            }
            fmt.format("%s.addItem(%s);", menuId, alias.var(var));
        }
        return fmt.toString();
    }

    @Override
    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UIMenu menu = MenuRendererHelper.getParentMenu(component);
        if (menu == null) {
            return;
        }
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        resource.addInitScript(this.getMenuItemInitScript(context, component, (UIComponent)menu));
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        List<SelectItem> items = this.getSelectItems(context, component);
        Formatter fmt = new Formatter();
        if (uc.isUpdateValue(component)) {
            for (int i = 0; i < items.size(); ++i) {
                SelectItem item = items.get(i);
                boolean checked = this.isOneSelected(context, component, item.getValue());
                fmt.format("%s$%d.setChecked(%b, true);\n", jsvar, i, checked);
            }
            out.writeScriptBlock(fmt.toString());
        }
        Set attrs = uc.getAttributeCandidates(component);
        attrs.remove("value");
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attrs, this.getLiteAttributes());
    }

    public void setDisabled(UIRadioMenuItem item, boolean disabled) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)item, new String[]{"disabled"});
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

