/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.grid.UIOutputColumn;
import org.operamasks.faces.component.grid.UISimpleDataGrid;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.Resource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.DataRendererHelper;

public class AjaxSimpleDataGridRenderer
extends AjaxRendererBase {
    private static final int COLUMN_DEFAULT_WIDTH = 100;
    private static final int SELECTION_COLUMN_WIDTH = 30;
    private static final String ROW_SELECTIONS_PARAM = ":_selections";

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void decode(FacesContext context, UIComponent component) {
        String[] selectionsValue;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String selectionsParam = (String)paramMap.get(clientId + ROW_SELECTIONS_PARAM);
        if (selectionsParam != null && selectionsParam.length() > 0 && (selectionsValue = selectionsParam.split(",")).length > 1) {
            int[] selections = new int[selectionsValue.length - 1];
            int i = 0;
            for (String s : selectionsValue) {
                if ("".equals(s)) continue;
                try {
                    selections[i++] = Integer.parseInt(s);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            ((UISimpleDataGrid)component).setSelections(selections);
        }
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"OM.SimpleDataGrid"};
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager manager, UIComponent component) {
        final UISimpleDataGrid grid = (UISimpleDataGrid)component;
        String id = "urn:simpleDatagrid:" + component.getClientId(FacesContext.getCurrentInstance());
        manager.registerResource((Resource)new AbstractResource(id){

            public int getPriority() {
                return 900;
            }

            public void encodeBegin(FacesContext context) throws IOException {
                AjaxSimpleDataGridRenderer.this.encodeCssStyle(context, grid);
            }
        });
    }

    private void encodeCssStyle(FacesContext context, UISimpleDataGrid grid) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<style>\n");
        List<UIColumn> columns = DataRendererHelper.getColumns((UIComponent)grid);
        int cssIndex = 0;
        String clientId = this.getSimpleClientId(context, (UIComponent)grid);
        for (UIColumn column : columns) {
            int width = ((UIOutputColumn)column).getWidth();
            buffer.append(String.format(".%s-x-grid3-col-%s,.%s-x-grid3-col-%s .x-grid3-cell-inner{width:%spx;overflow:hidden;}\n", clientId, cssIndex, clientId, cssIndex, width > 0 ? width : 100));
            ++cssIndex;
        }
        buffer.append(".x-grid3-cell-text, .x-grid3-hd-text {padding:0px 0px}\n");
        buffer.append("</style>");
        context.getResponseWriter().write(buffer.toString());
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        UISimpleDataGrid grid = (UISimpleDataGrid)component;
        out.startElement("div", null);
        out.writeAttribute("id", (Object)this.getOuterClientId(context, component), null);
        out.writeAttribute("style", (Object)("background-color:white;overflow:auto;" + grid.getStyle()), null);
        if (grid.getStyleClass() != null) {
            out.writeAttribute("class", (Object)grid.getStyleClass(), null);
        }
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public void encodeAjaxChildren(FacesContext context, UIComponent component) throws IOException {
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String clientId = this.getOuterClientId(context, component);
        StringBuffer buf = new StringBuffer();
        UISimpleDataGrid grid = (UISimpleDataGrid)component;
        this.encodeGrid(context, grid, buf);
        out.writeInnerHtmlScript(clientId, buf.toString());
        out.writeScriptBlock(String.format("document.getElementById('%s').value=',';", grid.getClientId(context) + ROW_SELECTIONS_PARAM));
    }

    private String getOuterClientId(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        return clientId + ':' + "_outer";
    }

    private String getSimpleClientId(FacesContext context, UIComponent component) {
        return component.getClientId(context).split(":")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        UISimpleDataGrid grid;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UISimpleDataGrid uISimpleDataGrid = grid = (UISimpleDataGrid)component;
        synchronized (uISimpleDataGrid) {
            grid.setRowIndex(-1);
        }
        StringBuffer buffer = new StringBuffer();
        if (FacesUtils.isAjaxHtmlResponse((FacesContext)context)) {
            this.encodeGrid(context, grid, buffer);
        }
        ResponseWriter out = context.getResponseWriter();
        out.write(buffer.toString());
        out.endElement("div");
        String hiddenInputId = component.getClientId(context) + ROW_SELECTIONS_PARAM;
        out.write(String.format("<input type='hidden' id='%s' name='%s' value=','/>", hiddenInputId, hiddenInputId));
    }

    private void encodeGrid(FacesContext context, UISimpleDataGrid grid, StringBuffer buffer) {
        List<UIColumn> columns = DataRendererHelper.getColumns((UIComponent)grid);
        int totalWidth = 0;
        if (grid.getShowSelectionColumn().booleanValue()) {
            totalWidth += 30;
        }
        for (UIColumn column : columns) {
            int width = ((UIOutputColumn)column).getWidth();
            totalWidth += width > 0 ? width : 100;
        }
        buffer.append(String.format("<div id='%s' style='background-color:white;overflow:auto;' class='x-grid3-container'>\n", grid.getClientId(context)));
        buffer.append("<div hidefocus='true' style='width: " + totalWidth + "px; height: 100%;'>\n");
        buffer.append("<div class='x-grid3-viewport' style='left: 0px; top: 0px; visibility: visible;position: relative;%s'>\n");
        this.encodeGridHeader(context, grid, buffer);
        this.encodeGridBody(context, grid, buffer);
        buffer.append("</div></div></div>");
    }

    private void encodeGridHeader(FacesContext context, UISimpleDataGrid grid, StringBuffer buffer) {
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        buffer.append("<div class='x-grid3-header'>\n");
        buffer.append("<table cellspacing='0' cellpadding='0' border='0'>\n");
        buffer.append("<tbody>\n");
        buffer.append("<tr class='x-grid3-hd-row'>\n");
        List<UIColumn> columns = DataRendererHelper.getColumns((UIComponent)grid);
        int cssIndex = 0;
        String simpleClientId = this.getSimpleClientId(context, (UIComponent)grid);
        boolean drawSelectionColumn = grid.getShowSelectionColumn();
        for (UIColumn column : columns) {
            if (drawSelectionColumn && cssIndex == grid.getSelectionColumnIndex()) {
                this.encodeSeltionColumnHeader(context, grid, buffer, simpleClientId);
                drawSelectionColumn = false;
            }
            buffer.append(String.format("<td class='x-grid3-hd %s-x-grid3-col-%s' align='center'>\n", this.getSimpleClientId(context, (UIComponent)grid), cssIndex++));
            buffer.append("<div class='x-grid3-hd-inner'>\n");
            buffer.append("<div unselectable='on' class='x-grid3-hd-text'>\n");
            buffer.append(String.format("%s<img src='%s' class='x-grid3-sort-icon'/>\n", ((UIOutputColumn)column).getColumnHeader(), rm.getResourceURL("/yuiext/s.gif")));
            buffer.append("</div></div></td>\n");
        }
        if (drawSelectionColumn) {
            this.encodeSeltionColumnHeader(context, grid, buffer, simpleClientId);
        }
        buffer.append("</tr></tbody></table></div>");
    }

    private void encodeSeltionColumnHeader(FacesContext context, UISimpleDataGrid grid, StringBuffer buffer, String gridClientId) {
        String hiddenInputId = grid.getClientId(context) + ROW_SELECTIONS_PARAM;
        buffer.append(String.format("<td class='x-grid3-hd' align='center' width='%s'>\n", 30));
        buffer.append(String.format("<input type='checkbox' style='margin-left:1px;' onclick='selectAllRows(this, \"%s\", \"%s\")'>\n", this.getOuterClientId(context, (UIComponent)grid), hiddenInputId));
        buffer.append("</td>");
    }

    private void encodeGridBody(FacesContext context, UISimpleDataGrid grid, StringBuffer buffer) {
        buffer.append("<div class='x-grid3-body' style='height: 100%;'>\n");
        buffer.append("<table cellspacing='0' cellpadding='0' border='0'>\n");
        buffer.append("<tbody>\n");
        String hiddenInputId = grid.getClientId(context) + ROW_SELECTIONS_PARAM;
        String simpleClientId = this.getSimpleClientId(context, (UIComponent)grid);
        List<UIColumn> columns = DataRendererHelper.getColumns((UIComponent)grid);
        int rowIndex = grid.getFirst();
        int rows = grid.getRows();
        for (int curRow = 0; rows == 0 || curRow < rows; ++curRow) {
            String altRowCss = curRow % 2 == 0 ? " x-grid3-row-alt" : "";
            buffer.append(String.format("<tr class='x-grid3-row%s' style='height:24px;'>\n", altRowCss));
            grid.setRowIndex(rowIndex++);
            if (!grid.isRowAvailable()) break;
            int cssIndex = 0;
            boolean drawSelectionColumn = grid.getShowSelectionColumn();
            for (UIColumn column : columns) {
                Object value = DataRendererHelper.getColumnValue(context, grid, column);
                String align = ((UIOutputColumn)column).getAlign();
                if (drawSelectionColumn && cssIndex == grid.getSelectionColumnIndex()) {
                    this.encodeSeltionColumnBody(buffer, rowIndex, hiddenInputId, simpleClientId);
                    drawSelectionColumn = false;
                }
                buffer.append(String.format("<td tabindex='0' class='x-grid3-col %s-x-grid3-col-%s' %s style='vertical-align:middle;'>\n", simpleClientId, cssIndex++, align == null ? "" : " align='" + align + "'"));
                buffer.append("<div class='x-grid3-cell-inner'>\n");
                buffer.append("<div unselectable='on' class='x-grid3-cell-text'>\n");
                buffer.append(value);
                buffer.append("</div></td>\n");
            }
            if (drawSelectionColumn) {
                this.encodeSeltionColumnBody(buffer, rowIndex, hiddenInputId, simpleClientId);
            }
            buffer.append("</tr>\n");
        }
        buffer.append("</tbody></table></div>");
        grid.setRowIndex(-1);
    }

    private void encodeSeltionColumnBody(StringBuffer buffer, int rowIndex, String hiddenInputId, String simpleClientId) {
        buffer.append(String.format("<td class='x-grid3-col' align='center' width='%s' style='vertical-align:middle;'>\n", 30));
        buffer.append("<div class='x-grid3-cell-inner'>\n");
        buffer.append("<div unselectable='on' class='x-grid3-cell-text'>\n");
        buffer.append(String.format("<input type='checkbox' onclick='changeSelectState(this, %s, \"%s\")' id='%s' value='%s'>\n", rowIndex, hiddenInputId, simpleClientId + rowIndex, rowIndex));
        buffer.append("</div></div></td>\n");
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }
}

