/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.component.widget.UISwfUpload;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.html.HtmlRenderer;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxSwfUploadRenderer
extends AjaxRendererBase {
    private static final String IMAGE_URL = "/swfupload/browse.jpg";
    private static final String SWF_URL = "/swfupload/swfupload.swf";
    private static final String BUTTON_IMAGE_HEIGHT = "32";
    private static final String BUTTON_IMAGE_WIDTH = "113";
    private static final String BUTTON_TEXT_TOP_PADDING = "5";
    private static final String CANCEL_BUTTON_IMAGE = "/swfupload/cancel.png";
    protected static Map<String, LiteAttributeEncoder> LITE_ATTRIBUTE = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(){
        {
            this.put("buttonText", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    UISwfUpload upload = (UISwfUpload)component;
                    String text = upload.getButtonText();
                    if (text == null) {
                        text = Resources._T((String)"UI_SWF_UPLOAD_UPLOAD");
                    }
                    out.writeScriptBlock(String.format("%1$s.setButtonText(%2$s);}\n", jsvar, HtmlEncoder.enquote((String)text, (Character)Character.valueOf('\''))));
                }
            });
            this.put("fileTypes", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    UISwfUpload upload = (UISwfUpload)component;
                    String text = upload.getFileTypes();
                    if (text != null) {
                        out.writeScriptBlock(String.format("%1$s.setFileTypes(%2$s);}\n", jsvar, HtmlEncoder.enquote((String)text, (Character)Character.valueOf('\''))));
                    }
                }
            });
            this.put("fileSizeMax", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    UISwfUpload upload = (UISwfUpload)component;
                    String text = upload.getFileSizeMax();
                    if (text != null) {
                        out.writeScriptBlock(String.format("%1$s.setFileSizeLimit(%2$s);}\n", jsvar, HtmlEncoder.enquote((String)text, (Character)Character.valueOf('\''))));
                    }
                }
            });
        }
    });

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        String clientId = component.getClientId(context);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        UISwfUpload upload = (UISwfUpload)component;
        out.startElement("div", component);
        out.startElement("span", component);
        out.startElement("span", component);
        out.writeAttribute("id", (Object)(clientId + "_placeHolder"), null);
        out.endElement("span");
        out.endElement("span");
        if (!Boolean.FALSE.equals(upload.getShowProgress())) {
            out.startElement("div", component);
            out.writeAttribute("id", (Object)(clientId + "_fsUploadProgress"), null);
            out.endElement("div");
        }
        if (!Boolean.TRUE.equals(upload.getCustomUI()) && !Boolean.TRUE.equals(upload.getAutoUpload())) {
            out.startElement("div", component);
            out.writeAttribute("class", (Object)"om-swfUpload-linkContainer", null);
            out.startElement("a", component);
            out.writeAttribute("href", (Object)("javascript:" + jsvar + ".startUpload();"), null);
            out.write(Resources._T((String)"UI_SWF_UPLOAD_UPLOAD"));
            out.endElement("a");
            out.startElement("span", component);
            out.write("|");
            out.endElement("span");
            out.startElement("a", component);
            out.writeAttribute("href", (Object)("javascript:" + jsvar + ".cleanQueue();"), null);
            out.write(Resources._T((String)"UI_SWF_UPLOAD_CLEAR"));
            out.endElement("a");
            out.endElement("div");
        }
        out.endElement("div");
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        if (!(component instanceof UISwfUpload)) {
            return;
        }
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        UISwfUpload fileUpload = (UISwfUpload)component;
        String clientId = fileUpload.getClientId(context);
        String jsvar = resource.allocVariable(component);
        ExtConfig commonConfig = new ExtConfig((UIComponent)fileUpload);
        String uploadUrl = HtmlRenderer.getActionURL((FacesContext)context);
        String split = uploadUrl.contains("?") ? "&" : "?";
        uploadUrl = HtmlEncoder.enquote((String)(uploadUrl + split + "swfUploadId=" + HtmlEncoder.encodeURI((String)fileUpload.getId()) + "&" + "__view_delegate_request__" + "="));
        commonConfig.set("upload_url", uploadUrl, true);
        commonConfig.set("flash_url", rm.getResourceURL(SWF_URL));
        commonConfig.set("button_placeholder_id", fileUpload.getClientId(context) + "_placeHolder");
        commonConfig.set("button_image_url", fileUpload.getButtonImage() != null ? fileUpload.getButtonImage() : rm.getResourceURL(IMAGE_URL));
        commonConfig.set("button_width", fileUpload.getButtonWidth() != null ? fileUpload.getButtonWidth() : BUTTON_IMAGE_WIDTH, true);
        commonConfig.set("button_height", fileUpload.getButtonHeight() != null ? fileUpload.getButtonHeight() : BUTTON_IMAGE_HEIGHT, true);
        commonConfig.set("use_query_string", fileUpload.getEnableQueryString() != Boolean.FALSE, true);
        if (Boolean.TRUE.equals(fileUpload.getOriginalButtonTextSetting())) {
            commonConfig.set("button_text", fileUpload.getButtonText());
            commonConfig.set("button_text_style", fileUpload.getButtonTextStyle());
            commonConfig.set("button_text_top_padding", fileUpload.getButtonTextTopPadding(), true);
            commonConfig.set("button_text_left_padding", fileUpload.getButtonTextLeftPadding(), true);
        } else {
            commonConfig.set("button_text", this.getButtonText(fileUpload, context));
            commonConfig.set("button_text_style", this.getTextStyle(fileUpload, context));
            commonConfig.set("button_text_top_padding", fileUpload.getButtonTextTopPadding() == null ? BUTTON_TEXT_TOP_PADDING : fileUpload.getButtonTextTopPadding(), true);
            commonConfig.set("button_text_left_padding", this.calcButtonTextLeftPadding(fileUpload), true);
        }
        commonConfig.set("file_queued_handler", "OM.SwfUpload.fileQueued", true);
        commonConfig.set("swfupload_loaded_handler", this.wrapJSFunction(fileUpload.getOnflashready()), true);
        commonConfig.set("file_queue_error_handler", "OM.SwfUpload.fileQueueError", true);
        commonConfig.set("upload_success_handler", "OM.SwfUpload.uploadSuccess", true);
        commonConfig.set("upload_progress_handler", "OM.SwfUpload.uploadProgress", true);
        commonConfig.set("upload_complete_handler", "OM.SwfUpload.uploadComplete", true);
        commonConfig.set("upload_error_handler", "OM.SwfUpload.uploadError", true);
        commonConfig.set("upload_start_handler", "OM.SwfUpload.uploadStart", true);
        commonConfig.set("file_dialog_complete_handler", "OM.SwfUpload.fileDialogComplete", true);
        commonConfig.set("queue_complete_handler", this.wrapJSFunction(fileUpload.getOnalluploadcomplete()), true);
        commonConfig.set("file_dialog_start_handler", this.wrapJSFunction(fileUpload.getOndialogstart()), true);
        commonConfig.set("file_size_limit", fileUpload.getFileSizeMax());
        commonConfig.set("file_types", fileUpload.getFileTypes());
        commonConfig.set("file_types_description", fileUpload.getFileTypesDescription());
        commonConfig.set("file_queue_limit", fileUpload.getFileQueueLimit(), true);
        commonConfig.set("file_upload_limit", fileUpload.getFileUploadLimit(), true);
        if (!Boolean.FALSE.equals(fileUpload.getEnableHandCursor())) {
            commonConfig.set("button_cursor", "SWFUpload.CURSOR.HAND", true);
        }
        commonConfig.setInitConfigText(fileUpload.getInitConfig());
        ExtConfig customConfig = new ExtConfig();
        customConfig.set("om_progress_target", clientId + "_fsUploadProgress");
        customConfig.set("om_fileSizeLimitMessage", fileUpload.getFileSizeLimitMessage());
        customConfig.set("om_zeroByteFileMessage", fileUpload.getZeroByteFileMessage());
        customConfig.set("om_invalidFileTypeMessage", fileUpload.getInvalidFileTypeMessage());
        customConfig.set("om_queueLimitMessage", fileUpload.getQueueLimitMessage());
        customConfig.set("om_queued", this.wrapJSFunction(fileUpload.getOnfilequeue()), true);
        customConfig.set("om_queued_error", this.wrapJSFunction(fileUpload.getOnqueueerror()), true);
        customConfig.set("om_dialog_complete", this.wrapJSFunction(fileUpload.getOndialogcomplete()), true);
        customConfig.set("om_progress", this.wrapJSFunction(fileUpload.getOnuploadprogress()), true);
        customConfig.set("om_upload_error", this.wrapJSFunction(fileUpload.getOnuploaderror()), true);
        customConfig.set("om_success", this.wrapJSFunction(fileUpload.getOnuploadsuccess()), true);
        customConfig.set("om_complete", this.wrapJSFunction(fileUpload.getOnuploadcomplete()), true);
        customConfig.set("om_clear_queue", this.wrapJSFunction(fileUpload.getOnclearqueue()), true);
        customConfig.set("om_upload_started_handler", this.wrapJSFunction(fileUpload.getOnuploadstart()), true);
        customConfig.set("om_cancel_image", fileUpload.getCancelImage() != null ? fileUpload.getCancelImage() : rm.getResourceURL(CANCEL_BUTTON_IMAGE));
        customConfig.set("om_jsvar", jsvar);
        if (Boolean.TRUE.equals(fileUpload.getAutoUpload())) {
            customConfig.set("om_autoUpload", true);
        }
        customConfig.set("om_show_progress", fileUpload.getShowProgress(), true);
        commonConfig.set("custom_settings", "{" + customConfig.toScript() + "}", true);
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%s=new SWFUpload({%s});", jsvar, commonConfig.toScript());
        resource.addInitScript(fmt.toString());
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return LITE_ATTRIBUTE;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"OM.SwfUpload"};
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"OM.SwfUpload"};
    }

    private String getButtonText(UISwfUpload upload, FacesContext context) {
        return "<span class='" + upload.getClientId(context) + "_text" + "'>" + (upload.getButtonText() == null ? Resources._T((String)"UI_SWF_UPLOAD_BROWSE") : upload.getButtonText()) + "</span>";
    }

    private String getTextStyle(UISwfUpload upload, FacesContext context) {
        return "." + upload.getClientId(context) + "_text {color:#FFFFFF;font-size:15px; margin-left:30px; font-weight:bold;" + (upload.getButtonTextStyle() == null ? "" : upload.getButtonTextStyle()) + "}";
    }

    private String wrapJSFunction(String func) {
        if (func == null) {
            return null;
        }
        return "function() {" + func + "}";
    }

    private Integer calcButtonTextLeftPadding(UISwfUpload upload) {
        if (upload.getButtonTextLeftPadding() != null) {
            return upload.getButtonTextLeftPadding();
        }
        Locale locale = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!Locale.CHINA.equals(locale)) {
            return -7;
        }
        return null;
    }
}

