/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.form.impl.UITextField;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.widget.ajax.AbstractFieldRenderer;
import org.operamasks.faces.util.CompRendererUtils;

public class AjaxTextFieldRenderer
extends AbstractFieldRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!CompRendererUtils.needsDecode(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        UITextField textField = (UITextField)component;
        String emptyText = textField.getEmptyText();
        String newValue = (String)requestMap.get(clientId);
        if (newValue != null) {
            if (emptyText == null) {
                this.setSubmittedValue(component, newValue);
            } else if (emptyText.equals(newValue)) {
                this.setSubmittedValue(component, "");
            } else {
                this.setSubmittedValue(component, newValue);
            }
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        this.encodeAjaxValue(component, uc, out, jsvar);
        Set attrs = uc.getAttributeCandidates(component);
        attrs.remove("value");
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attrs, this.getLiteAttributes());
    }

    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        UITextField field = (UITextField)component;
        if (field.getRegex() != null) {
            config.remove("regex");
            config.set("regex", field.getRegex(), true);
        }
        if (field.getMaskRe() != null) {
            config.remove("maskRe");
            config.set("maskRe", field.getMaskRe(), true);
        }
    }

    protected String getExtClass(UIComponent component) {
        return "Ext.form.TextField";
    }

    protected String getHtmlMarkup() {
        return "input";
    }
}

