/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.MenuItemRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxTextMenuItemRenderer
extends AjaxRendererBase
implements MenuItemRenderer {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxTextMenuItemRenderer() {
        liteAttrCore.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                if (RendererUtils.isDisabled((UIComponent)component)) {
                    out.writeScriptBlock(String.format("if(typeof(%1$s) != 'undefined'){%1$s.disable();}\n", jsvar));
                } else {
                    out.writeScriptBlock(String.format("if(typeof(%1$s) != 'undefined'){%1$s.enable();}\n", jsvar));
                }
            }
        });
        liteAttrCore.put("label", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String text = HtmlEncoder.enquote((String)MenuRendererHelper.getItemText(context, component, false), (Character)Character.valueOf('\''));
                StringBuilder sb = new StringBuilder();
                Formatter fmt = new Formatter(sb);
                sb.append("try {");
                fmt.format("if(%1$s){var %1$s_text = %1$s.getEl().select('b');\n", jsvar);
                fmt.format("if(%s_text && %s_text != null) {\n", jsvar, jsvar);
                fmt.format("%s_text.first().dom.innerHTML=%s;\n", jsvar, text);
                sb.append("}}");
                sb.append("} catch(e){}\n");
                out.writeScriptBlock(sb.toString());
            }
        });
        liteAttrCore.put("image", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String icon = MenuRendererHelper.getItemIcon(context, component);
                icon = icon == null ? "Ext.BLANK_IMAGE_URL" : HtmlEncoder.enquote((String)icon, (Character)Character.valueOf('\''));
                StringBuffer sb = new StringBuffer();
                Formatter fmt = new Formatter(sb);
                fmt.format("if(typeof(%1$s) != 'undefined'){%1$s.icon=%2$s;}\n", jsvar, icon);
                sb.append("try {");
                fmt.format("if(%1$s){var %1$s_icon = %1$s.getEl().select('img');\n", jsvar);
                fmt.format("if(%s_icon && %s_icon != null) {\n", jsvar, jsvar);
                fmt.format("%s_icon.first().dom.src=%s;\n", jsvar, icon);
                sb.append("}}");
                sb.append("} catch(e){}\n");
                out.writeScriptBlock(sb.toString());
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        UIMenu menu = MenuRendererHelper.getParentMenu(component);
        if (menu == null) {
            return;
        }
        ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]).addInitScript(this.getMenuItemInitScript(context, component, (UIComponent)menu));
    }

    public String getMenuItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        String text = MenuRendererHelper.getItemText(context, component, true);
        String icon = MenuRendererHelper.getItemIcon(context, component);
        Formatter fmt = new Formatter();
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        String itemJsVar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String iconHTML = icon == null ? "" : new Formatter().format("<img alt='%s' align='absmiddle' src='%s' width='16' height='16' />", text, icon).toString();
        fmt.format("%s%s=new %s(\"%s<b class='menu-title'>%s</b>\");", RendererUtils.getJsvarAliasDef((String)itemJsVar, (Aliases)alias), itemJsVar, alias.alias("Ext.menu.TextItem"), iconHTML, text);
        String menuJsVar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent);
        fmt.format("%s.addItem(%s);", alias.var(menuJsVar), alias.var(itemJsVar));
        return fmt.toString();
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

