/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.tree.base.TreeDataProvider;
import org.operamasks.faces.component.tree.impl.UITree;
import org.operamasks.faces.component.tree.impl.UITreeNode;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.TreeRenderHelper;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxTreeRenderer
extends AjaxRendererBase {
    public static final String DELEGATE_PARAM = "_ajaxTree";
    private static final String TREE_EVENT_NAME_KEY = "_eventName";
    private static final String TREE_EVENT_NODE_KEY = "_eventNode";
    private static final String TREE_SELECTED_NODE_KEY = "_selectedNode";
    private static final String TREE_CHECKED_NODES_KEY = "_checkedNodes";
    private static final String TREE_EXPANDED_NODES_KEY = "_expandedNodes";
    private static final String TREE_NODE_USERDATA_KEY = "_node_userData";
    public static final String TREE_LOADER_SUBFIX = "_loader";
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(){
        {
            this.put("expandAll", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    out.writeScriptBlock(String.format("%s.expandAll();", jsvar));
                }
            });
            this.put("collapseAll", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    out.writeScriptBlock(String.format("%s.collapseAll();", jsvar));
                }
            });
            this.put("styleClass", null);
            this.put("style", AjaxStyleEncoder.getInstance());
        }
    });

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.tree.TreePanel", "Ext.tree.CheckTreeNode", "Ext.tree.SimpleCheckTreeNode"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(FacesContext context, UIComponent component) {
        Object lock;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Object object = lock = TreeRenderHelper.getLock();
        synchronized (object) {
            UITree tree = TreeRenderHelper.loadComponentTree(component.getClientId(context));
            tree = tree != null ? TreeRenderHelper.replaceRootTreeNode(tree, (UITree)component) : (UITree)component;
            this.clearTreeState(tree);
            this.buildTreeState(context, tree);
            TreeRenderHelper.saveComponentTree(tree);
        }
    }

    private void clearTreeState(UITree tree) {
        tree.setEventNode(null);
        tree.setSelectedNode(null);
        tree.setExpandedNodes("");
        Iterator kids = FacesUtils.createChildrenIterator((UIComponent)tree, (boolean)false);
        while (kids.hasNext()) {
            UITreeNode treeNode;
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UITreeNode) || !Boolean.TRUE.equals((treeNode = (UITreeNode)kid).getChecked())) continue;
            treeNode.setCheckedWithoutScript(false);
        }
    }

    private void buildTreeState(FacesContext context, UITree tree) {
        String clientId = tree.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)requestMap.get(String.valueOf(clientId) + TREE_EVENT_NAME_KEY);
        if (eventName != null) {
            String expandedNodesParam;
            String checkedNodes;
            String selectedNode;
            tree.setEventName(eventName);
            String eventNode = (String)requestMap.get(String.valueOf(clientId) + TREE_EVENT_NODE_KEY);
            if (eventNode != null && !"".equals(eventNode)) {
                tree.setEventNode((UITreeNode)tree.findComponent(eventNode));
            }
            if ((selectedNode = (String)requestMap.get(String.valueOf(clientId) + TREE_SELECTED_NODE_KEY)) != null && !"".equals(selectedNode)) {
                UITreeNode node = (UITreeNode)tree.findComponent(selectedNode);
                tree.setSelectedNode(node);
            }
            if ((checkedNodes = (String)requestMap.get(String.valueOf(clientId) + TREE_CHECKED_NODES_KEY)) != null && !"".equals(checkedNodes)) {
                String[] nodes;
                String[] stringArray = nodes = checkedNodes.split(",");
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    String node = stringArray[n2];
                    UITreeNode checkedTreeNode = (UITreeNode)tree.findComponent(node);
                    if (checkedTreeNode != null) {
                        checkedTreeNode.setCheckedWithoutScript(true);
                    }
                    ++n2;
                }
            }
            if ((expandedNodesParam = (String)requestMap.get(String.valueOf(clientId) + TREE_EXPANDED_NODES_KEY)) != null) {
                tree.setExpandedNodes(expandedNodesParam);
            }
            Iterator kids = FacesUtils.createChildrenIterator((UIComponent)tree, (boolean)false);
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (!(kid instanceof UITreeNode)) continue;
                UITreeNode node = (UITreeNode)kid;
                String clientUserData = (String)requestMap.get(String.valueOf(clientId) + "_" + node.getId() + TREE_NODE_USERDATA_KEY);
                if (clientUserData == null || node.getUserData() != null) continue;
                node.setUserData(clientUserData);
            }
        }
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)clientId, null);
        UITree tree = (UITree)component;
        String style = tree.getStyle();
        String styleClass = tree.getStyleClass();
        String defaultStyle = "";
        style = style != null ? String.valueOf(defaultStyle) + style : defaultStyle;
        if (tree.getHeight() != null) {
            style = String.format("%sheight: %spx;", style, tree.getHeight());
        }
        if (tree.getWidth() != null) {
            style = String.format("%swidth:%spx;", style, tree.getWidth());
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, null);
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.endElement("div");
        out.write("\n");
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UITree tree = (UITree)component;
        this.buildChildNodes(context, (UIComponent)tree);
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String jsvar = resource.allocVariable(component);
        String clientId = component.getClientId(context);
        Formatter fmt = new Formatter(new StringBuffer());
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("tree");
        String jsvar_loader = String.valueOf(jsvar) + TREE_LOADER_SUBFIX;
        resource.addVariable(jsvar_loader);
        fmt.format("%s%s=new %s({", RendererUtils.getJsvarAliasDef((String)jsvar_loader, (Aliases)alias), jsvar_loader, alias.alias("Ext.tree.TreeLoader"));
        fmt.format("dataUrl:%s,", AjaxTreeRenderer.getActionURLVar());
        fmt.format("baseParams:{", new Object[0]);
        fmt.format("'%s':'%s'", DELEGATE_PARAM, clientId);
        fmt.format(",'%s':''", "__view_delegate_request__");
        fmt.format("}});", new Object[0]);
        fmt.format("%s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.tree.TreePanel"), c.start());
        ExtConfig config = new ExtConfig(component);
        config.set("loader", alias.var(jsvar_loader), true);
        config.set("selModel", "new " + alias.alias("Ext.tree.DefaultSelectionModel"), true);
        if (tree.getBorder() == null) {
            config.set("border", false);
        }
        CompRendererUtils.mergeUserExtConfig(component, config);
        fmt.format(config.toScript(c), new Object[0]);
        fmt.format("}%s);", c.end());
        c = alias.configBuilder("treenode");
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UITreeNode)) continue;
            UITreeNode node = (UITreeNode)child;
            if (Boolean.TRUE.equals(node.isRendered())) {
                fmt.format("%s.setRootNode(new %s(%s{", alias.var(jsvar), alias.alias("Ext.tree.AsyncTreeNode"), c.start());
                fmt.format(TreeRenderHelper.getTreeNodeConfig(node, c), new Object[0]);
                fmt.format("}%s));", c.end());
            }
            fmt.format("%s.render('%s');", alias.var(jsvar), clientId);
            break;
        }
        resource.addInitScript(fmt.toString());
        TreeRenderHelper.saveComponentTree((UITree)component);
    }

    private void buildChildNodes(FacesContext context, UIComponent component) {
        UITree tree = (UITree)component;
        TreeDataProvider dataProvider = tree.getValue();
        if (dataProvider != null) {
            for (UIComponent c : tree.getChildren()) {
                if (!(c instanceof UITreeNode)) continue;
                tree.getChildren().remove(c);
            }
            boolean loadAllNodes = tree.getLoadAllNodes() != null && tree.getLoadAllNodes() != false || tree.getExpandAll() != null && tree.getExpandAll() != false;
            TreeRenderHelper.buildNodesByCondition(tree, dataProvider, (UIComponent)tree, null, loadAllNodes);
        } else {
            this.applyNodesLeafValue((UIComponent)tree, tree.getAutoLeaf());
        }
    }

    private void applyNodesLeafValue(UIComponent component, Boolean autoLeaf) {
        if (autoLeaf == null) {
            return;
        }
        for (UIComponent c : component.getChildren()) {
            if (!(c instanceof UITreeNode)) continue;
            UITreeNode node = (UITreeNode)c;
            if (node.getChildCount() == 0 && node.getLeaf() == null) {
                node.setLeaf(autoLeaf);
                continue;
            }
            this.applyNodesLeafValue((UIComponent)node, autoLeaf);
        }
    }

    public void encodeResourceEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UITree tree = (UITree)component;
        Formatter fmt = new Formatter(new StringBuffer());
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
        String clientId = tree.getClientId(context);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        for (String event : this.getSupportEvents(tree)) {
            String eventName = event.replaceFirst("on", "");
            Object eventHanlder = tree.getAttributes().get(event);
            String ajaxActionScript = eventHanlder == null ? "" : eventHanlder.toString();
            fmt.format("%s(%s,'%s','%s'", alias.alias("OM.SC.registerTreeEvent"), alias.var(jsvar), eventName, clientId);
            if (ajaxActionScript.length() > 0) {
                fmt.format(",function(node){%s}", ajaxActionScript);
            }
            fmt.format(");", new Object[0]);
        }
        String selectHandler = tree.getOnselect();
        if (selectHandler == null) {
            selectHandler = "";
        }
        fmt.format("%s(%s,'%s'", alias.alias("OM.SC.registerTreeOnSelect"), jsvar, clientId);
        if (selectHandler.length() > 0) {
            fmt.format(",function(selectionModel,node){%s}", selectHandler);
        }
        fmt.format(");", new Object[0]);
        if (Boolean.TRUE.equals(tree.getExpandAll())) {
            fmt.format("window.%sIsExpandAll = true;\n", jsvar);
            fmt.format("%s.expandAll();\n", jsvar);
        }
        String jsvar_loader = String.valueOf(jsvar) + TREE_LOADER_SUBFIX;
        fmt.format("%s(%s,'%s','%s');", alias.alias("OM.SC.registerTreeOnLoad"), alias.var(jsvar_loader), alias.var(jsvar), clientId);
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        resource.addInitScript(fmt.toString());
    }

    private List<String> getSupportEvents(UITree tree) {
        ArrayList<String> events = new ArrayList<String>();
        events.add("oncheck");
        events.add("onselect");
        events.add("onclick");
        events.add("oncollapsenode");
        events.add("onexpandnode");
        events.add("oncontextmenu");
        return events;
    }

    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UITree tree = (UITree)component;
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        Formatter fmt = new Formatter(new StringBuffer());
        boolean hasEvent = false;
        for (String event : this.getSupportEvents(tree)) {
            if (tree.getAttributes().get(event) == null) continue;
            hasEvent = true;
            break;
        }
        if (hasEvent && FacesUtils.getParentForm((UIComponent)tree) == null) {
            context.getApplication().getViewHandler().writeState(context);
        }
        resource.addInitScript(fmt.toString());
    }

    public void expandAll(UITree tree) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)tree, new String[]{"expandAll"});
    }

    public void collapseAll(UITree tree) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)tree, new String[]{"collapseAll"});
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        UIForm parentForm = FacesUtils.getParentForm((UIComponent)component);
        if (parentForm != null && !parentForm.isSubmitted()) {
            return;
        }
        TreeRenderHelper.saveComponentTree((UITree)component);
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }

    public void expand(UITree tree, String treeNodeId, boolean deep) {
        FacesContext context = FacesContext.getCurrentInstance();
        String treeJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
        String expandScript = String.format("if(%1$s.getNodeById(%2$s)){%1$s.getNodeById(%2$s).expand(%3$b);}", treeJsvar, HtmlEncoder.enquote((String)treeNodeId), deep);
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(expandScript);
    }

    public void collapse(UITree tree, String treeNodeId, boolean deep) {
        FacesContext context = FacesContext.getCurrentInstance();
        String treeJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
        String collapseScript = String.format("if(%1$s.getNodeById(%2$s)){%1$s.getNodeById(%2$s).collapse(%3$b);}", treeJsvar, HtmlEncoder.enquote((String)treeNodeId), deep);
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(collapseScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(UITree tree) {
        Object lock;
        Object object = lock = TreeRenderHelper.getLock();
        synchronized (object) {
            boolean loadAllNodes = tree.getLoadAllNodes() != null && tree.getLoadAllNodes() != false || tree.getExpandAll() != null && tree.getExpandAll() != false;
            TreeDataProvider dataProvider = tree.getValue();
            if (dataProvider != null) {
                List children = tree.getChildren();
                if (children.size() > 0) {
                    int index = 0;
                    while (index < children.size()) {
                        UIComponent child = (UIComponent)children.get(index);
                        if (child instanceof UITreeNode) {
                            children.remove(index);
                            continue;
                        }
                        ++index;
                    }
                }
                TreeRenderHelper.buildNodesByCondition(tree, tree.getValue(), (UIComponent)tree, null, loadAllNodes);
                TreeRenderHelper.saveComponentTree(tree);
            }
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
        String jsvar_loader = String.valueOf(jsvar) + TREE_LOADER_SUBFIX;
        StringBuffer buf = new StringBuffer();
        Formatter fmt = new Formatter(buf);
        fmt.format("replaceRootNode(%s.getRootNode(),{%s});\n", jsvar, TreeRenderHelper.getTreeNodeConfig(tree.getRootNode(), null));
        fmt.format("updateTreeNode(%1$s, %2$s, '');\n", jsvar, jsvar_loader);
        RendererUtils.addOperationScript((String)fmt.toString());
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource.getResourceInstance((ResourceManager)rm).addInitScript(AjaxTreeRenderer.getActionURLVarDefinition((FacesContext)context));
    }
}

