/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.SelectItem;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.ajax.AjaxUISelectRenderer;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.util.HtmlEncoder;

public abstract class RadioMenuItemRenderer
extends AjaxUISelectRenderer {
    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly((UIComponent)component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            String newValue = (String)paramMap.get(clientId);
            this.setSubmittedValue(component, newValue);
            ActionEvent event = new ActionEvent(component);
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void renderCurrentValue(FacesContext context, UIComponent component, String currentValue) throws IOException {
        String clientId = component.getClientId(context);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        out.writeAttribute("value", (Object)currentValue, "value");
        out.endElement("input");
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        String formId;
        UIMenu menu = MenuRendererHelper.getParentMenu(component);
        if (menu == null) {
            return;
        }
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        String menuId = FacesUtils.getJsvar((FacesContext)context, (UIComponent)menu);
        String clientId = component.getClientId(context);
        String jsvar = resource.allocTempVariable();
        List<SelectItem> items = this.getSelectItems(context, component);
        boolean disabled = RendererUtils.isDisabled((UIComponent)component);
        String onbeforechange = (String)component.getAttributes().get("onbeforechange");
        String onchange = (String)component.getAttributes().get("onchange");
        String onclick = (String)component.getAttributes().get("onclick");
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        String string = formId = form != null ? form.getClientId(context) : null;
        if (onchange == null) {
            onchange = "";
        } else if (!onchange.endsWith(";")) {
            onchange = onchange + ";";
        }
        Formatter fmt = new Formatter();
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        for (int i = 0; i < items.size(); ++i) {
            SelectItem item = items.get(i);
            fmt.format("%s", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias));
            fmt.format("%s=new %s(%s{", jsvar, alias.alias("Ext.menu.CheckItem"), c.start());
            MenuRendererHelper.encodeItemConfig(fmt, context, component, item.getLabel(), c);
            fmt.format(",%s:'%s'", c.prop("group"), clientId);
            if (this.isOneSelected(context, component, item.getValue())) {
                fmt.format(",%s:true", c.prop("checked"));
            }
            if (!disabled && item.isDisabled()) {
                fmt.format(",%s:true", c.prop("disabled"));
            }
            fmt.format("}%s);", c.end());
            if (onbeforechange != null) {
                fmt.format("%s.on('beforecheckchange', function(item,checked){%s});", alias.var(jsvar), onbeforechange);
            }
            if (form != null) {
                String itemValue = this.getFormattedValue(context, component, item.getValue());
                itemValue = HtmlEncoder.enquote((String)itemValue, (Character)Character.valueOf('\''));
                fmt.format("%1$s.on('checkchange', function(item,checked){%2$sif(checked){Ext.get('%3$s').value = %4$s;document.forms['%5$s'].submit();}});", alias.var(jsvar), onchange, clientId, itemValue, formId);
            } else if (onchange != null) {
                fmt.format("%s.on('checkchange', function(item,checked){%s});", alias.var(jsvar), onchange);
            }
            if (onclick != null) {
                fmt.format("%s.on('click', function(){%s});", alias.var(jsvar), onclick);
            }
            fmt.format("%s.addItem(%s);", menuId, alias.var(jsvar));
        }
        resource.releaseVariable(jsvar);
        resource.addInitScript(fmt.toString());
    }
}

