/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.component.grid.GridColumn;
import org.operamasks.faces.component.grid.GridColumnModel;
import org.operamasks.faces.component.grid.impl.UIEditDataGrid;
import org.operamasks.faces.component.grid.provider.GridRowDataProvider;
import org.operamasks.faces.component.grid.provider.ValueExpressionRowDataProvider;
import org.operamasks.faces.render.widget.ajax.AjaxEditDataGridRenderer;
import org.operamasks.org.json.simple.JSONArray;
import org.operamasks.org.json.simple.JSONObject;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDataGridHelper {
    public static void applyData(FacesContext context, UIEditDataGrid grid, ChangedData data) {
        if (grid.getBindBean() != null) {
            EditDataGridHelper.applyBindBean(context, grid, data);
        } else {
            grid.setAddedData(data.addedData);
            grid.setModifiedData(data.modifiedData);
            grid.setRemovedData(data.removedData);
        }
    }

    private static void applyBindBean(FacesContext context, UIEditDataGrid grid, ChangedData data) {
        Object bindBean = grid.getBindBean();
        Class bindBeanClass = null;
        Method facMethod = null;
        if (bindBean instanceof String) {
            try {
                bindBeanClass = Utils.findClass((String)((String)bindBean), (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                try {
                    bindBeanClass = Utils.findClass((String)((String)bindBean), (ClassLoader)AjaxEditDataGridRenderer.class.getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    throw new FacesException((Throwable)e1);
                }
            }
        } else if (bindBean instanceof Class) {
            bindBeanClass = (Class)bindBean;
        } else {
            try {
                facMethod = bindBean.getClass().getMethod("createBean", new Class[0]);
            }
            catch (Exception e) {
                bindBeanClass = bindBean.getClass();
            }
        }
        if (facMethod != null) {
            EditDataGridHelper.populateBindBean(context, grid, data, bindBean, facMethod);
        } else if (bindBeanClass != null) {
            EditDataGridHelper.populateBindBean(context, grid, data, bindBeanClass);
        } else {
            throw new FacesException("could find bean class or method named 'createBean' from bindBean attribute");
        }
    }

    private static void populateBindBean(FacesContext context, UIEditDataGrid grid, ChangedData changedData, Class<?> bindBeanClass) {
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(bindBeanClass);
        }
        catch (IntrospectionException e) {
            throw new FacesException("could not get bind bean info", (Throwable)e);
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> pdMap = new HashMap<String, PropertyDescriptor>(pds.length, 1.0f);
        for (PropertyDescriptor aPd : pds) {
            pdMap.put(aPd.getName(), aPd);
        }
        int length = 0;
        Object beans = null;
        length = changedData.addedData.size();
        if (length > 0) {
            beans = EditDataGridHelper.createBeanArrayFromClass(bindBeanClass, length);
            EditDataGridHelper.populateData(context, grid, changedData.addedData, beans, pdMap);
            grid.setAddedData(beans);
        }
        if ((length = changedData.modifiedData.size()) > 0) {
            beans = EditDataGridHelper.createBeanArrayFromClass(bindBeanClass, length);
            EditDataGridHelper.populateData(context, grid, changedData.modifiedData, beans, pdMap);
            grid.setModifiedData(beans);
        }
        if ((length = changedData.removedData.size()) > 0) {
            beans = EditDataGridHelper.createBeanArrayFromClass(bindBeanClass, length);
            EditDataGridHelper.populateData(context, grid, changedData.removedData, beans, pdMap);
            grid.setRemovedData(beans);
        }
    }

    private static void populateBindBean(FacesContext context, UIEditDataGrid grid, ChangedData changedData, Object bindBean, Method facMethod) {
        BeanInfo info;
        Object bean = null;
        try {
            bean = facMethod.invoke(bindBean, new Object[0]);
        }
        catch (Exception e) {
            throw new FacesException("could not create bean instance", (Throwable)e);
        }
        Class<?> bindBeanClass = bean.getClass();
        try {
            info = Introspector.getBeanInfo(bindBeanClass);
        }
        catch (IntrospectionException e) {
            throw new FacesException("could not get bind bean info", (Throwable)e);
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> pdMap = new HashMap<String, PropertyDescriptor>(pds.length, 1.0f);
        for (PropertyDescriptor aPd : pds) {
            pdMap.put(aPd.getName(), aPd);
        }
        int length = 0;
        Object beans = null;
        length = changedData.addedData.size();
        if (length > 0) {
            beans = EditDataGridHelper.createBeanArrayFromFac(bindBeanClass, bindBean, facMethod, length);
            EditDataGridHelper.populateData(context, grid, changedData.addedData, beans, pdMap);
            grid.setAddedData(beans);
        }
        if ((length = changedData.modifiedData.size()) > 0) {
            beans = EditDataGridHelper.createBeanArrayFromFac(bindBeanClass, bindBean, facMethod, length);
            EditDataGridHelper.populateData(context, grid, changedData.modifiedData, beans, pdMap);
            grid.setModifiedData(beans);
        }
        if ((length = changedData.removedData.size()) > 0) {
            beans = EditDataGridHelper.createBeanArrayFromFac(bindBeanClass, bindBean, facMethod, length);
            EditDataGridHelper.populateData(context, grid, changedData.removedData, beans, pdMap);
            grid.setRemovedData(beans);
        }
    }

    private static Object createBeanArrayFromClass(Class<?> bindBeanClass, int length) {
        Object beans = Array.newInstance(bindBeanClass, length);
        Object bean = null;
        for (int i = 0; i < length; ++i) {
            try {
                bean = bindBeanClass.newInstance();
            }
            catch (Exception e) {
                throw new FacesException("could not create bean instance", (Throwable)e);
            }
            Array.set(beans, i, bean);
        }
        return beans;
    }

    private static Object createBeanArrayFromFac(Class bindBeanClass, Object bindBean, Method facMethod, int length) {
        Object beans = Array.newInstance(bindBeanClass, length);
        for (int i = 0; i < length; ++i) {
            Object bean = null;
            try {
                bean = facMethod.invoke(bindBean, new Object[0]);
            }
            catch (Exception e) {
                throw new FacesException("could not create bean instance", (Throwable)e);
            }
            Array.set(beans, i, bean);
        }
        return beans;
    }

    private static void populateData(FacesContext context, UIEditDataGrid grid, JSONArray dataArray, Object beans, HashMap<String, PropertyDescriptor> pdMap) {
        int length = dataArray.size();
        for (int i = 0; i < length; ++i) {
            JSONObject data = (JSONObject)dataArray.get(i);
            Object bean = Array.get(beans, i);
            ExpressionFactory ef = context.getApplication().getExpressionFactory();
            ELContext elContext = context.getELContext();
            Map request = context.getExternalContext().getRequestMap();
            String beanDataKey = "_beanData";
            request.put(beanDataKey, bean);
            for (Object entryObj : data.entrySet()) {
                Map.Entry entry = (Map.Entry)entryObj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                String propName = key.toString();
                PropertyDescriptor pd = pdMap.get(propName);
                GridColumn column = grid.getColumnModel().getColumn(key.toString());
                if (column != null) {
                    Converter converter = EditDataGridHelper.getConverter(context, column);
                    if (converter != null) {
                        value = converter.getAsObject(context, (UIComponent)grid, value == null ? null : value.toString());
                    }
                    if (pd != null) {
                        value = TypeCoercion.coerce(value, pd.getPropertyType());
                    }
                    ValueExpressionRowDataProvider vr = (ValueExpressionRowDataProvider)grid.getDefaultRowDataProvider();
                    vr.setValue(bean, column, value);
                    continue;
                }
                String expression = "#{".concat(beanDataKey).concat(".").concat(propName).concat("}");
                if (pd == null) continue;
                value = TypeCoercion.coerce(value, pd.getPropertyType());
                ValueExpression ve = ef.createValueExpression(elContext, expression, pd.getPropertyType());
                ve.setValue(elContext, value);
            }
            request.remove(beanDataKey);
        }
    }

    public static String createRecord(UIEditDataGrid grid) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        GridColumnModel model = grid.getColumnModel();
        GridColumn[] columns = model.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("{ name:");
            GridColumn column = columns[i];
            buf.append('\'').append(column.getId()).append("'}");
        }
        if (buf.length() > 0) {
            buf.append(",{").append("name:'").append("_serverRowIndex").append("'}");
        }
        buf.append("]");
        return buf.toString();
    }

    public static String encodeRecordValue(UIEditDataGrid grid, Object rowData, StringBuilder modified, String modifiedVar) {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        FacesContext context = FacesContext.getCurrentInstance();
        GridRowDataProvider rowProvider = grid.getRowDataProvider();
        GridRowDataProvider defaultRowProvider = grid.getDefaultRowDataProvider();
        GridColumnModel model = grid.getColumnModel();
        GridColumn[] columns = model.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            GridColumn column = columns[i];
            String columnId = column.getId();
            buf.append(columnId).append(":");
            if (rowData != null) {
                Converter converter;
                Object rowValue = null;
                if (rowProvider != null) {
                    rowValue = rowProvider.getLabel(rowData, column);
                }
                if (rowValue == null) {
                    rowValue = defaultRowProvider.getLabel(rowData, column);
                }
                if ((converter = EditDataGridHelper.getConverter(context, column)) != null) {
                    rowValue = converter.getAsString(context, (UIComponent)grid, rowValue);
                }
                if (rowValue != null && !(rowValue instanceof Number)) {
                    rowValue = rowValue.toString();
                }
                if (rowValue != null) {
                    String escapedValue = rowValue.toString().replaceAll("'", "\\\\'");
                    modified.append(modifiedVar).append("['").append(columnId).append("']");
                    modified.append("='").append(escapedValue).append("';\n");
                    buf.append("'").append(escapedValue).append("'");
                    continue;
                }
                modified.append(modifiedVar).append("['").append(columnId).append("']");
                modified.append("=null;\n");
                buf.append("null");
                continue;
            }
            buf.append("null");
        }
        if (buf.length() > 0) {
            buf.append(",").append("_serverRowIndex").append(":null");
        }
        buf.append("}\n");
        return buf.toString();
    }

    private static Converter getConverter(FacesContext context, GridColumn column) {
        String converterId;
        Converter converter = column.getAttachedConverter();
        if (converter == null && (converterId = column.getConverter()) != null) {
            converter = context.getApplication().createConverter(converterId);
        }
        return converter;
    }

    static class ChangedData {
        JSONArray addedData = new JSONArray();
        JSONArray modifiedData = new JSONArray();
        JSONArray removedData = new JSONArray();

        public ChangedData(JSONArray modifiedData, JSONArray removedData) {
            if (modifiedData != null) {
                this.calcModifiedData(modifiedData);
            }
            if (removedData != null) {
                this.removedData = removedData;
            }
        }

        private void calcModifiedData(JSONArray modifiedData) {
            for (Object data : modifiedData) {
                Object rowIndex = ((JSONObject)data).get((Object)"_serverRowIndex");
                if (rowIndex == null) {
                    this.addedData.add(data);
                    continue;
                }
                this.modifiedData.add(data);
            }
        }
    }
}

